/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.web.search;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.web.search.DocumentSearchResult;
import org.apache.ctakes.ytex.web.search.DocumentSearchService;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class DocumentSearchServiceImpl
implements DocumentSearchService,
InitializingBean {
    private static final Log log = LogFactory.getLog(DocumentSearchServiceImpl.class);
    private DataSource dataSource;
    private SimpleJdbcTemplate jdbcTemplate;
    private String query;
    private Properties searchProperties;
    private SessionFactory sessionFactory;
    private Properties ytexProperties;

    public void afterPropertiesSet() throws Exception {
        this.query = this.searchProperties.getProperty("retrieveDocumentByCUI").replaceAll("@db\\.schema@", this.getYtexProperties().getProperty("db.schema"));
    }

    @Override
    public List<DocumentSearchResult> extendedSearch(String code, String documentTypeName, Date dateFrom, Date dateTo, Integer patientId, Boolean negationStatus) {
        Map<String, Object> mapArgs = this.initMapArgs(code);
        if (documentTypeName != null) {
            mapArgs.put("document_type_name", documentTypeName);
        }
        if (dateFrom != null) {
            mapArgs.put("from_doc_date", dateFrom);
        }
        if (dateTo != null) {
            mapArgs.put("to_doc_date", dateTo);
        }
        if (patientId != null) {
            mapArgs.put("patient_id", patientId);
        }
        if (negationStatus != null) {
            mapArgs.put("certainty", negationStatus != false ? 0 : -1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("executing query, query=" + this.query + ", args=" + mapArgs));
        }
        return this.jdbcTemplate.query(this.query, (RowMapper)new DocumentSearchResultMapper(), mapArgs);
    }

    @Override
    public List<Map<String, Object>> fullTextSearch(String searchTerm) {
        return this.jdbcTemplate.queryForList(this.searchProperties.getProperty("retrieveDocumentFullText"), new Object[]{searchTerm});
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getFullTextSearchDocument(int documentId) {
        return (String)this.jdbcTemplate.queryForObject(this.searchProperties.getProperty("retrieveFullTextSearchDocument"), String.class, new Object[]{documentId});
    }

    public Properties getSearchProperties() {
        return this.searchProperties;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Properties getYtexProperties() {
        return this.ytexProperties;
    }

    private Map<String, Object> initMapArgs(String code) {
        HashMap<String, Object> mapArgs = new HashMap<String, Object>(1);
        mapArgs.put("code", code);
        mapArgs.put("document_type_name", null);
        mapArgs.put("from_doc_date", null);
        mapArgs.put("to_doc_date", null);
        mapArgs.put("patient_id", null);
        mapArgs.put("certainty", null);
        return mapArgs;
    }

    @Override
    public List<DocumentSearchResult> searchByCui(String code) {
        Map<String, Object> mapArgs = this.initMapArgs(code);
        return this.jdbcTemplate.query(this.query, (RowMapper)new DocumentSearchResultMapper(), mapArgs);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    public void setSearchProperties(Properties searchProperties) {
        this.searchProperties = searchProperties;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setYtexProperties(Properties ytexProperties) {
        this.ytexProperties = ytexProperties;
    }

    public static class DocumentSearchResultMapper
    implements RowMapper<DocumentSearchResult> {
        public DocumentSearchResult mapRow(ResultSet rs, int rowNum) throws SQLException {
            DocumentSearchResult result = new DocumentSearchResult();
            result.setCuiText(rs.getString("cui_text"));
            result.setDocumentDate(rs.getDate("doc_date"));
            result.setDocumentID(rs.getInt("document_id"));
            result.setDocumentTitle(rs.getString("doc_title"));
            result.setDocumentTypeName(rs.getString("document_type_name"));
            result.setSentenceText(rs.getString("sentence_text"));
            return result;
        }
    }
}

