/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.env;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.SCXMLExecutor;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.model.ModelException;

public class SimpleScheduler
implements EventDispatcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private Log log = LogFactory.getLog((Class)SimpleScheduler.class);
    private Map timers;
    private SCXMLExecutor executor;
    private static final String TARGETTYPE_SCXML = "scxml";
    private static final String EVENT_ERR_SEND_TARGETUNAVAILABLE = "error.send.targetunavailable";

    public SimpleScheduler(SCXMLExecutor executor) {
        this.executor = executor;
        this.timers = Collections.synchronizedMap(new HashMap());
    }

    public void cancel(String sendId) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("cancel( sendId: " + sendId + ")"));
        }
        if (!this.timers.containsKey(sendId)) {
            return;
        }
        Timer timer = (Timer)this.timers.get(sendId);
        if (timer != null) {
            timer.cancel();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cancelled event scheduled by <send> with id '" + sendId + "'"));
            }
        }
        this.timers.remove(sendId);
    }

    public void send(String sendId, String target, String targettype, String event, Map params, Object hints, long delay, List externalNodes) {
        if (this.log.isInfoEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("send ( sendId: ").append(sendId);
            buf.append(", target: ").append(target);
            buf.append(", targetType: ").append(targettype);
            buf.append(", event: ").append(event);
            buf.append(", params: ").append(String.valueOf(params));
            buf.append(", hints: ").append(String.valueOf(hints));
            buf.append(", delay: ").append(delay);
            buf.append(')');
            this.log.info((Object)buf.toString());
        }
        if (SCXMLHelper.isStringEmpty(targettype) || targettype.trim().equalsIgnoreCase(TARGETTYPE_SCXML)) {
            if (!SCXMLHelper.isStringEmpty(target)) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("<send>: Unavailable target - " + target));
                }
                try {
                    this.executor.triggerEvent(new TriggerEvent(EVENT_ERR_SEND_TARGETUNAVAILABLE, 5));
                }
                catch (ModelException me) {
                    this.log.error((Object)me.getMessage(), (Throwable)me);
                }
                return;
            }
            if (delay > 0L) {
                Timer timer = new Timer(true);
                timer.schedule((TimerTask)new DelayedEventTask(sendId, event, params), delay);
                this.timers.put(sendId, timer);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Scheduled event '" + event + "' with delay " + delay + "ms, as specified by <send> with id '" + sendId + "'"));
                }
            }
        }
    }

    protected Log getLog() {
        return this.log;
    }

    protected Map getTimers() {
        return this.timers;
    }

    protected SCXMLExecutor getExecutor() {
        return this.executor;
    }

    class DelayedEventTask
    extends TimerTask {
        private String sendId;
        private String event;
        private Map payload;

        DelayedEventTask(String sendId, String event) {
            this(sendId, event, null);
        }

        DelayedEventTask(String sendId, String event, Map payload) {
            this.sendId = sendId;
            this.event = event;
            this.payload = payload;
        }

        public void run() {
            try {
                SimpleScheduler.this.executor.triggerEvent(new TriggerEvent(this.event, 3, this.payload));
            }
            catch (ModelException me) {
                SimpleScheduler.this.log.error((Object)me.getMessage(), (Throwable)me);
            }
            SimpleScheduler.this.timers.remove(this.sendId);
            if (SimpleScheduler.this.log.isDebugEnabled()) {
                SimpleScheduler.this.log.debug((Object)("Fired event '" + this.event + "' as scheduled by " + "<send> with id '" + this.sendId + "'"));
            }
        }
    }
}

