/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import org.apache.commons.pool2.AbstractTestObjectPool;
import org.apache.commons.pool2.BaseObjectPool;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBaseObjectPool
extends AbstractTestObjectPool {
    private ObjectPool<String> pool;

    protected Object getNthObject(int n) {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assertions.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        throw new UnsupportedOperationException("BaseObjectPool isn't a complete implementation.");
    }

    protected boolean isFifo() {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assertions.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        return false;
    }

    protected boolean isLifo() {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assertions.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        return false;
    }

    protected <E extends Exception> ObjectPool<String> makeEmptyPool(int minCapacity) {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assertions.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        throw new UnsupportedOperationException("BaseObjectPool isn't a complete implementation.");
    }

    @Override
    protected <E extends Exception> ObjectPool<Object> makeEmptyPool(PooledObjectFactory<Object> factory) {
        if (this.getClass() != TestBaseObjectPool.class) {
            Assertions.fail((String)"Subclasses of TestBaseObjectPool must reimplement this method.");
        }
        throw new UnsupportedOperationException("BaseObjectPool isn't a complete implementation.");
    }

    @Test
    void testBaseAddObject() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        try {
            Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
            Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
            this.pool.addObject();
            Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
            Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
            String obj = (String)this.pool.borrowObject();
            Assertions.assertEquals((Object)this.getNthObject(0), (Object)obj);
            Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
            Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
            this.pool.returnObject((Object)obj);
            Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
            Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        finally {
            this.pool.close();
        }
    }

    @Test
    void testBaseBorrow() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((Object)this.getNthObject(0), (Object)this.pool.borrowObject());
        Assertions.assertEquals((Object)this.getNthObject(1), (Object)this.pool.borrowObject());
        Assertions.assertEquals((Object)this.getNthObject(2), (Object)this.pool.borrowObject());
        this.pool.close();
    }

    @Test
    void testBaseBorrowReturn() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        String obj0 = (String)this.pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(0), (Object)obj0);
        String obj1 = (String)this.pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(1), (Object)obj1);
        String obj2 = (String)this.pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        this.pool.returnObject((Object)obj2);
        obj2 = (String)this.pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        this.pool.returnObject((Object)obj1);
        obj1 = (String)this.pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(1), (Object)obj1);
        this.pool.returnObject((Object)obj0);
        this.pool.returnObject((Object)obj2);
        obj2 = (String)this.pool.borrowObject();
        if (this.isLifo()) {
            Assertions.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        }
        if (this.isFifo()) {
            Assertions.assertEquals((Object)this.getNthObject(0), (Object)obj2);
        }
        obj0 = (String)this.pool.borrowObject();
        if (this.isLifo()) {
            Assertions.assertEquals((Object)this.getNthObject(0), (Object)obj0);
        }
        if (this.isFifo()) {
            Assertions.assertEquals((Object)this.getNthObject(2), (Object)obj0);
        }
        this.pool.close();
    }

    @Test
    void testBaseClear() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        String obj0 = (String)this.pool.borrowObject();
        String obj1 = (String)this.pool.borrowObject();
        Assertions.assertEquals((int)2, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        this.pool.returnObject((Object)obj1);
        this.pool.returnObject((Object)obj0);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)2, (int)this.pool.getNumIdle());
        this.pool.clear();
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        Object obj2 = this.pool.borrowObject();
        Assertions.assertEquals((Object)this.getNthObject(2), (Object)obj2);
        this.pool.close();
    }

    @Test
    void testBaseClosePool() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        String obj = (String)this.pool.borrowObject();
        this.pool.returnObject((Object)obj);
        this.pool.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.pool.borrowObject());
    }

    @Test
    void testBaseInvalidateObject() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        String obj0 = (String)this.pool.borrowObject();
        String obj1 = (String)this.pool.borrowObject();
        Assertions.assertEquals((int)2, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        this.pool.invalidateObject((Object)obj0);
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
        this.pool.invalidateObject((Object)obj1);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        this.pool.close();
    }

    @Test
    void testBaseNumActiveNumIdle() throws Exception {
        try {
            this.pool = this.makeEmptyPool(3);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        String obj0 = (String)this.pool.borrowObject();
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        String obj1 = (String)this.pool.borrowObject();
        Assertions.assertEquals((int)2, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        this.pool.returnObject((Object)obj1);
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)1, (int)this.pool.getNumIdle());
        this.pool.returnObject((Object)obj0);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((int)2, (int)this.pool.getNumIdle());
        this.pool.close();
    }

    @Test
    void testClose() {
        TestObjectPool pool = new TestObjectPool();
        pool.close();
        pool.close();
    }

    @Test
    void testUnsupportedOperations() {
        if (!this.getClass().equals(TestBaseObjectPool.class)) {
            return;
        }
        try (TestObjectPool pool = new TestObjectPool();){
            Assertions.assertTrue((pool.getNumIdle() < 0 ? 1 : 0) != 0, (String)"Negative expected.");
            Assertions.assertTrue((pool.getNumActive() < 0 ? 1 : 0) != 0, (String)"Negative expected.");
            Assertions.assertThrows(UnsupportedOperationException.class, () -> ((ObjectPool)pool).clear());
            Assertions.assertThrows(UnsupportedOperationException.class, () -> ((ObjectPool)pool).addObject());
        }
    }

    private static final class TestObjectPool
    extends BaseObjectPool<Object> {
        private TestObjectPool() {
        }

        public Object borrowObject() {
            return null;
        }

        public void invalidateObject(Object obj) {
        }

        public void returnObject(Object obj) {
        }
    }
}

