/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

import org.apache.commons.numbers.core.DD;

public final class DDMath {
    private static final double HALF = 0.5;
    private static final double SAFE_MULTIPLY = 3.273390607896142E150;

    private DDMath() {
    }

    public static DD pow(DD x, int n, long[] exp) {
        if (n == 0) {
            exp[0] = 1L;
            return DD.of(0.5);
        }
        if (!Double.isFinite(x.hi()) || x.hi() == 0.0) {
            exp[0] = 0L;
            return DD.of(Math.pow(x.hi(), n));
        }
        int[] ie = new int[]{0};
        DD f = x.frexp(ie);
        long b = ie[0];
        if (Math.abs(f.hi()) == 0.5 && f.lo() == 0.0) {
            double y0 = 0.5 * Math.pow(2.0 * f.hi(), n);
            double y1 = Math.copySign(0.0, y0 * f.hi() * x.lo());
            exp[0] = 1L + (b - 1L) * (long)n;
            return DD.of(y0, y1);
        }
        return DDMath.computePowScaled(b, f.hi(), f.lo(), n, exp);
    }

    private static DD computePowScaled(long b, double x, double xx, int n, long[] exp) {
        DD t;
        long be = b - 1L;
        double b0 = x * 2.0;
        double b1 = xx * 2.0;
        double b0h = DD.highPart(b0);
        double b0l = b0 - b0h;
        double b1h = DD.highPart(b1);
        double b1l = b1 - b1h;
        long fe = be;
        double f0 = b0;
        double f1 = b1;
        double f2 = 0.0;
        int an = Math.abs(n);
        int shift = Integer.numberOfLeadingZeros(an) + 1;
        int bits = an << shift;
        MDD m = new MDD();
        int i = 32 - shift;
        while (i != 0) {
            fe <<= 1;
            double a0h = DD.highPart(f0);
            double a0l = f0 - a0h;
            double a1h = DD.highPart(f1);
            double a1l = f1 - a1h;
            double a2h = DD.highPart(f2);
            double a2l = f2 - a2h;
            double p00 = f0 * f0;
            double q00 = DD.twoSquareLow(a0h, a0l, p00);
            double p01 = f0 * f1;
            double q01 = DD.twoProductLow(a0h, a0l, a1h, a1l, p01);
            double p02 = f0 * f2;
            double q02 = DD.twoProductLow(a0h, a0l, a2h, a2l, p02);
            double p11 = f1 * f1;
            double q11 = DD.twoSquareLow(a1h, a1l, p11);
            double p12 = f1 * f2;
            double s0 = p00;
            double s1 = 2.0 * p01 + q00;
            double r2 = DD.twoSumLow(2.0 * p01, q00, s1);
            double s2 = p02 + q01;
            double r3b = DD.twoSumLow(p02, q01, s2);
            double u = p11 + r2;
            double v = DD.twoSumLow(p11, r2, u);
            t = DD.add(2.0 * s2, 2.0 * r3b, u, v);
            s2 = t.hi();
            r3b = t.lo();
            double s3 = 2.0 * (p12 + q02) + q11 + r3b;
            f0 = DDMath.norm3(s0, s1, s2, s3, m);
            f1 = m.x;
            f2 = m.xx;
            if (Math.abs(f0) > 3.273390607896142E150) {
                int e = Math.getExponent(f0);
                double s = DD.twoPow(-e);
                fe += (long)e;
                f0 *= s;
                f1 *= s;
                f2 *= s;
            }
            if (bits < 0) {
                fe += be;
                a0h = DD.highPart(f0);
                a0l = f0 - a0h;
                a1h = DD.highPart(f1);
                a1l = f1 - a1h;
                a2h = DD.highPart(f2);
                a2l = f2 - a2h;
                p00 = f0 * b0;
                q00 = DD.twoProductLow(a0h, a0l, b0h, b0l, p00);
                p01 = f0 * b1;
                q01 = DD.twoProductLow(a0h, a0l, b1h, b1l, p01);
                double p10 = f1 * b0;
                double q10 = DD.twoProductLow(a1h, a1l, b0h, b0l, p10);
                p11 = f1 * b1;
                q11 = DD.twoProductLow(a1h, a1l, b1h, b1l, p11);
                double p20 = f2 * b0;
                double q20 = DD.twoProductLow(a2h, a2l, b0h, b0l, p20);
                double p21 = f2 * b1;
                s0 = p00;
                u = p01 + p10;
                v = DD.twoSumLow(p01, p10, u);
                s1 = q00 + u;
                double w = DD.twoSumLow(q00, u, s1);
                r2 = v + w;
                double r3a = DD.twoSumLow(v, w, r2);
                s2 = p11 + p20;
                r3b = DD.twoSumLow(p11, p20, s2);
                u = q01 + q10;
                v = DD.twoSumLow(q01, q10, u);
                t = DD.add(s2, r3b, u, v);
                s2 = t.hi() + r2;
                r3b = DD.twoSumLow(t.hi(), r2, s2);
                s3 = p21 + q11 + q20 + r3a + r3b;
                f0 = DDMath.norm3(s0, s1, s2, s3, m);
                f1 = m.x;
                f2 = m.xx;
            }
            --i;
            bits <<= 1;
        }
        double u = f1 + f2;
        t = DD.fastTwoSum(f0, u);
        int[] e = new int[]{0};
        if (n < 0) {
            double v = DD.fastTwoSumLow(f1, f2, u);
            t = DDMath.inverse3(t.hi(), t.lo(), v);
            t = t.frexp(e);
            exp[0] = (long)e[0] - fe;
            return t;
        }
        t = t.frexp(e);
        exp[0] = fe + (long)e[0];
        return t;
    }

    private static double norm3(double s0, double s1, double s2, double s3, MDD s12) {
        double g0 = s0 + s1;
        double q = DD.fastTwoSumLow(s0, s1, g0);
        double g1 = q + s2;
        q = DD.fastTwoSumLow(q, s2, g1);
        double g2 = q + s3;
        double g3 = DD.fastTwoSumLow(q, s3, g2);
        q = g1 + g2;
        s12.xx = DD.fastTwoSumLow(g1, g2, q) + g3;
        double h0 = g0 + q;
        s12.x = DD.fastTwoSumLow(g0, q, h0);
        return h0;
    }

    private static DD inverse3(double y, double yy, double yyy) {
        double q0 = 1.0 / y;
        MDD q = new MDD();
        double t = DDMath.multiply3(y, yy, yyy, q0, q);
        double r = DDMath.add3(-t, -q.x, -q.xx, 1.0, q);
        double rr = q.x;
        double rrr = q.xx;
        double q1 = r / y;
        t = DDMath.multiply3(y, yy, yyy, q1, q);
        r = DDMath.add3(-t, -q.x, -q.xx, r, rr, rrr, q);
        rr = q.x;
        rrr = q.xx;
        double q2 = r / y;
        t = DDMath.multiply3(y, yy, yyy, q2, q);
        r = DDMath.add3(-t, -q.x, -q.xx, r, rr, rrr, q);
        double q3 = r / y;
        t = DDMath.norm3(q0, q1, q2, q3, q);
        return DD.fastTwoSum(t, q.x + q.xx);
    }

    private static double multiply3(double a0, double a1, double a2, double b, MDD s12) {
        double a0h = DD.highPart(a0);
        double a0l = a0 - a0h;
        double a1h = DD.highPart(a1);
        double a1l = a1 - a1h;
        double b0h = DD.highPart(b);
        double b0l = b - b0h;
        double p00 = a0 * b;
        double q00 = DD.twoProductLow(a0h, a0l, b0h, b0l, p00);
        double p10 = a1 * b;
        double q10 = DD.twoProductLow(a1h, a1l, b0h, b0l, p10);
        double p20 = a2 * b;
        double s1 = p10 + q00;
        double r1 = DD.twoSumLow(p10, q00, s1);
        double u = p20 + q10;
        double v = DD.twoSumLow(p20, q10, u);
        double s2 = u + r1;
        u = DD.twoSumLow(u, r1, s2);
        return DDMath.norm3(p00, s1, s2, v + u, s12);
    }

    private static double add3(double a0, double a1, double a2, double b, MDD s12) {
        double s0 = a0 + b;
        double u = DD.twoSumLow(a0, b, s0);
        double s1 = a1 + u;
        double v = DD.twoSumLow(a1, u, s1);
        double s2 = a2 + v;
        u = DD.twoSumLow(a2, v, s2);
        return DDMath.norm3(s0, s1, s2, u, s12);
    }

    private static double add3(double a0, double a1, double a2, double b0, double b1, double b2, MDD s12) {
        double s0 = a0 + b0;
        double r1 = DD.twoSumLow(a0, b0, s0);
        double u = a1 + b1;
        double v = DD.twoSumLow(a1, b1, u);
        double s1 = r1 + u;
        u = DD.twoSumLow(r1, u, s1);
        double r2 = v + u;
        double r3 = DD.twoSumLow(v, u, r2);
        u = a2 + b2;
        v = DD.twoSumLow(a2, b2, u);
        double s2 = r2 + u;
        u = DD.twoSumLow(r2, u, s2);
        double s3 = v + u + r3;
        return DDMath.norm3(s0, s1, s2, s3, s12);
    }

    private static final class MDD {
        private double x;
        private double xx;

        MDD() {
        }
    }
}

