/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.fitting;

import java.util.Collection;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.function.HarmonicOscillator;
import org.apache.commons.math4.legacy.exception.MathIllegalStateException;
import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;
import org.apache.commons.math4.legacy.exception.ZeroException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.fitting.SimpleCurveFitter;
import org.apache.commons.math4.legacy.fitting.WeightedObservedPoint;

public final class HarmonicCurveFitter
extends SimpleCurveFitter {
    private static final HarmonicOscillator.Parametric FUNCTION = new HarmonicOscillator.Parametric();

    private HarmonicCurveFitter(double[] initialGuess, int maxIter) {
        super(FUNCTION, initialGuess, new ParameterGuesser(), maxIter);
    }

    public static HarmonicCurveFitter create() {
        return new HarmonicCurveFitter(null, Integer.MAX_VALUE);
    }

    public static class ParameterGuesser
    extends SimpleCurveFitter.ParameterGuesser {
        @Override
        public double[] guess(Collection<WeightedObservedPoint> observations) {
            if (observations.size() < 4) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, (Number)observations.size(), (Number)4, true);
            }
            WeightedObservedPoint[] sorted = this.sortObservations(observations).toArray(new WeightedObservedPoint[0]);
            double[] aOmega = this.guessAOmega(sorted);
            double a = aOmega[0];
            double omega = aOmega[1];
            double phi = this.guessPhi(sorted, omega);
            return new double[]{a, omega, phi};
        }

        private double[] guessAOmega(WeightedObservedPoint[] observations) {
            double[] aOmega = new double[2];
            double sx2 = 0.0;
            double sy2 = 0.0;
            double sxy = 0.0;
            double sxz = 0.0;
            double syz = 0.0;
            double currentX = observations[0].getX();
            double currentY = observations[0].getY();
            double f2Integral = 0.0;
            double fPrime2Integral = 0.0;
            double startX = currentX;
            for (int i = 1; i < observations.length; ++i) {
                double previousX = currentX;
                double previousY = currentY;
                currentX = observations[i].getX();
                currentY = observations[i].getY();
                double dx = currentX - previousX;
                double dy = currentY - previousY;
                double f2StepIntegral = dx * (previousY * previousY + previousY * currentY + currentY * currentY) / 3.0;
                double fPrime2StepIntegral = dy * dy / dx;
                double x = currentX - startX;
                sx2 += x * x;
                sy2 += (f2Integral += f2StepIntegral) * f2Integral;
                sxy += x * f2Integral;
                sxz += x * (fPrime2Integral += fPrime2StepIntegral);
                syz += f2Integral * fPrime2Integral;
            }
            double c1 = sy2 * sxz - sxy * syz;
            double c2 = sxy * sxz - sx2 * syz;
            double c3 = sx2 * sy2 - sxy * sxy;
            if (c1 / c2 < 0.0 || c2 / c3 < 0.0) {
                int last = observations.length - 1;
                double xRange = observations[last].getX() - observations[0].getX();
                if (xRange == 0.0) {
                    throw new ZeroException();
                }
                aOmega[1] = Math.PI * 2 / xRange;
                double yMin = Double.POSITIVE_INFINITY;
                double yMax = Double.NEGATIVE_INFINITY;
                for (int i = 1; i < observations.length; ++i) {
                    double y = observations[i].getY();
                    if (y < yMin) {
                        yMin = y;
                    }
                    if (!(y > yMax)) continue;
                    yMax = y;
                }
                aOmega[0] = 0.5 * (yMax - yMin);
            } else {
                if (c2 == 0.0) {
                    throw new MathIllegalStateException((Localizable)LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
                }
                aOmega[0] = JdkMath.sqrt((double)(c1 / c2));
                aOmega[1] = JdkMath.sqrt((double)(c2 / c3));
            }
            return aOmega;
        }

        private double guessPhi(WeightedObservedPoint[] observations, double omega) {
            double fcMean = 0.0;
            double fsMean = 0.0;
            double currentX = observations[0].getX();
            double currentY = observations[0].getY();
            for (int i = 1; i < observations.length; ++i) {
                double previousX = currentX;
                double previousY = currentY;
                currentX = observations[i].getX();
                currentY = observations[i].getY();
                double currentYPrime = (currentY - previousY) / (currentX - previousX);
                double omegaX = omega * currentX;
                double cosine = JdkMath.cos((double)omegaX);
                double sine = JdkMath.sin((double)omegaX);
                fcMean += omega * currentY * cosine - currentYPrime * sine;
                fsMean += omega * currentY * sine + currentYPrime * cosine;
            }
            return JdkMath.atan2((double)(-fsMean), (double)fcMean);
        }
    }
}

