/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.examples;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.apache.commons.io.FileUtils;

public class WriteExifMetadataExample {
    public void changeExifMetadata(File jpegImageFile, File dst) throws IOException, ImagingException, ImagingException {
        try (FileOutputStream fos = new FileOutputStream(dst);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            TiffImageMetadata exif;
            TiffOutputSet outputSet = null;
            ImageMetadata metadata = Imaging.getMetadata((File)jpegImageFile);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            if (null != jpegMetadata && null != (exif = jpegMetadata.getExif())) {
                outputSet = exif.getOutputSet();
            }
            if (null == outputSet) {
                outputSet = new TiffOutputSet();
            }
            TiffOutputDirectory exifDirectory = outputSet.getOrCreateExifDirectory();
            exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_APERTURE_VALUE);
            exifDirectory.add(ExifTagConstants.EXIF_TAG_APERTURE_VALUE, new RationalNumber(3, 10));
            double longitude = -74.0;
            double latitude = 40.71666666666667;
            outputSet.setGpsInDegrees(-74.0, 40.71666666666667);
            new ExifRewriter().updateExifMetadataLossless(jpegImageFile, (OutputStream)os, outputSet);
        }
    }

    public void removeExifMetadata(File jpegImageFile, File dst) throws IOException, ImagingException, ImagingException {
        try (FileOutputStream fos = new FileOutputStream(dst);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            new ExifRewriter().removeExifMetadata(jpegImageFile, (OutputStream)os);
        }
    }

    public void removeExifTag(File jpegImageFile, File dst) throws IOException, ImagingException, ImagingException {
        try (FileOutputStream fos = new FileOutputStream(dst);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            TiffImageMetadata exif;
            TiffOutputSet outputSet = null;
            ImageMetadata metadata = Imaging.getMetadata((File)jpegImageFile);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            if (null != jpegMetadata && null != (exif = jpegMetadata.getExif())) {
                outputSet = exif.getOutputSet();
            }
            if (null == outputSet) {
                FileUtils.copyFile((File)jpegImageFile, (File)dst);
                return;
            }
            outputSet.removeField((TagInfo)ExifTagConstants.EXIF_TAG_APERTURE_VALUE);
            TiffOutputDirectory exifDirectory = outputSet.getExifDirectory();
            if (null != exifDirectory) {
                exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_APERTURE_VALUE);
            }
            new ExifRewriter().updateExifMetadataLossless(jpegImageFile, (OutputStream)os, outputSet);
        }
    }

    public void setExifGPSTag(File jpegImageFile, File dst) throws IOException, ImagingException, ImagingException {
        try (FileOutputStream fos = new FileOutputStream(dst);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            TiffImageMetadata exif;
            TiffOutputSet outputSet = null;
            ImageMetadata metadata = Imaging.getMetadata((File)jpegImageFile);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            if (null != jpegMetadata && null != (exif = jpegMetadata.getExif())) {
                outputSet = exif.getOutputSet();
            }
            if (null == outputSet) {
                outputSet = new TiffOutputSet();
            }
            double longitude = -74.0;
            double latitude = 40.71666666666667;
            outputSet.setGpsInDegrees(-74.0, 40.71666666666667);
            new ExifRewriter().updateExifMetadataLossless(jpegImageFile, (OutputStream)os, outputSet);
        }
    }
}

