/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.TestBasicDataSource;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.apache.commons.dbcp2.managed.ManagedConnection;
import org.apache.commons.dbcp2.managed.SynchronizationAdapter;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.h2.Driver;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBasicManagedDataSource
extends TestBasicDataSource {
    @Override
    protected BasicDataSource createDataSource() throws Exception {
        BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();
        TransactionManagerImpl transactionManager = new TransactionManagerImpl();
        basicManagedDataSource.setTransactionManager((TransactionManager)transactionManager);
        basicManagedDataSource.setTransactionSynchronizationRegistry((TransactionSynchronizationRegistry)transactionManager);
        return basicManagedDataSource;
    }

    @Test
    void testCreateXaDataSourceNewInstance() throws SQLException, XAException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setXADataSource(JdbcDataSource.class.getCanonicalName());
            basicManagedDataSource.setDriverClassName(Driver.class.getName());
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            Assertions.assertNotNull((Object)basicManagedDataSource.createConnectionFactory());
        }
    }

    @Test
    void testCreateXaDataSourceNoInstanceSetAndNoDataSource() throws SQLException, XAException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
            basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            Assertions.assertNotNull((Object)basicManagedDataSource.createConnectionFactory());
        }
    }

    @Test
    void testReallyClose() throws Exception {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
            basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
            basicManagedDataSource.setUsername("userName");
            basicManagedDataSource.setPassword("password");
            basicManagedDataSource.setMaxIdle(1);
            ManagedConnection conn = (ManagedConnection)basicManagedDataSource.getConnection();
            Assertions.assertNotNull((Object)basicManagedDataSource.getTransactionRegistry().getXAResource((Connection)conn));
            ManagedConnection conn2 = (ManagedConnection)basicManagedDataSource.getConnection();
            conn2.close();
            conn.close();
            Assertions.assertThrows(SQLException.class, () -> basicManagedDataSource.getTransactionRegistry().getXAResource((Connection)conn), (String)"Expecting SQLException - XAResources orphaned");
            conn2.close();
        }
    }

    @Test
    void testRuntimeExceptionsAreRethrown() throws SQLException, XAException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
            basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
            basicManagedDataSource.setUsername("userName");
            basicManagedDataSource.setPassword("password");
            basicManagedDataSource.setMaxIdle(1);
            Assertions.assertThrows(NullPointerException.class, () -> basicManagedDataSource.createPoolableConnectionFactory(null));
        }
    }

    @Test
    void testSetDriverName() throws SQLException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setDriverClassName("adams");
            Assertions.assertEquals((Object)"adams", (Object)basicManagedDataSource.getDriverClassName());
            basicManagedDataSource.setDriverClassName(null);
            Assertions.assertNull((Object)basicManagedDataSource.getDriverClassName());
        }
    }

    @Test
    void testSetNullXaDataSourceInstance() throws SQLException, XAException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
            basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
            basicManagedDataSource.setUsername("userName");
            basicManagedDataSource.setPassword("password");
            basicManagedDataSource.setMaxIdle(1);
            basicManagedDataSource.setXaDataSourceInstance(null);
            Assertions.assertNull((Object)basicManagedDataSource.getXaDataSourceInstance());
        }
    }

    @Test
    void testSetRollbackOnlyBeforeGetConnectionDoesNotLeak() throws Exception {
        TransactionManager transactionManager = ((BasicManagedDataSource)this.ds).getTransactionManager();
        int n = 3;
        this.ds.setMaxIdle(3);
        this.ds.setMaxTotal(3);
        for (int i = 0; i <= 3; ++i) {
            transactionManager.begin();
            transactionManager.setRollbackOnly();
            try (Connection conn = this.getConnection();){
                Assertions.assertNotNull((Object)conn);
            }
            transactionManager.rollback();
        }
        Assertions.assertEquals((int)0, (int)this.ds.getNumActive());
        Assertions.assertEquals((int)1, (int)this.ds.getNumIdle());
    }

    @Test
    void testSetXaDataSourceInstance() throws SQLException, XAException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
            basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
            basicManagedDataSource.setUsername("userName");
            basicManagedDataSource.setPassword("password");
            basicManagedDataSource.setMaxIdle(1);
            basicManagedDataSource.setXaDataSourceInstance((XADataSource)new JdbcDataSource());
            Assertions.assertNotNull((Object)basicManagedDataSource.createConnectionFactory());
        }
    }

    @Test
    void testTransactionManagerNotSet() throws SQLException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            Assertions.assertThrows(SQLException.class, () -> ((BasicManagedDataSource)basicManagedDataSource).createConnectionFactory());
        }
    }

    @Test
    void testTransactionSynchronizationRegistry() throws Exception {
        try (final BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImple());
            TransactionSynchronizationRegistryImple tsr = new TransactionSynchronizationRegistryImple();
            basicManagedDataSource.setTransactionSynchronizationRegistry((TransactionSynchronizationRegistry)tsr);
            JdbcDataSource xaDataSource = new JdbcDataSource();
            xaDataSource.setUrl("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
            basicManagedDataSource.setXaDataSourceInstance((XADataSource)xaDataSource);
            basicManagedDataSource.setMaxIdle(1);
            TransactionManager tm = basicManagedDataSource.getTransactionManager();
            tm.begin();
            tsr.registerInterposedSynchronization((Synchronization)new SynchronizationAdapter(){

                public void beforeCompletion() {
                    try (Connection connection = (Connection)Assertions.assertDoesNotThrow(() -> ((BasicManagedDataSource)basicManagedDataSource).getConnection());){
                        Assertions.assertNotNull((Object)connection);
                    }
                    catch (SQLException e) {
                        Assertions.fail((Throwable)e);
                    }
                }
            });
            tm.commit();
        }
    }

    @Test
    void testXADataSource() throws SQLException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setXADataSource("anything");
            Assertions.assertEquals((Object)"anything", (Object)basicManagedDataSource.getXADataSource());
        }
    }

    @Test
    void testXaDataSourceInstance() throws SQLException {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            JdbcDataSource ds = new JdbcDataSource();
            basicManagedDataSource.setXaDataSourceInstance((XADataSource)ds);
            Assertions.assertEquals((Object)ds, (Object)basicManagedDataSource.getXaDataSourceInstance());
        }
    }
}

