/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.xz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junitpioneer.jupiter.cartesian.CartesianTest;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

class XZCompressorRoundtripTest {
    @TempDir
    static Path tempDir;

    XZCompressorRoundtripTest() {
    }

    private void roundtrip(Path outPath, LZMA2Options options, boolean decompressConcatenated, int memoryLimitKiB) throws IOException {
        String data = "Hello World!";
        try (XZCompressorOutputStream out = ((XZCompressorOutputStream.Builder)XZCompressorOutputStream.builder().setPath(outPath)).setLzma2Options(options).get();){
            out.writeUtf8("Hello World!");
        }
        out = ((XZCompressorInputStream.Builder)XZCompressorInputStream.builder().setPath(outPath)).setDecompressConcatenated(decompressConcatenated).setMemoryLimitKiB(memoryLimitKiB).get();
        try {
            Assertions.assertEquals((Object)"Hello World!", (Object)IOUtils.toString((InputStream)out, (Charset)StandardCharsets.UTF_8));
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        out = new XZCompressorInputStream(Files.newInputStream(outPath, new OpenOption[0]));
        try {
            Assertions.assertEquals((Object)"Hello World!", (Object)IOUtils.toString((InputStream)out, (Charset)StandardCharsets.UTF_8));
        }
        finally {
            out.close();
        }
        out = new XZCompressorOutputStream((OutputStream)new XZOutputStream(Files.newOutputStream(outPath, new OpenOption[0]), (FilterOptions)options));
        try {
            out.writeUtf8("Hello World!");
        }
        finally {
            out.close();
        }
    }

    @CartesianTest
    void testBuilderOptions(@CartesianTest.Values(ints={9, 0, 6}) int preset, @CartesianTest.Values(booleans={false, true}) boolean decompressConcatenated, @CartesianTest.Values(ints={-1, 100000}) int memoryLimitKiB) throws IOException {
        this.roundtrip(tempDir.resolve("out.xz"), new LZMA2Options(preset), false, -1);
    }

    @Test
    void testBuilderOptionsAll() throws IOException {
        int dictSize = 4096;
        boolean lc = false;
        boolean lp = false;
        int pb = 4;
        int mode = 2;
        int niceLen = 8;
        int mf = 20;
        int depthLimit = 50;
        this.roundtrip(tempDir.resolve("out.xz"), new LZMA2Options(4096, 0, 0, 4, 2, 8, 20, 50), false, -1);
    }

    @CartesianTest
    void testBuilderOptionsDefgault(@CartesianTest.Values(booleans={false, true}) boolean decompressConcatenated, @CartesianTest.Values(ints={-1, 100000}) int memoryLimitKiB) throws IOException {
        this.roundtrip(tempDir.resolve("out.xz"), new LZMA2Options(), decompressConcatenated, memoryLimitKiB);
    }

    @Test
    void testBuilderPath() throws IOException {
        String data = "Hello World!";
        Path outPath = tempDir.resolve("out.xz");
        try (XZCompressorOutputStream out = ((XZCompressorOutputStream.Builder)XZCompressorOutputStream.builder().setPath(outPath)).get();){
            out.writeUtf8("Hello World!");
        }
        out = new XZCompressorInputStream(Files.newInputStream(outPath, new OpenOption[0]), false);
        try {
            Assertions.assertEquals((Object)"Hello World!", (Object)IOUtils.toString((InputStream)out, (Charset)StandardCharsets.UTF_8));
        }
        finally {
            out.close();
        }
        out = new XZCompressorInputStream(Files.newInputStream(outPath, new OpenOption[0]), false, -1);
        try {
            Assertions.assertEquals((Object)"Hello World!", (Object)IOUtils.toString((InputStream)out, (Charset)StandardCharsets.UTF_8));
        }
        finally {
            out.close();
        }
    }
}

