/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.memory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.reflect.DynMethods;
import org.apache.celeborn.service.deploy.worker.memory.ReadBufferDispatcher;
import org.apache.celeborn.service.deploy.worker.memory.ReadBufferRequest;
import org.apache.celeborn.service.deploy.worker.storage.CreditStreamManager;
import org.apache.celeborn.service.deploy.worker.storage.PartitionDataWriter;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(MemoryManager.class);
    private static volatile MemoryManager _INSTANCE = null;
    @VisibleForTesting
    public long maxDirectMemory;
    private final long pausePushDataThreshold;
    private final long pauseReplicateThreshold;
    private final double directMemoryResumeRatio;
    private final double pinnedMemoryResumeRatio;
    private final long maxSortMemory;
    private final int forceAppendPauseSpentTimeThreshold;
    private final List<MemoryPressureListener> memoryPressureListeners = new ArrayList<MemoryPressureListener>();
    private final ScheduledExecutorService checkService = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"worker-memory-manager-checker");
    private final ScheduledExecutorService reportService = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"worker-memory-manager-reporter");
    private final ExecutorService actionService = ThreadUtils.newDaemonSingleThreadExecutor((String)"worker-memory-manager-actor");
    private final AtomicBoolean trimInProcess = new AtomicBoolean(false);
    private final AtomicLong sortMemoryCounter = new AtomicLong(0L);
    private final AtomicLong diskBufferCounter = new AtomicLong(0L);
    private final LongAdder pausePushDataCounter = new LongAdder();
    private final LongAdder pausePushDataAndReplicateCounter = new LongAdder();
    public ServingState servingState = ServingState.NONE_PAUSED;
    private long pausePushDataStartTime = -1L;
    private long pausePushDataTime = 0L;
    private long pausePushDataAndReplicateStartTime = -1L;
    private long pausePushDataAndReplicateTime = 0L;
    private int trimCounter = 0;
    private volatile boolean isPaused = false;
    private final AtomicLong readBufferCounter = new AtomicLong(0L);
    private long readBufferThreshold;
    private long readBufferTarget;
    private ReadBufferDispatcher readBufferDispatcher;
    private final List<ReadBufferTargetChangeListener> readBufferTargetChangeListeners = new ArrayList<ReadBufferTargetChangeListener>();
    private long lastNotifiedTarget = 0L;
    private final ScheduledExecutorService readBufferTargetUpdateService = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"worker-memory-manager-read-buffer-target-updater");
    private CreditStreamManager creditStreamManager = null;
    private long memoryFileStorageThreshold;
    private final LongAdder memoryFileStorageCounter = new LongAdder();
    private final StorageManager storageManager;
    private boolean pinnedMemoryCheckEnabled;
    private long pinnedMemoryCheckInterval;
    private long pinnedMemoryLastCheckTime = 0L;
    private boolean resumingByPinnedMemory = false;
    private long workerPinnedMemoryResumeKeepTime;

    @VisibleForTesting
    public static MemoryManager initialize(CelebornConf conf) {
        return MemoryManager.initialize(conf, null, null);
    }

    public static MemoryManager initialize(CelebornConf conf, StorageManager storageManager, AbstractSource source) {
        if (_INSTANCE == null) {
            _INSTANCE = new MemoryManager(conf, storageManager, source);
        }
        return _INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMemoryListener(MemoryPressureListener listener) {
        List<MemoryPressureListener> list = this.memoryPressureListeners;
        synchronized (list) {
            this.memoryPressureListeners.add(listener);
        }
    }

    public static MemoryManager instance() {
        return _INSTANCE;
    }

    private MemoryManager(CelebornConf conf, StorageManager storageManager, AbstractSource source) {
        double pausePushDataRatio = conf.workerDirectMemoryRatioToPauseReceive();
        double pauseReplicateRatio = conf.workerDirectMemoryRatioToPauseReplicate();
        this.directMemoryResumeRatio = conf.workerDirectMemoryRatioToResume();
        this.pinnedMemoryResumeRatio = conf.workerPinnedMemoryRatioToResume();
        double maxSortMemRatio = conf.workerPartitionSorterDirectMemoryRatioThreshold();
        double readBufferRatio = conf.workerDirectMemoryRatioForReadBuffer();
        double memoryFileStorageRatio = conf.workerDirectMemoryRatioForMemoryFilesStorage();
        long checkInterval = conf.workerDirectMemoryPressureCheckIntervalMs();
        this.pinnedMemoryCheckEnabled = conf.workerPinnedMemoryCheckEnabled();
        this.pinnedMemoryCheckInterval = conf.workerPinnedMemoryCheckIntervalMs();
        this.workerPinnedMemoryResumeKeepTime = conf.workerPinnedMemoryResumeKeepTime();
        long reportInterval = conf.workerDirectMemoryReportIntervalSecond();
        double readBufferTargetRatio = conf.readBufferTargetRatio();
        long readBufferTargetUpdateInterval = conf.readBufferTargetUpdateInterval();
        long readBufferTargetNotifyThreshold = conf.readBufferTargetNotifyThreshold();
        boolean aggressiveEvictModeEnabled = conf.workerMemoryFileStorageEictAggressiveModeEnabled();
        double evictRatio = conf.workerMemoryFileStorageEvictRatio();
        this.forceAppendPauseSpentTimeThreshold = conf.metricsWorkerForceAppendPauseSpentTimeThreshold();
        this.maxDirectMemory = (Long)DynMethods.builder((String)"maxDirectMemory").impl("jdk.internal.misc.VM", new Class[0]).impl("sun.misc.VM", new Class[0]).buildStatic().invoke(new Object[0]);
        Preconditions.checkArgument((this.maxDirectMemory > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((pauseReplicateRatio > pausePushDataRatio ? 1 : 0) != 0, (Object)String.format("Invalid config, %s(%s) should be greater than %s(%s)", CelebornConf.WORKER_DIRECT_MEMORY_RATIO_PAUSE_REPLICATE().key(), pauseReplicateRatio, CelebornConf.WORKER_DIRECT_MEMORY_RATIO_PAUSE_RECEIVE().key(), pausePushDataRatio));
        Preconditions.checkArgument((pausePushDataRatio > this.directMemoryResumeRatio ? 1 : 0) != 0);
        if (memoryFileStorageRatio > 0.0) {
            Preconditions.checkArgument((this.directMemoryResumeRatio > readBufferRatio + memoryFileStorageRatio ? 1 : 0) != 0);
        }
        this.maxSortMemory = (long)((double)this.maxDirectMemory * maxSortMemRatio);
        this.pausePushDataThreshold = (long)((double)this.maxDirectMemory * pausePushDataRatio);
        this.pauseReplicateThreshold = (long)((double)this.maxDirectMemory * pauseReplicateRatio);
        this.readBufferThreshold = (long)((double)this.maxDirectMemory * readBufferRatio);
        this.readBufferTarget = (long)((double)this.readBufferThreshold * readBufferTargetRatio);
        this.memoryFileStorageThreshold = (long)((double)this.maxDirectMemory * memoryFileStorageRatio);
        this.checkService.scheduleWithFixedDelay(() -> {
            try {
                this.switchServingState();
            }
            catch (Exception e) {
                logger.error("Memory tracker check error", (Throwable)e);
            }
        }, checkInterval, checkInterval, TimeUnit.MILLISECONDS);
        this.reportService.scheduleWithFixedDelay(() -> logger.info("Direct memory usage: {}/{}, disk buffer size: {}, sort memory size: {}, read buffer size: {}, memory file storage size : {}", new Object[]{Utils.bytesToString((long)this.getNettyUsedDirectMemory()), Utils.bytesToString((long)this.maxDirectMemory), Utils.bytesToString((long)this.diskBufferCounter.get()), Utils.bytesToString((long)this.sortMemoryCounter.get()), Utils.bytesToString((long)this.readBufferCounter.get()), Utils.bytesToString((long)this.memoryFileStorageCounter.sum())}), reportInterval, reportInterval, TimeUnit.SECONDS);
        if (this.readBufferThreshold > 0L) {
            this.readBufferDispatcher = new ReadBufferDispatcher(this, conf, source);
            this.readBufferTargetUpdateService.scheduleWithFixedDelay(() -> {
                block6: {
                    try {
                        long currentTarget;
                        int mapDataPartitionCount;
                        if (this.creditStreamManager == null || (mapDataPartitionCount = this.creditStreamManager.getActiveMapPartitionCount()) <= 0 || Math.abs(this.lastNotifiedTarget - (currentTarget = (long)Math.ceil((double)this.readBufferTarget * 1.0 / (double)mapDataPartitionCount))) <= readBufferTargetNotifyThreshold) break block6;
                        List<ReadBufferTargetChangeListener> list = this.readBufferTargetChangeListeners;
                        synchronized (list) {
                            logger.debug("read buffer target changed {} -> {} active map partition count {}", new Object[]{this.lastNotifiedTarget, currentTarget, mapDataPartitionCount});
                            for (ReadBufferTargetChangeListener changeListener : this.readBufferTargetChangeListeners) {
                                changeListener.onChange(currentTarget);
                            }
                            this.lastNotifiedTarget = currentTarget;
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Failed update buffer target", (Throwable)e);
                    }
                }
            }, readBufferTargetUpdateInterval, readBufferTargetUpdateInterval, TimeUnit.MILLISECONDS);
        }
        this.storageManager = storageManager;
        if (this.memoryFileStorageThreshold > 0L && storageManager != null && storageManager.localOrDfsStorageAvailable()) {
            ScheduledExecutorService memoryFileStorageService = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"memory-file-storage-checker");
            memoryFileStorageService.scheduleWithFixedDelay(() -> {
                block5: {
                    try {
                        if (!this.shouldEvict(aggressiveEvictModeEnabled, evictRatio)) break block5;
                        ArrayList<PartitionDataWriter> memoryWriters = new ArrayList<PartitionDataWriter>(storageManager.memoryWriters().values());
                        if (memoryWriters.isEmpty()) {
                            return;
                        }
                        logger.info("Start evicting {} memory file infos", (Object)memoryWriters.size());
                        memoryWriters.sort(Comparator.comparingLong(o -> o.getMemoryFileInfo().getFileLength()));
                        Collections.reverse(memoryWriters);
                        for (PartitionDataWriter writer : memoryWriters) {
                            if (this.shouldEvict(aggressiveEvictModeEnabled, evictRatio)) {
                                logger.debug("Evict writer {}", (Object)writer);
                                writer.evict(true);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        logger.error("Evict thread encounter error", (Throwable)e);
                    }
                }
            }, checkInterval, checkInterval, TimeUnit.MILLISECONDS);
        }
        logger.info("Memory tracker initialized with: max direct memory: {}, pause push memory: {}, pause replication memory: {},  read buffer memory limit: {} target: {}, memory shuffle storage limit: {}, resume by direct memory ratio: {}, resume by pinned memory ratio: {}", new Object[]{Utils.bytesToString((long)this.maxDirectMemory), Utils.bytesToString((long)this.pausePushDataThreshold), Utils.bytesToString((long)this.pauseReplicateThreshold), Utils.bytesToString((long)this.readBufferThreshold), Utils.bytesToString((long)this.readBufferTarget), Utils.bytesToString((long)this.memoryFileStorageThreshold), this.directMemoryResumeRatio, this.pinnedMemoryResumeRatio});
    }

    public boolean shouldEvict(boolean aggressiveMemoryFileEvictEnabled, double evictRatio) {
        return this.servingState != ServingState.NONE_PAUSED && (aggressiveMemoryFileEvictEnabled || (double)this.memoryFileStorageCounter.sum() >= evictRatio * (double)this.memoryFileStorageThreshold);
    }

    public ServingState currentServingState() {
        long memoryUsage = this.getMemoryUsage();
        if (memoryUsage > this.pauseReplicateThreshold) {
            this.isPaused = true;
            return ServingState.PUSH_AND_REPLICATE_PAUSED;
        }
        if (memoryUsage > this.pausePushDataThreshold) {
            this.isPaused = true;
            return ServingState.PUSH_PAUSED;
        }
        if ((double)memoryUsage / (double)this.maxDirectMemory < this.directMemoryResumeRatio) {
            this.isPaused = false;
            return ServingState.NONE_PAUSED;
        }
        return this.isPaused ? ServingState.PUSH_PAUSED : ServingState.NONE_PAUSED;
    }

    @VisibleForTesting
    public void switchServingState() {
        ServingState lastState = this.servingState;
        this.servingState = this.currentServingState();
        if (this.servingState != lastState) {
            logger.info("Serving state transformed from {} to {}", (Object)lastState, (Object)this.servingState);
        }
        switch (this.servingState) {
            case PUSH_PAUSED: {
                if (!this.tryResumeByPinnedMemory(this.servingState, lastState)) {
                    this.pausePushDataCounter.increment();
                    if (lastState == ServingState.PUSH_AND_REPLICATE_PAUSED) {
                        this.appendPauseSpentTime(lastState);
                        this.resumeReplicate();
                    } else {
                        if (this.servingState != lastState) {
                            this.pausePushDataStartTime = System.currentTimeMillis();
                            logger.info("Trigger action: PAUSE PUSH");
                        }
                        this.resumingByPinnedMemory = false;
                        this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onPause("push"));
                        ++this.trimCounter;
                        if (this.trimCounter >= this.forceAppendPauseSpentTimeThreshold) {
                            logger.debug("Trigger action: TRIM for {} times, force to append pause spent time.", (Object)this.trimCounter);
                            this.appendPauseSpentTime(this.servingState);
                        }
                    }
                }
                logger.debug("Trigger action: TRIM");
                this.trimAllListeners();
                break;
            }
            case PUSH_AND_REPLICATE_PAUSED: {
                if (!this.tryResumeByPinnedMemory(this.servingState, lastState)) {
                    this.pausePushDataAndReplicateCounter.increment();
                    if (this.servingState != lastState) {
                        this.pausePushDataAndReplicateStartTime = System.currentTimeMillis();
                        logger.info("Trigger action: PAUSE PUSH and REPLICATE");
                        if (lastState == ServingState.NONE_PAUSED) {
                            this.pausePushDataStartTime = this.pausePushDataAndReplicateStartTime;
                        }
                    }
                    this.resumingByPinnedMemory = false;
                    this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onPause("push"));
                    this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onPause("replicate"));
                    ++this.trimCounter;
                    if (this.trimCounter >= this.forceAppendPauseSpentTimeThreshold) {
                        logger.debug("Trigger action: TRIM for {} times, force to append pause spent time.", (Object)this.trimCounter);
                        this.appendPauseSpentTime(this.servingState);
                    }
                }
                logger.debug("Trigger action: TRIM");
                this.trimAllListeners();
                break;
            }
            case NONE_PAUSED: {
                this.resumingByPinnedMemory = false;
                if (lastState == ServingState.PUSH_AND_REPLICATE_PAUSED) {
                    this.resumeReplicate();
                    this.resumePush();
                    this.appendPauseSpentTime(lastState);
                    break;
                }
                if (lastState != ServingState.PUSH_PAUSED) break;
                this.resumePush();
                this.appendPauseSpentTime(lastState);
            }
        }
    }

    public void trimAllListeners() {
        if (this.trimInProcess.compareAndSet(false, true)) {
            this.actionService.submit(() -> {
                try {
                    this.memoryPressureListeners.forEach(MemoryPressureListener::onTrim);
                }
                finally {
                    this.trimInProcess.set(false);
                }
            });
        }
    }

    public void reserveSortMemory(long fileLen) {
        this.sortMemoryCounter.addAndGet(fileLen);
    }

    public boolean sortMemoryReady() {
        return this.maxSortMemory == 0L || this.servingState == ServingState.NONE_PAUSED && this.sortMemoryCounter.get() < this.maxSortMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSortMemory(long size) {
        MemoryManager memoryManager = this;
        synchronized (memoryManager) {
            if (this.sortMemoryCounter.get() - size < 0L) {
                this.sortMemoryCounter.set(0L);
            } else {
                this.sortMemoryCounter.addAndGet(-1L * size);
            }
        }
    }

    public void incrementDiskBuffer(int size) {
        this.diskBufferCounter.addAndGet(size);
    }

    public void releaseDiskBuffer(int size) {
        this.diskBufferCounter.addAndGet(size * -1);
    }

    public long getNettyUsedDirectMemory() {
        long usedDirectMemory = PlatformDependent.usedDirectMemory();
        assert (usedDirectMemory != -1L);
        return usedDirectMemory;
    }

    public long getMemoryUsage() {
        return this.getNettyUsedDirectMemory() + this.sortMemoryCounter.get();
    }

    public long getPinnedMemory() {
        return this.getNettyPinnedDirectMemory() + this.sortMemoryCounter.get();
    }

    public long getNettyPinnedDirectMemory() {
        return NettyUtils.getAllPooledByteBufAllocators().stream().mapToLong(PooledByteBufAllocator::pinnedDirectMemory).sum();
    }

    public AtomicLong getSortMemoryCounter() {
        return this.sortMemoryCounter;
    }

    public AtomicLong getDiskBufferCounter() {
        return this.diskBufferCounter;
    }

    public long getReadBufferCounter() {
        return this.readBufferCounter.get();
    }

    public long getPausePushDataCounter() {
        return this.pausePushDataCounter.sum();
    }

    public void requestReadBuffers(ReadBufferRequest request) {
        this.readBufferDispatcher.addBufferRequest(request);
    }

    public void recycleReadBuffer(ByteBuf readBuf) {
        this.readBufferDispatcher.recycle(readBuf);
    }

    protected void changeReadBufferCounter(int delta) {
        this.readBufferCounter.addAndGet(delta);
    }

    @VisibleForTesting
    public boolean readBufferAvailable(int requiredBytes) {
        return this.readBufferCounter.get() + (long)requiredBytes < this.readBufferThreshold;
    }

    public long getPausePushDataAndReplicateCounter() {
        return this.pausePushDataAndReplicateCounter.sum();
    }

    public long getAllocatedReadBuffers() {
        return this.readBufferDispatcher.getAllocatedReadBuffers();
    }

    public int dispatchRequestsLength() {
        return this.readBufferDispatcher.requestsLength();
    }

    public long getPausePushDataTime() {
        return this.pausePushDataTime;
    }

    public long getPausePushDataAndReplicateTime() {
        return this.pausePushDataAndReplicateTime;
    }

    private void appendPauseSpentTime(ServingState servingState) {
        long nextPauseStartTime = System.currentTimeMillis();
        this.pausePushDataTime += nextPauseStartTime - this.pausePushDataStartTime;
        this.pausePushDataStartTime = nextPauseStartTime;
        if (servingState == ServingState.PUSH_AND_REPLICATE_PAUSED) {
            this.pausePushDataAndReplicateTime += nextPauseStartTime - this.pausePushDataAndReplicateStartTime;
            this.pausePushDataAndReplicateStartTime = nextPauseStartTime;
        }
        this.trimCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReadBufferTargetChangeListener(ReadBufferTargetChangeListener listener) {
        List<ReadBufferTargetChangeListener> list = this.readBufferTargetChangeListeners;
        synchronized (list) {
            this.readBufferTargetChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReadBufferTargetChangeListener(ReadBufferTargetChangeListener listener) {
        List<ReadBufferTargetChangeListener> list = this.readBufferTargetChangeListeners;
        synchronized (list) {
            this.readBufferTargetChangeListeners.remove(listener);
        }
    }

    public void setCreditStreamManager(CreditStreamManager creditStreamManager) {
        this.creditStreamManager = creditStreamManager;
    }

    public double workerMemoryUsageRatio() {
        return (double)this.getMemoryUsage() / (double)this.maxDirectMemory;
    }

    public long getMemoryFileStorageCounter() {
        return this.memoryFileStorageCounter.sum();
    }

    public boolean memoryFileStorageAvailable() {
        return this.memoryFileStorageCounter.sum() < this.memoryFileStorageThreshold;
    }

    public void incrementMemoryFileStorage(int bytes) {
        this.memoryFileStorageCounter.add(bytes);
    }

    public void releaseMemoryFileStorage(int bytes) {
        this.memoryFileStorageCounter.add(-1 * bytes);
    }

    public void close() {
        this.checkService.shutdown();
        this.reportService.shutdown();
        this.readBufferTargetUpdateService.shutdown();
        this.memoryPressureListeners.clear();
        this.actionService.shutdown();
        this.readBufferTargetChangeListeners.clear();
        this.readBufferDispatcher.close();
    }

    public ByteBufAllocator getStorageByteBufAllocator() {
        return this.storageManager.storageBufferAllocator();
    }

    @VisibleForTesting
    public static void reset() {
        _INSTANCE = null;
    }

    private void resumeByPinnedMemory(ServingState servingState) {
        switch (servingState) {
            case PUSH_AND_REPLICATE_PAUSED: {
                logger.info("Serving State is PUSH_AND_REPLICATE_PAUSED, but resume by lower pinned memory {}", (Object)this.getNettyPinnedDirectMemory());
                this.resumeReplicate();
                this.resumePush();
            }
            case PUSH_PAUSED: {
                logger.info("Serving State is PUSH_PAUSED, but resume by lower pinned memory {}", (Object)this.getNettyPinnedDirectMemory());
                this.resumePush();
            }
        }
    }

    private boolean tryResumeByPinnedMemory(ServingState currentState, ServingState lastState) {
        if (this.pinnedMemoryCheckEnabled) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.pinnedMemoryLastCheckTime >= this.pinnedMemoryCheckInterval) {
                if ((double)this.getPinnedMemory() / (double)this.maxDirectMemory < this.pinnedMemoryResumeRatio) {
                    this.pinnedMemoryLastCheckTime = currentTime;
                    this.resumingByPinnedMemory = true;
                    this.resumeByPinnedMemory(currentState);
                    return true;
                }
            } else if (this.resumingByPinnedMemory && lastState != ServingState.NONE_PAUSED && System.currentTimeMillis() - this.pinnedMemoryLastCheckTime < this.workerPinnedMemoryResumeKeepTime && (double)this.getPinnedMemory() / (double)this.maxDirectMemory < this.pinnedMemoryResumeRatio) {
                logger.info("currentState: {}, keep resume for {}ms after last resumeByPinnedMemory", (Object)currentState, (Object)(currentTime - this.pinnedMemoryLastCheckTime));
                return true;
            }
        }
        return false;
    }

    private void resumePush() {
        logger.info("Trigger action: RESUME PUSH");
        this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onResume("push"));
    }

    private void resumeReplicate() {
        logger.info("Trigger action: RESUME REPLICATE");
        this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onResume("replicate"));
    }

    public static enum ServingState {
        NONE_PAUSED,
        PUSH_AND_REPLICATE_PAUSED,
        PUSH_PAUSED;

    }

    public static interface ReadBufferTargetChangeListener {
        public void onChange(long var1);
    }

    public static interface MemoryPressureListener {
        public void onPause(String var1);

        public void onResume(String var1);

        public void onTrim();
    }
}

