/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http;

import java.io.Serializable;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.server.common.http.HttpServer;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class HttpServer$
implements Logging,
scala.Serializable {
    public static HttpServer$ MODULE$;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new HttpServer$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        HttpServer$ httpServer$ = this;
        synchronized (httpServer$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public HttpServer apply(String role, String host, int port, int poolSize, long stopTimeout, long idleTimeout, boolean sslEnabled, Option<String> keyStorePath, Option<String> keyStorePassword, Option<String> keyStoreType, Option<String> keyStoreAlgorithm, Seq<String> sslDisallowedProtocols, Seq<String> sslIncludeCipherSuites) {
        ServerConnector serverConnector;
        QueuedThreadPool pool = new QueuedThreadPool(package$.MODULE$.max(poolSize, 8));
        pool.setName(new StringBuilder(16).append(role).append("-JettyThreadPool").toString());
        pool.setDaemon(true);
        Server server = new Server((ThreadPool)pool);
        server.setStopTimeout(stopTimeout);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setServer(server);
        server.addBean((Object)errorHandler);
        ContextHandlerCollection collection = new ContextHandlerCollection();
        server.setHandler((Handler)collection);
        ScheduledExecutorScheduler serverExecutor = new ScheduledExecutorScheduler(new StringBuilder(15).append(role).append("-JettyScheduler").toString(), true);
        HttpConfiguration httpConf = new HttpConfiguration();
        if (sslEnabled) {
            if (keyStorePath.isEmpty()) {
                throw new IllegalArgumentException("KeyStorePath is not provided for SSL connection.");
            }
            if (keyStorePassword.isEmpty()) {
                throw new IllegalArgumentException("KeyStorePassword is not provided for SSL connection.");
            }
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("HTTP Server SSL: adding excluded protocols: ").append(sslDisallowedProtocols.mkString(",")).toString());
            sslContextFactory.addExcludeProtocols((String[])sslDisallowedProtocols.toArray(ClassTag$.MODULE$.apply(String.class)));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("HTTP Server SSL: SslContextFactory.getExcludeProtocols = ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sslContextFactory.getExcludeProtocols())).mkString(",")).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("HTTP Server SSL: adding included cipher suites: ").append(sslIncludeCipherSuites.mkString(",")).toString());
            sslContextFactory.setIncludeCipherSuites((String[])sslIncludeCipherSuites.toArray(ClassTag$.MODULE$.apply(String.class)));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("HTTP Server SSL: SslContextFactory.getIncludeCipherSuites = ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sslContextFactory.getIncludeCipherSuites())).mkString(",")).toString());
            sslContextFactory.setKeyStorePath((String)keyStorePath.get());
            sslContextFactory.setKeyStorePassword((String)keyStorePassword.get());
            keyStoreType.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                sslContextFactory.setKeyStoreType(x$1);
                return BoxedUnit.UNIT;
            });
            keyStoreAlgorithm.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                sslContextFactory.setKeyManagerFactoryAlgorithm(x$1);
                return BoxedUnit.UNIT;
            });
            serverConnector = new ServerConnector(server, null, (Scheduler)serverExecutor, null, -1, -1, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.toString()), new HttpConnectionFactory(httpConf)});
        } else {
            serverConnector = new ServerConnector(server, null, (Scheduler)serverExecutor, null, -1, -1, new ConnectionFactory[]{new HttpConnectionFactory(httpConf)});
        }
        ServerConnector connector = serverConnector;
        connector.setHost(host);
        connector.setPort(port);
        connector.setReuseAddress(!SystemUtils.IS_OS_WINDOWS);
        connector.setAcceptQueueSize(package$.MODULE$.min(connector.getAcceptors(), 8));
        connector.setStopTimeout(stopTimeout);
        connector.setIdleTimeout(idleTimeout);
        return new HttpServer(role, server, connector, collection);
    }

    public HttpServer apply(String role, Server server, ServerConnector connector, ContextHandlerCollection rootHandler) {
        return new HttpServer(role, server, connector, rootHandler);
    }

    public Option<Tuple4<String, Server, ServerConnector, ContextHandlerCollection>> unapply(HttpServer x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.role(), (Object)x$0.server(), (Object)x$0.connector(), (Object)x$0.rootHandler()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HttpServer$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

