/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.TransportContext;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientBootstrap;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.sasl.SaslClientBootstrap;
import org.apache.celeborn.common.network.sasl.SaslServerBootstrap;
import org.apache.celeborn.common.network.sasl.registration.RegistrationClientBootstrap;
import org.apache.celeborn.common.network.sasl.registration.RegistrationServerBootstrap;
import org.apache.celeborn.common.network.server.TransportServer;
import org.apache.celeborn.common.network.server.TransportServerBootstrap;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.RpcEndpointAddress;
import org.apache.celeborn.common.rpc.RpcEndpointNotFoundException;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.rpc.RpcEnvConfig;
import org.apache.celeborn.common.rpc.RpcEnvStoppedException;
import org.apache.celeborn.common.rpc.RpcSecurityContext;
import org.apache.celeborn.common.rpc.RpcSource;
import org.apache.celeborn.common.rpc.RpcTimeout;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv$;
import org.apache.celeborn.common.rpc.netty.NettyRpcHandler;
import org.apache.celeborn.common.rpc.netty.OneWayOutboxMessage;
import org.apache.celeborn.common.rpc.netty.Outbox;
import org.apache.celeborn.common.rpc.netty.OutboxMessage;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier$;
import org.apache.celeborn.common.rpc.netty.RpcFailure;
import org.apache.celeborn.common.rpc.netty.RpcOutboxMessage;
import org.apache.celeborn.common.serializer.JavaSerializerInstance;
import org.apache.celeborn.common.serializer.SerializationStream;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u001dd\u0001\u0002 @\u00011C\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0017\u0005\t9\u0002\u0011\t\u0011)A\u00053\"AQ\f\u0001B\u0001B\u0003%a\fC\u0003e\u0001\u0011\u0005Q\rC\u0004k\u0001\t\u0007I\u0011A6\t\rA\u0004\u0001\u0015!\u0003m\u0011\u001d\t\bA1A\u0005\u0002IDa\u0001 \u0001!\u0002\u0013\u0019\b\u0002C?\u0001\u0005\u0004%\t!\u0012@\t\u000f\u0005=\u0001\u0001)A\u0005\u007f\"I\u0011\u0011\u0003\u0001C\u0002\u0013%\u00111\u0003\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0016!I\u0011Q\u0004\u0001C\u0002\u0013%\u0011q\u0004\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\"!I\u0011\u0011\u0006\u0001A\u0002\u0013%\u00111\u0006\u0005\n\u0003g\u0001\u0001\u0019!C\u0005\u0003kA\u0001\"!\u0011\u0001A\u0003&\u0011Q\u0006\u0005\u000b\u0003\u0007\u0002!\u0019!C\u0001\u007f\u0005\u0015\u0003\u0002CA(\u0001\u0001\u0006I!a\u0012\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T!I\u0011q\u000e\u0001C\u0002\u0013\u0005\u0011\u0011\u000f\u0005\t\u0003s\u0002\u0001\u0015!\u0003\u0002t!I\u00111\u0010\u0001C\u0002\u0013%\u0011Q\u0010\u0005\t\u0003\u0017\u0003\u0001\u0015!\u0003\u0002\u0000!Q\u0011Q\u0012\u0001C\u0002\u0013\u0005Q)a$\t\u0011\u0005]\u0005\u0001)A\u0005\u0003#C1\"!'\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001c\"Y\u0011q\u0015\u0001A\u0002\u0003\u0007I\u0011BAU\u0011-\ti\u000b\u0001a\u0001\u0002\u0003\u0006K!!(\t\u0013\u0005]\u0006A1A\u0005\n\u0005e\u0006\u0002CAd\u0001\u0001\u0006I!a/\t\u0013\u0005%\u0007A1A\u0005\n\u0005-\u0007\u0002CAp\u0001\u0001\u0006I!!4\t\u0011\u0005\u0005\b\u0001\"\u0001F\u0003GDq!!;\u0001\t\u0013\tY\u000fC\u0004\u0002v\u0002!\t!a>\t\u0015\u0005\u001d\b\u0001#b\u0001\n\u0003\u0012i\u0002C\u0004\u00032\u0001!\tEa\r\t\u000f\t\r\u0003\u0001\"\u0001\u0003F!9!Q\n\u0001\u0005\u0002\t=\u0003b\u0002B3\u0001\u0011\u0005#q\r\u0005\b\u0005[\u0002A\u0011\u0002B8\u0011!\u0011)\t\u0001C\u0001\u000b\n\u001d\u0005\u0002\u0003BI\u0001\u0011\u0005QIa%\t\u0011\tu\u0005\u0001\"\u0001F\u0005?C\u0001B!7\u0001\t\u0003)%1\u001c\u0005\t\u0005[\u0004A\u0011A#\u0003p\"A1q\u0001\u0001\u0005\u0002\u0015\u001bI\u0001C\u0004\u0003l\u0001!\tea\b\t\u000f\r\r\u0002\u0001\"\u0011\u0004&!91q\u0005\u0001\u0005B\r\u0015\u0002bBB\u0015\u0001\u0011%1Q\u0005\u0005\b\u0007\u000f\u0001A\u0011IB\u0016\u0011\u001d\u0019i\u0004\u0001C!\u0007\u007f9\u0001b!\u0011@\u0011\u0003)51\t\u0004\b}}B\t!RB#\u0011\u0019!\u0007\b\"\u0001\u0004N!Q1q\n\u001dC\u0002\u0013\u0005Qi!\u0015\t\u0011\ru\u0003\b)A\u0005\u0007'B!ba\u00189\u0005\u0004%\t!RB1\u0011!\u0019)\u0007\u000fQ\u0001\n\r\r$a\u0003(fiRL(\u000b]2F]ZT!\u0001Q!\u0002\u000b9,G\u000f^=\u000b\u0005\t\u001b\u0015a\u0001:qG*\u0011A)R\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019;\u0015\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005!K\u0015AB1qC\u000eDWMC\u0001K\u0003\ry'oZ\u0002\u0001'\r\u0001Q*\u0015\t\u0003\u001d>k\u0011!Q\u0005\u0003!\u0006\u0013aA\u00159d\u000b:4\bC\u0001*V\u001b\u0005\u0019&B\u0001+D\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001,T\u0005\u001daunZ4j]\u001e\faaY8oM&<W#A-\u0011\u00059S\u0016BA.B\u00051\u0011\u0006oY#om\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\naC[1wCN+'/[1mSj,'/\u00138ti\u0006t7-\u001a\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\u000e\u000b!b]3sS\u0006d\u0017N_3s\u0013\t\u0019\u0007M\u0001\fKCZ\f7+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0019a\r[5\u0011\u0005\u001d\u0004Q\"A \t\u000b]#\u0001\u0019A-\t\u000bu#\u0001\u0019\u00010\u0002\u0019\r,G.\u001a2pe:\u001cuN\u001c4\u0016\u00031\u0004\"!\u001c8\u000e\u0003\rK!a\\\"\u0003\u0019\r+G.\u001a2pe:\u001cuN\u001c4\u0002\u001b\r,G.\u001a2pe:\u001cuN\u001c4!\u0003=\u0019XmY;sSRL8i\u001c8uKb$X#A:\u0011\u0007Q<\u00180D\u0001v\u0015\u00051\u0018!B:dC2\f\u0017B\u0001=v\u0005\u0019y\u0005\u000f^5p]B\u0011aJ_\u0005\u0003w\u0006\u0013!C\u00159d'\u0016\u001cWO]5us\u000e{g\u000e^3yi\u0006\u00012/Z2ve&$\u0018pQ8oi\u0016DH\u000fI\u0001\u000eiJ\fgn\u001d9peR\u001cuN\u001c4\u0016\u0003}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003vi&d'bAA\u0005\u0007\u00069a.\u001a;x_J\\\u0017\u0002BA\u0007\u0003\u0007\u0011Q\u0002\u0016:b]N\u0004xN\u001d;D_:4\u0017A\u0004;sC:\u001c\bo\u001c:u\u0007>tg\rI\u0001\u000b?J\u00048mU8ve\u000e,WCAA\u000b!\rq\u0015qC\u0005\u0004\u00033\t%!\u0003*qGN{WO]2f\u0003-y&\u000f]2T_V\u00148-\u001a\u0011\u0002\u0015\u0011L7\u000f]1uG\",'/\u0006\u0002\u0002\"A\u0019q-a\t\n\u0007\u0005\u0015rH\u0001\u0006ESN\u0004\u0018\r^2iKJ\f1\u0002Z5ta\u0006$8\r[3sA\u00051qo\u001c:lKJ,\"!!\f\u0011\u00079\u000by#C\u0002\u00022\u0005\u00131B\u00159d\u000b:$\u0007o\\5oi\u0006Qqo\u001c:lKJ|F%Z9\u0015\t\u0005]\u0012Q\b\t\u0004i\u0006e\u0012bAA\u001ek\n!QK\\5u\u0011%\ty\u0004EA\u0001\u0002\u0004\ti#A\u0002yIE\nqa^8sW\u0016\u0014\b%\u0001\tue\u0006t7\u000f]8si\u000e{g\u000e^3yiV\u0011\u0011q\t\t\u0005\u0003\u0013\nY%\u0004\u0002\u0002\b%!\u0011QJA\u0004\u0005A!&/\u00198ta>\u0014HoQ8oi\u0016DH/A\tue\u0006t7\u000f]8si\u000e{g\u000e^3yi\u0002\nac\u0019:fCR,7\t\\5f]R\u0014un\u001c;tiJ\f\u0007o\u001d\u000b\u0003\u0003+\u0002b!a\u0016\u0002`\u0005\rTBAA-\u0015\u0011\t)!a\u0017\u000b\u0005\u0005u\u0013\u0001\u00026bm\u0006LA!!\u0019\u0002Z\t!A*[:u!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$\u0002BA5\u0003\u000f\taa\u00197jK:$\u0018\u0002BA7\u0003O\u0012\u0001\u0004\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e\"p_R\u001cHO]1q\u00035\u0019G.[3oi\u001a\u000b7\r^8ssV\u0011\u00111\u000f\t\u0005\u0003K\n)(\u0003\u0003\u0002x\u0005\u001d$A\u0006+sC:\u001c\bo\u001c:u\u00072LWM\u001c;GC\u000e$xN]=\u0002\u001d\rd\u0017.\u001a8u\r\u0006\u001cGo\u001c:zA\u0005\u0001B/[7f_V$8k\u00195fIVdWM]\u000b\u0003\u0003\u007f\u0002B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000bI&\u0001\u0006d_:\u001cWO\u001d:f]RLA!!#\u0002\u0004\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002#QLW.Z8viN\u001b\u0007.\u001a3vY\u0016\u0014\b%\u0001\rdY&,g\u000e^\"p]:,7\r^5p]\u0016CXmY;u_J,\"!!%\u0011\t\u0005\u0005\u00151S\u0005\u0005\u0003+\u000b\u0019I\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\u0018!G2mS\u0016tGoQ8o]\u0016\u001cG/[8o\u000bb,7-\u001e;pe\u0002\naa]3sm\u0016\u0014XCAAO!\u0011\ty*a)\u000e\u0005\u0005\u0005&\u0002BAM\u0003\u000fIA!!*\u0002\"\nyAK]1ogB|'\u000f^*feZ,'/\u0001\u0006tKJ4XM]0%KF$B!a\u000e\u0002,\"I\u0011q\b\u000f\u0002\u0002\u0003\u0007\u0011QT\u0001\bg\u0016\u0014h/\u001a:!Q\ri\u0012\u0011\u0017\t\u0004i\u0006M\u0016bAA[k\nAao\u001c7bi&dW-A\u0004ti>\u0004\b/\u001a3\u0016\u0005\u0005m\u0006\u0003BA_\u0003\u0007l!!a0\u000b\t\u0005\u0005\u00171Q\u0001\u0007CR|W.[2\n\t\u0005\u0015\u0017q\u0018\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0011M$x\u000e\u001d9fI\u0002\n\u0001b\\;uE>DXm]\u000b\u0003\u0003\u001b\u0004\u0002\"!!\u0002P\u0006M\u0017\u0011\\\u0005\u0005\u0003#\f\u0019IA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u00042ATAk\u0013\r\t9.\u0011\u0002\u000b%B\u001c\u0017\t\u001a3sKN\u001c\bcA4\u0002\\&\u0019\u0011Q\\ \u0003\r=+HOY8y\u0003%yW\u000f\u001e2pq\u0016\u001c\b%\u0001\u0007sK6|g/Z(vi\n|\u0007\u0010\u0006\u0003\u00028\u0005\u0015\bbBAtE\u0001\u0007\u00111[\u0001\bC\u0012$'/Z:t\u0003Y\u0019'/Z1uKN+'O^3s\u0005>|Go\u001d;sCB\u001cHCAAw!\u0019\t9&a\u0018\u0002pB!\u0011qTAy\u0013\u0011\t\u00190!)\u00031Q\u0013\u0018M\\:q_J$8+\u001a:wKJ\u0014un\u001c;tiJ\f\u0007/A\u0006ti\u0006\u0014HoU3sm\u0016\u0014HCBA\u001c\u0003s\u0014\u0019\u0002C\u0004\u0002|\u0012\u0002\r!!@\u0002\u0017\tLg\u000eZ!eIJ,7o\u001d\t\u0005\u0003\u007f\u0014iA\u0004\u0003\u0003\u0002\t%\u0001c\u0001B\u0002k6\u0011!Q\u0001\u0006\u0004\u0005\u000fY\u0015A\u0002\u001fs_>$h(C\u0002\u0003\fU\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002B\b\u0005#\u0011aa\u0015;sS:<'b\u0001B\u0006k\"9!Q\u0003\u0013A\u0002\t]\u0011\u0001\u00029peR\u00042\u0001\u001eB\r\u0013\r\u0011Y\"\u001e\u0002\u0004\u0013:$XCAAjQ\r)#\u0011\u0005\t\u0005\u0005G\u0011i#\u0004\u0002\u0003&)!!q\u0005B\u0015\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0005W\tQA[1wCbLAAa\f\u0003&\tAa*\u001e7mC\ndW-A\u0007tKR,\b/\u00128ea>Lg\u000e\u001e\u000b\u0007\u0005k\u0011YDa\u0010\u0011\u00079\u00139$C\u0002\u0003:\u0005\u0013aB\u00159d\u000b:$\u0007o\\5oiJ+g\rC\u0004\u0003>\u0019\u0002\r!!@\u0002\t9\fW.\u001a\u0005\b\u0005\u00032\u0003\u0019AA\u0017\u0003!)g\u000e\u001a9pS:$\u0018aD2iK\u000e\\'+Z4jgR,'/\u001a3\u0015\u0005\t\u001d\u0003c\u0001;\u0003J%\u0019!1J;\u0003\u000f\t{w\u000e\\3b]\u0006Y\u0012m]=oGN+G/\u001e9F]\u0012\u0004x.\u001b8u%\u00164')_!eIJ$BA!\u0015\u0003\\A1!1\u000bB,\u0005ki!A!\u0016\u000b\u0007\u0005\u0015U/\u0003\u0003\u0003Z\tU#A\u0002$viV\u0014X\rC\u0004\u0003^!\u0002\rAa\u0018\u0002\t\u0005$GM\u001d\t\u0004\u001d\n\u0005\u0014b\u0001B2\u0003\n\u0011\"\u000b]2F]\u0012\u0004x.\u001b8u\u0003\u0012$'/Z:t\u0003\u0011\u0019Ho\u001c9\u0015\t\u0005]\"\u0011\u000e\u0005\b\u0005WJ\u0003\u0019\u0001B\u001b\u0003-)g\u000e\u001a9pS:$(+\u001a4\u0002\u0019A|7\u000f\u001e+p\u001fV$(m\u001c=\u0015\r\u0005]\"\u0011\u000fB>\u0011\u001d\u0011\u0019H\u000ba\u0001\u0005k\n\u0001B]3dK&4XM\u001d\t\u0004O\n]\u0014b\u0001B=\u007f\t\u0019b*\u001a;usJ\u00038-\u00128ea>Lg\u000e\u001e*fM\"9!Q\u0010\u0016A\u0002\t}\u0014aB7fgN\fw-\u001a\t\u0004O\n\u0005\u0015b\u0001BB\u007f\tiq*\u001e;c_blUm]:bO\u0016\fAa]3oIR!\u0011q\u0007BE\u0011\u001d\u0011ih\u000ba\u0001\u0005\u0017\u00032a\u001aBG\u0013\r\u0011yi\u0010\u0002\u000f%\u0016\fX/Z:u\u001b\u0016\u001c8/Y4f\u00031\u0019'/Z1uK\u000ec\u0017.\u001a8u)\u0011\u0011)Ja'\u0011\t\u0005\u0015$qS\u0005\u0005\u00053\u000b9GA\bUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\u0011\u001d\t9\u000f\fa\u0001\u0003'\f1!Y:l+\u0011\u0011\tKa+\u0015\r\t\r&Q\u001aBh)\u0011\u0011)K!0\u0011\r\tM#q\u000bBT!\u0011\u0011IKa+\r\u0001\u00119!QV\u0017C\u0002\t=&!\u0001+\u0012\t\tE&q\u0017\t\u0004i\nM\u0016b\u0001B[k\n9aj\u001c;iS:<\u0007c\u0001;\u0003:&\u0019!1X;\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003@6\n\t\u0011q\u0001\u0003B\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\r\t\r'\u0011\u001aBT\u001b\t\u0011)MC\u0002\u0003HV\fqA]3gY\u0016\u001cG/\u0003\u0003\u0003L\n\u0015'\u0001C\"mCN\u001cH+Y4\t\u000f\tuT\u00061\u0001\u0003\f\"9!\u0011[\u0017A\u0002\tM\u0017a\u0002;j[\u0016|W\u000f\u001e\t\u0004\u001d\nU\u0017b\u0001Bl\u0003\nQ!\u000b]2US6,w.\u001e;\u0002\u0013M,'/[1mSj,G\u0003\u0002Bo\u0005S\u0004BAa8\u0003f6\u0011!\u0011\u001d\u0006\u0005\u0005G\fY&A\u0002oS>LAAa:\u0003b\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000f\t-h\u00061\u0001\u00038\u000691m\u001c8uK:$\u0018aD:fe&\fG.\u001b>f'R\u0014X-Y7\u0015\t\tE(q\u001f\t\u0004?\nM\u0018b\u0001B{A\n\u00192+\u001a:jC2L'0\u0019;j_:\u001cFO]3b[\"9!\u0011`\u0018A\u0002\tm\u0018aA8viB!!Q`B\u0002\u001b\t\u0011yP\u0003\u0003\u0004\u0002\u0005m\u0013AA5p\u0013\u0011\u0019)Aa@\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u0017\u0011,7/\u001a:jC2L'0Z\u000b\u0005\u0007\u0017\u0019\t\u0002\u0006\u0004\u0004\u000e\re11\u0004\u000b\u0005\u0007\u001f\u0019\u0019\u0002\u0005\u0003\u0003*\u000eEAa\u0002BWa\t\u0007!q\u0016\u0005\n\u0007+\u0001\u0014\u0011!a\u0002\u0007/\t!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\u0011\u0019M!3\u0004\u0010!9\u0011\u0011\u000e\u0019A\u0002\tU\u0005bBB\u000fa\u0001\u0007!Q\\\u0001\u0006Ef$Xm\u001d\u000b\u0005\u0005k\u0019\t\u0003C\u0004\u0003BE\u0002\r!!\f\u0002\u0011MDW\u000f\u001e3po:$\"!a\u000e\u0002!\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>t\u0017aB2mK\u0006tW\u000f]\u000b\u0005\u0007[\u0019\t\u0004\u0006\u0003\u00040\rM\u0002\u0003\u0002BU\u0007c!qA!,6\u0005\u0004\u0011y\u000bC\u0004\u00046U\u0002\raa\u000e\u0002+\u0011,7/\u001a:jC2L'0\u0019;j_:\f5\r^5p]B)Ao!\u000f\u00040%\u001911H;\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014!\u0003:qGN{WO]2f)\t\t)\"A\u0006OKR$\u0018P\u00159d\u000b:4\bCA49'\u0011A4qI)\u0011\u0007Q\u001cI%C\u0002\u0004LU\u0014a!\u00118z%\u00164GCAB\"\u0003)\u0019WO\u001d:f]R,eN^\u000b\u0003\u0007'\u0002Ra!\u0016\u0004Z\u0019l!aa\u0016\u000b\u0007\u0005\u0015Q/\u0003\u0003\u0004\\\r]#a\u0004#z]\u0006l\u0017n\u0019,be&\f'\r\\3\u0002\u0017\r,(O]3oi\u0016sg\u000fI\u0001\u000eGV\u0014(/\u001a8u\u00072LWM\u001c;\u0016\u0005\r\r\u0004CBB+\u00073\u0012)*\u0001\bdkJ\u0014XM\u001c;DY&,g\u000e\u001e\u0011")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    @Nullable
    private RpcAddress address;
    private final RpcEnvConfig config;
    private final JavaSerializerInstance javaSerializerInstance;
    private final CelebornConf celebornConf;
    private final Option<RpcSecurityContext> securityContext;
    private final TransportConf transportConf;
    private final RpcSource _rpcSource;
    private final Dispatcher dispatcher;
    private RpcEndpoint worker;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public RpcEnvConfig config() {
        return this.config;
    }

    public CelebornConf celebornConf() {
        return this.celebornConf;
    }

    public Option<RpcSecurityContext> securityContext() {
        return this.securityContext;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private RpcSource _rpcSource() {
        return this._rpcSource;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private RpcEndpoint worker() {
        return this.worker;
    }

    private void worker_$eq(RpcEndpoint x$1) {
        this.worker = x$1;
    }

    public TransportContext transportContext() {
        return this.transportContext;
    }

    private List<TransportClientBootstrap> createClientBootstraps() {
        Option bootstrapOpt = this.securityContext().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.clientSaslContext().map((Function1 & Serializable & scala.Serializable)clientSaslContext -> {
            if (clientSaslContext.addRegistrationBootstrap()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Add registration client bootstrap");
                return new RegistrationClientBootstrap(this.transportConf(), clientSaslContext.appId(), clientSaslContext.saslCredentials(), clientSaslContext.registrationInfo());
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Add sasl client bootstrap");
            return new SaslClientBootstrap(this.transportConf(), clientSaslContext.appId(), clientSaslContext.saslCredentials());
        }));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstrapOpt.toList()).asJava();
    }

    public TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        Outbox outbox = this.outboxes().remove(address);
        if (outbox != null) {
            outbox.stop();
            return;
        }
    }

    private List<TransportServerBootstrap> createServerBootstraps() {
        Option bootstrapOpt = this.securityContext().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.serverSaslContext().map((Function1 & Serializable & scala.Serializable)serverSaslContext -> {
            if (serverSaslContext.addRegistrationBootstrap()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Add registration server bootstrap");
                return new RegistrationServerBootstrap(this.transportConf(), serverSaslContext.secretRegistry());
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Add sasl server bootstrap");
            return new SaslServerBootstrap(this.transportConf(), serverSaslContext.secretRegistry());
        }));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstrapOpt.toList()).asJava();
    }

    public void startServer(String bindAddress, int port) {
        this.server_$eq(this.transportContext().createServer(bindAddress, port, this.createServerBootstraps()));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() != null ? new RpcAddress(this.config().advertiseAddress(), this.server().getPort()) : null;
                this.bitmap$0 = true;
            }
        }
        return this.address;
    }

    @Override
    public RpcAddress address() {
        if (!this.bitmap$0) {
            return this.address$lzycompute();
        }
        return this.address;
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint) {
        block1: {
            block0: {
                String string = name;
                String string2 = RpcNameConstants.WORKER_EP;
                if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
                String string3 = name;
                String string4 = RpcNameConstants.WORKER_INTERNAL_EP;
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block1;
            }
            this.worker_$eq(endpoint);
        }
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    public boolean checkRegistered() {
        if (this.worker() == null) {
            return true;
        }
        return this.worker().checkRegistered();
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByAddr(RpcEndpointAddress addr) {
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.celebornConf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(addr.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1 & Serializable & scala.Serializable)find -> NettyRpcEnv.$anonfun$asyncSetupEndpointRefByAddr$1(this, addr, BoxesRunTime.unboxToBoolean((Object)find)), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        Outbox targetOutbox;
        Outbox outbox;
        if (receiver.client() != null && receiver.client().isActive()) {
            message.sendWith(receiver.client());
            return;
        }
        Predef$.MODULE$.require(receiver.address() != null, (Function0 & Serializable & scala.Serializable)() -> "Cannot send message to client endpoint with no listen address.");
        Outbox outbox2 = this.outboxes().get(receiver.address());
        if (outbox2 == null) {
            Outbox newOutbox = new Outbox(this, receiver.address());
            Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
            outbox = oldOutbox == null ? newOutbox : oldOutbox;
        } else {
            outbox = targetOutbox = outbox2;
        }
        if (this.stopped().get()) {
            this.outboxes().remove(receiver.address());
            targetOutbox.stop();
            return;
        }
        targetOutbox.send(message);
    }

    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
            }
            catch (RpcEnvStoppedException e) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            }
            return;
        }
        this.postToOutbox(message.receiver(), new OneWayOutboxMessage(message.serialize(this)));
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    NettyRpcEnv.$anonfun$ask$4(this, promise, x0$1);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(message.serialize(this), (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
                    this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
                    return BoxedUnit.UNIT;
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(client, response) -> {
                    this.onSuccess$1(this.deserialize(client, response, ClassTag$.MODULE$.Any()), promise);
                    return BoxedUnit.UNIT;
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().failed().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    NettyRpcEnv.$anonfun$ask$7(rpcMessage, x0$2);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, remoteAddr, timeout, promise){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcAddress remoteAddr$1;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;

                public void run() {
                    this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringBuilder(34).append("Cannot receive any reply from ").append(this.remoteAddr$1).append(" ").append("in ").append(this.timeout$1.duration()).toString()), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.remoteAddr$1 = remoteAddr$1;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)timeoutCancelable.cancel(true)), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e2 = (Throwable)option.get();
                this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e2, promise);
            }
            throw throwable;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(this.address()), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public SerializationStream serializeStream(OutputStream out) {
        return this.javaSerializerInstance.serializeStream(out);
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0 & Serializable & scala.Serializable)() -> this.deserialize((Function0 & Serializable & scala.Serializable)() -> $this.javaSerializerInstance.deserialize(bytes, evidence$2)));
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        if (!this.stopped().compareAndSet(false, true)) {
            return;
        }
        for (Outbox outbox : this.outboxes().values()) {
            this.outboxes().remove(outbox.address());
            outbox.stop();
        }
        Object object = this.timeoutScheduler() != null ? this.timeoutScheduler().shutdownNow() : BoxedUnit.UNIT;
        if (this.dispatcher() != null) {
            this.dispatcher().stop();
        }
        if (this.server() != null) {
            this.server().close();
        }
        if (this.clientFactory() != null) {
            this.clientFactory().close();
        }
        if (this.transportContext() != null) {
            this.transportContext().close();
        }
        if (this.clientConnectionExecutor() != null) {
            this.clientConnectionExecutor().shutdownNow();
            return;
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    @Override
    public RpcSource rpcSource() {
        return this._rpcSource();
    }

    public static final /* synthetic */ Future $anonfun$asyncSetupEndpointRefByAddr$1(NettyRpcEnv $this, RpcEndpointAddress addr$1, boolean find) {
        if (find) {
            return Future$.MODULE$.successful((Object)new NettyRpcEndpointRef($this.celebornConf(), addr$1, $this));
        }
        return Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(addr$1.toString()));
    }

    public final void org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        if (!promise$1.tryFailure(e)) {
            Throwable throwable = e;
            if (throwable instanceof RpcEnvStoppedException) {
                RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)throwable;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(rpcEnvStoppedException).toString());
                return;
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(e).toString());
            return;
        }
    }

    private final void onSuccess$1(Object reply, Promise promise$1) {
        Object object = reply;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            return;
        }
        if (!promise$1.trySuccess(object)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored message: ").append(reply.getClass().getCanonicalName()).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$ask$4(NettyRpcEnv $this, Promise promise$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object response = success.value();
            $this.onSuccess$1(response, promise$1);
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$ask$7(RpcOutboxMessage rpcMessage$1, Throwable x0$2) {
        Throwable throwable = x0$2;
        if (throwable instanceof TimeoutException) {
            rpcMessage$1.onTimeout();
            return;
        }
    }

    public NettyRpcEnv(RpcEnvConfig config, JavaSerializerInstance javaSerializerInstance) {
        this.config = config;
        this.javaSerializerInstance = javaSerializerInstance;
        super(config);
        Logging.$init$(this);
        this.celebornConf = config.conf();
        this.securityContext = config.securityContext();
        this.transportConf = Utils$.MODULE$.fromCelebornConf(this.celebornConf().clone(), config.transportModule(), BoxesRunTime.unboxToInt((Object)this.celebornConf().rpcIoThreads().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.config().numUsableCores())));
        this._rpcSource = new RpcSource(this.celebornConf(), config.role());
        this.dispatcher = new Dispatcher(this, this._rpcSource());
        this.worker = null;
        this.transportContext = new TransportContext(this.transportConf(), new NettyRpcHandler(this.dispatcher(), this), false, false, (AbstractSource)config.source().orNull(Predef$.MODULE$.$conforms()));
        this.clientFactory = this.transportContext().createClientFactory(this.createClientBootstraps());
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("celeborn-netty-rpc-env-timeout-checker");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("celeborn-netty-rpc-connection-executor", this.celebornConf().rpcConnectThreads(), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = JavaUtils.newConcurrentHashMap();
    }
}

