/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.annotations.VisibleForTesting;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.common.meta.TimeWindow;
import org.apache.celeborn.common.network.buffer.ChunkBuffers;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkStreamManager {
    private static final Logger logger = LoggerFactory.getLogger(ChunkStreamManager.class);
    private final AtomicLong nextStreamId = new AtomicLong((long)new Random().nextInt(Integer.MAX_VALUE) * 1000L);
    protected final ConcurrentHashMap<Long, StreamState> streams = JavaUtils.newConcurrentHashMap();
    protected final ConcurrentHashMap<String, Set<Long>> shuffleStreamIds = JavaUtils.newConcurrentHashMap();

    public ManagedBuffer getChunk(long streamId, int chunkIndex, int offset, int len) {
        StreamState state = this.streams.get(streamId);
        if (state == null) {
            throw new IllegalStateException(String.format("Stream %s for chunk %s is not registered(Maybe removed).", streamId, chunkIndex));
        }
        if (chunkIndex >= state.buffers.numChunks()) {
            throw new IllegalStateException(String.format("Requested chunk index beyond end %s", chunkIndex));
        }
        ChunkBuffers buffers = state.buffers;
        return buffers.chunk(chunkIndex, offset, len);
    }

    public TimeWindow getFetchTimeMetric(long streamId) {
        StreamState state = this.streams.get(streamId);
        if (state != null) {
            return state.fetchTimeMetric;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chunkBeingSent(long streamId) {
        StreamState streamState = this.streams.get(streamId);
        if (streamState != null) {
            StreamState streamState2 = streamState;
            synchronized (streamState2) {
                ++streamState.chunksBeingTransferred;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chunkSent(long streamId) {
        StreamState streamState = this.streams.get(streamId);
        if (streamState != null) {
            StreamState streamState2 = streamState;
            synchronized (streamState2) {
                --streamState.chunksBeingTransferred;
            }
        }
    }

    public long chunksBeingTransferred() {
        long sum = 0L;
        for (StreamState streamState : this.streams.values()) {
            sum += streamState.chunksBeingTransferred;
        }
        return sum;
    }

    public long registerStream(long streamId, String shuffleKey, String fileName) {
        return this.registerStream(streamId, shuffleKey, null, fileName, null);
    }

    public long registerStream(String shuffleKey, ChunkBuffers buffers, String fileName, TimeWindow fetchTimeMetric) {
        long myStreamId = this.nextStreamId.getAndIncrement();
        return this.registerStream(myStreamId, shuffleKey, buffers, fileName, fetchTimeMetric);
    }

    public long registerStream(long streamId, String shuffleKey, ChunkBuffers buffers, String fileName, TimeWindow fetchTimeMetric) {
        StreamState streamState = new StreamState(shuffleKey, buffers, fileName, fetchTimeMetric);
        this.streams.put(streamId, streamState);
        this.shuffleStreamIds.compute(shuffleKey, (key, value) -> {
            if (value == null) {
                value = ConcurrentHashMap.newKeySet();
            }
            value.add(streamId);
            return value;
        });
        return streamId;
    }

    public long nextStreamId() {
        return this.nextStreamId.getAndIncrement();
    }

    public void cleanupExpiredShuffleKey(Set<String> expiredShuffleKeys) {
        logger.info("Clean up expired shuffle keys {}", (Object)String.join((CharSequence)",", expiredShuffleKeys.toArray(new String[0])));
        for (String expiredShuffleKey : expiredShuffleKeys) {
            Set<Long> expiredStreamIds = this.shuffleStreamIds.remove(expiredShuffleKey);
            if (expiredStreamIds == null || expiredStreamIds.isEmpty()) continue;
            expiredStreamIds.forEach(this.streams::remove);
        }
        logger.info("Cleaned up expired shuffle keys. The count of shuffle keys and streams: {}, {}", (Object)this.shuffleStreamIds.size(), (Object)this.streams.size());
    }

    public StreamState getStreamState(long streamId) {
        return this.streams.get(streamId);
    }

    public int getStreamsCount() {
        return this.streams.size();
    }

    @VisibleForTesting
    public long numShuffleSteams() {
        return this.shuffleStreamIds.values().stream().mapToLong(Set::size).sum();
    }

    public static class StreamState {
        public final ChunkBuffers buffers;
        public final String shuffleKey;
        public final String fileName;
        public final TimeWindow fetchTimeMetric;
        volatile long chunksBeingTransferred = 0L;

        StreamState(String shuffleKey, ChunkBuffers buffers, String fileName, TimeWindow fetchTimeMetric) {
            this.buffers = buffers;
            this.shuffleKey = shuffleKey;
            this.fileName = fileName;
            this.fetchTimeMetric = fetchTimeMetric;
        }
    }
}

