/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.http.api.v1;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.celeborn.rest.v1.model.ApplicationHeartbeatData;
import org.apache.celeborn.rest.v1.model.ApplicationsHeartbeatResponse;
import org.apache.celeborn.rest.v1.model.DeleteAppsRequest;
import org.apache.celeborn.rest.v1.model.HandleResponse;
import org.apache.celeborn.rest.v1.model.HostnamesResponse;
import org.apache.celeborn.rest.v1.model.ReviseLostShufflesRequest;
import org.apache.celeborn.server.common.HttpService;
import org.apache.celeborn.server.common.http.api.ApiRequestContext;
import org.apache.celeborn.service.deploy.master.Master;
import org.apache.celeborn.service.deploy.master.clustermeta.AbstractMetaManager;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Tag(name="Application")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0004\t\u0001mAQ\u0001\f\u0001\u0005\u00025BQ\u0001\r\u0001\u0005\nEBQ\u0001\u000f\u0001\u0005\u0002eBQ! \u0001\u0005\u0002yDq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002X\u0001!\t!!\u0017\u0003'\u0005\u0003\b\u000f\\5dCRLwN\u001c*fg>,(oY3\u000b\u0005%Q\u0011A\u0001<2\u0015\tYA\"A\u0002ba&T!!\u0004\b\u0002\t!$H\u000f\u001d\u0006\u0003\u001fA\ta!\\1ti\u0016\u0014(BA\t\u0013\u0003\u0019!W\r\u001d7ps*\u00111\u0003F\u0001\bg\u0016\u0014h/[2f\u0015\t)b#\u0001\u0005dK2,'m\u001c:o\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\b\u0012\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g!\t\u0019#&D\u0001%\u0015\tYQE\u0003\u0002\u000eM)\u0011q\u0005K\u0001\u0007G>lWn\u001c8\u000b\u0005%\"\u0012AB:feZ,'/\u0003\u0002,I\t\t\u0012\t]5SKF,Xm\u001d;D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005q\u0003CA\u0018\u0001\u001b\u0005A\u0011\u0001D:uCR,8oU=ti\u0016lW#\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0005Ur\u0011aC2mkN$XM]7fi\u0006L!a\u000e\u001b\u0003'\u0005\u00137\u000f\u001e:bGRlU\r^1NC:\fw-\u001a:\u0002\u0019\u0005\u0004\b\u000f\\5dCRLwN\\:\u0015\u0003i\u0002\"aO!\u000e\u0003qR!!\u0010 \u0002\u000b5|G-\u001a7\u000b\u0005%y$B\u0001!\u0015\u0003\u0011\u0011Xm\u001d;\n\u0005\tc$!H!qa2L7-\u0019;j_:\u001c\b*Z1si\n,\u0017\r\u001e*fgB|gn]3)\u0005\r!\u0005CA#M\u001b\u00051%BA$I\u0003\t\u00118O\u0003\u0002J\u0015\u0006\u0011qo\u001d\u0006\u0002\u0017\u0006)!.\u0019<bq&\u0011QJ\u0012\u0002\u0004\u000f\u0016#\u0006FB\u0002P?\u0002\u00147\r\u0005\u0002Q;6\t\u0011K\u0003\u0002S'\u0006I!/Z:q_:\u001cXm\u001d\u0006\u0003)V\u000b1\"\u00198o_R\fG/[8og*\u0011akV\u0001\u0004_\u0006\u001c(B\u0001-Z\u0003\t18G\u0003\u0002[7\u000691o^1hO\u0016\u0014(\"\u0001/\u0002\u0005%|\u0017B\u00010R\u0005-\t\u0005/\u001b*fgB|gn]3\u0002\u0019I,7\u000f]8og\u0016\u001cu\u000eZ3\"\u0003\u0005\f1A\r\u00191\u0003\u001d\u0019wN\u001c;f]Rd\u0013\u0001Z\u0016\u0006K.dgn\u001c\t\u0003M&l\u0011a\u001a\u0006\u0003QN\u000bQ!\\3eS\u0006L!A[4\u0003\u000f\r{g\u000e^3oi\u0006IQ.\u001a3jCRK\b/Z\u0011\u0002[\u0006\u0001\u0012\r\u001d9mS\u000e\fG/[8o_)\u001cxN\\\u0001\u0007g\u000eDW-\\1,\u0007A\u001cH\u000f\u0005\u0002gc&\u0011!o\u001a\u0002\u0007'\u000eDW-\\1\u0002\u001d%l\u0007\u000f\\3nK:$\u0018\r^5p]\u000e\n!\b\u000b\u0003\u0004mj\\\bCA<y\u001b\u0005\u0019\u0016BA=T\u0005%y\u0005/\u001a:bi&|g.A\u0006eKN\u001c'/\u001b9uS>t\u0017%\u0001?\u0002e1K7\u000f\u001e\u0011bY2\u0004#/\u001e8oS:<\u0007%\u00199qY&\u001c\u0017\r^5p]\u001e\u001a\b%\u001b3tA=4\u0007\u0005\u001e5fA\rdWo\u001d;fe:\n!\u0002Z3mKR,\u0017\t\u001d9t)\ry\u0018Q\u0001\t\u0004w\u0005\u0005\u0011bAA\u0002y\tq\u0001*\u00198eY\u0016\u0014Vm\u001d9p]N,\u0007bBA\u0004\t\u0001\u0007\u0011\u0011B\u0001\be\u0016\fX/Z:u!\rY\u00141B\u0005\u0004\u0003\u001ba$!\u0005#fY\u0016$X-\u00119qgJ+\u0017/^3ti\":A!!\u0005\u0002\u0018\u0005e\u0001cA#\u0002\u0014%\u0019\u0011Q\u0003$\u0003\tA\u000bG\u000f[\u0001\u0006m\u0006dW/Z\u0011\u0003\u00037\tAb\f3fY\u0016$XmX1qaND3\u0001BA\u0010!\r)\u0015\u0011E\u0005\u0004\u0003G1%\u0001\u0002)P'RCs\u0001B(`A\n\f9\u0003\f\u0002\u0002*-2Qm\u001b7o\u0003WYC\u0001]:\u0002.\r\nq\u0010K\u0003\u0005mj\f\t$\t\u0002\u00024\u0005AB)\u001a7fi\u0016\u0004#/Z:pkJ\u001cW\rI8gA\u0005\u0004\bo\u001d\u0018\u0002\u0013!|7\u000f\u001e8b[\u0016\u001cHCAA\u001d!\rY\u00141H\u0005\u0004\u0003{a$!\u0005%pgRt\u0017-\\3t%\u0016\u001c\bo\u001c8tK\":Q!!\u0005\u0002\u0018\u0005\u0005\u0013EAA\"\u0003)y\u0003n\\:u]\u0006lWm\u001d\u0015\u0003\u000b\u0011Cs!B(`A\n\fI\u0005\f\u0002\u0002L-2Qm\u001b7o\u0003\u001bZC\u0001]:\u0002P\r\u0012\u0011\u0011\b\u0015\u0006\u000bYT\u00181K\u0011\u0003\u0003+\n1\nT5ti\u0002\nG\u000e\u001c\u0011sk:t\u0017N\\4!CB\u0004H.[2bi&|gnJ:!\u0019&4WmY=dY\u0016l\u0015M\\1hKJ<3\u000f\t5pgRt\u0017-\\3tA=4\u0007\u0005\u001e5fA\rdWo\u001d;fe:\n!C]3wSN,Gj\\:u'\",hM\u001a7fgR\u0019q0a\u0017\t\u000f\u0005\u001da\u00011\u0001\u0002^A\u00191(a\u0018\n\u0007\u0005\u0005DHA\rSKZL7/\u001a'pgR\u001c\u0006.\u001e4gY\u0016\u001c(+Z9vKN$\bf\u0001\u0004\u0002 !:aaT0aE\u0006\u001dDFAA\u0015Q\u001d1\u0011\u0011CA\f\u0003W\n#!!\u001c\u0002+=\u0012XM^5tK~cwn\u001d;`g\",hM\u001a7fg\"*aA\u001e>\u0002r\u0005\u0012\u00111O\u0001<%\u00164\u0018n]3!Y>\u001cH\u000fI:ik\u001a4G.Z:!_J\u0004C-\u001a7fi\u0016$\u0007e\u001d5vM\u001adWm\u001d\u0011pM\u0002\ng\u000eI1qa2L7-\u0019;j_:t\u0003f\u0002\u0001\u0002x\u0005]\u0011Q\u0010\t\u0004\u000b\u0006e\u0014bAA>\r\nA1i\u001c8tk6,7\u000fL\u0001mQ\u001d\u0001\u0011\u0011QA\f\u0003\u000f\u00032!RAB\u0013\r\t)I\u0012\u0002\t!J|G-^2fg2\nA\u000eK\u0004\u0001\u0003\u0017\u000b9*!'\u0011\t\u00055\u00151S\u0007\u0003\u0003\u001fS1!!%T\u0003\u0011!\u0018mZ:\n\t\u0005U\u0015q\u0012\u0002\u0004)\u0006<\u0017\u0001\u00028b[\u0016\f#!a'\u0002\u0017\u0005\u0003\b\u000f\\5dCRLwN\u001c")
public class ApplicationResource
implements ApiRequestContext {
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public final HttpService httpService() {
        return ApiRequestContext.httpService$((ApiRequestContext)this);
    }

    public String normalizeParam(String param) {
        return ApiRequestContext.normalizeParam$((ApiRequestContext)this, (String)param);
    }

    public ServletContext servletContext() {
        return this.servletContext;
    }

    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private AbstractMetaManager statusSystem() {
        return ((Master)this.httpService()).statusSystem();
    }

    @Operation(description="List all running application's ids of the cluster.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationsHeartbeatResponse.class))})
    @GET
    public ApplicationsHeartbeatResponse applications() {
        return new ApplicationsHeartbeatResponse().applications((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.statusSystem().appHeartbeatTime).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String appId = (String)tuple2._1();
                Long heartbeat = (Long)tuple2._2();
                return new ApplicationHeartbeatData().appId(appId).lastHeartbeatTimestamp(heartbeat);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq()).asJava());
    }

    @Operation(description="Delete resource of apps.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/delete_apps")
    public HandleResponse deleteApps(DeleteAppsRequest request) {
        Buffer apps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(request.getApps()).asScala();
        apps.foreach((Function1 & Serializable & scala.Serializable)app -> {
            ApplicationResource.$anonfun$deleteApps$1(this, app);
            return BoxedUnit.UNIT;
        });
        return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(24).append("deleted shuffles of app ").append(apps).toString());
    }

    @Operation(description="List all running application's LifecycleManager's hostnames of the cluster.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HostnamesResponse.class))})
    @GET
    @Path(value="/hostnames")
    public HostnamesResponse hostnames() {
        return new HostnamesResponse().hostnames((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.statusSystem().hostnameSet).asScala()).toSeq()).asJava());
    }

    @Operation(description="Revise lost shuffles or deleted shuffles of an application.")
    @Path(value="/revise_lost_shuffles")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    public HandleResponse reviseLostShuffles(ReviseLostShufflesRequest request) {
        String appId = request.getAppId();
        List shuffleIds = request.getShuffleIds();
        this.statusSystem().reviseLostShuffles(appId, shuffleIds);
        return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(27).append("revised app:").append(appId).append(" lost shuffles:").append(shuffleIds).toString());
    }

    public static final /* synthetic */ void $anonfun$deleteApps$1(ApplicationResource $this, String app) {
        $this.statusSystem().deleteApp(app);
    }

    public ApplicationResource() {
        ApiRequestContext.$init$((ApiRequestContext)this);
    }
}

