/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.TransportContext;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientBootstrap;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.sasl.SaslClientBootstrap;
import org.apache.celeborn.common.network.sasl.SaslServerBootstrap;
import org.apache.celeborn.common.network.sasl.registration.RegistrationClientBootstrap;
import org.apache.celeborn.common.network.sasl.registration.RegistrationServerBootstrap;
import org.apache.celeborn.common.network.server.TransportServer;
import org.apache.celeborn.common.network.server.TransportServerBootstrap;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.RpcEndpointAddress;
import org.apache.celeborn.common.rpc.RpcEndpointNotFoundException;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.rpc.RpcEnvConfig;
import org.apache.celeborn.common.rpc.RpcEnvStoppedException;
import org.apache.celeborn.common.rpc.RpcSecurityContext;
import org.apache.celeborn.common.rpc.RpcTimeout;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv$;
import org.apache.celeborn.common.rpc.netty.NettyRpcHandler;
import org.apache.celeborn.common.rpc.netty.OneWayOutboxMessage;
import org.apache.celeborn.common.rpc.netty.Outbox;
import org.apache.celeborn.common.rpc.netty.OutboxMessage;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier$;
import org.apache.celeborn.common.rpc.netty.RpcFailure;
import org.apache.celeborn.common.rpc.netty.RpcOutboxMessage;
import org.apache.celeborn.common.serializer.JavaSerializerInstance;
import org.apache.celeborn.common.serializer.SerializationStream;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rEc\u0001B\u001e=\u0001%C\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t!\u0016\u0005\t3\u0002\u0011\t\u0011)A\u0005-\"A!\f\u0001B\u0001B\u0003%1\fC\u0003b\u0001\u0011\u0005!\rC\u0004h\u0001\t\u0007I\u0011\u00015\t\r5\u0004\u0001\u0015!\u0003j\u0011\u001dq\u0007A1A\u0005\u0002=Da!\u001f\u0001!\u0002\u0013\u0001\b\u0002\u0003>\u0001\u0005\u0004%\tAQ>\t\u000f\u0005%\u0001\u0001)A\u0005y\"I\u00111\u0002\u0001C\u0002\u0013%\u0011Q\u0002\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\u0010!I\u0011q\u0003\u0001A\u0002\u0013%\u0011\u0011\u0004\u0005\n\u0003C\u0001\u0001\u0019!C\u0005\u0003GA\u0001\"a\f\u0001A\u0003&\u00111\u0004\u0005\u000b\u0003c\u0001!\u0019!C\u0001y\u0005M\u0002\u0002CA\u001f\u0001\u0001\u0006I!!\u000e\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!I\u0011Q\f\u0001C\u0002\u0013\u0005\u0011q\f\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002b!I\u0011\u0011\u000e\u0001C\u0002\u0013%\u00111\u000e\u0005\t\u0003s\u0002\u0001\u0015!\u0003\u0002n!Q\u00111\u0010\u0001C\u0002\u0013\u0005!)! \t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003\u007fB1\"a\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\n\"Y\u0011Q\u0013\u0001A\u0002\u0003\u0007I\u0011BAL\u0011-\tY\n\u0001a\u0001\u0002\u0003\u0006K!a#\t\u0013\u0005\u0015\u0006A1A\u0005\n\u0005\u001d\u0006\u0002CA[\u0001\u0001\u0006I!!+\t\u0013\u0005]\u0006A1A\u0005\n\u0005e\u0006\u0002CAg\u0001\u0001\u0006I!a/\t\u0011\u0005=\u0007\u0001\"\u0001C\u0003#Dq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002d\u0002!\t!!:\t\u0015\u0005U\u0007\u0001#b\u0001\n\u0003\u0012Y\u0001C\u0004\u0003 \u0001!\tE!\t\t\u000f\tE\u0002\u0001\"\u0001\u00034!9!1\b\u0001\u0005\u0002\tu\u0002b\u0002B*\u0001\u0011\u0005#Q\u000b\u0005\b\u00057\u0002A\u0011\u0002B/\u0011!\u0011\u0019\b\u0001C\u0001\u0005\nU\u0004\u0002\u0003B@\u0001\u0011\u0005!I!!\t\u0011\t-\u0005\u0001\"\u0001C\u0005\u001bC\u0001Ba2\u0001\t\u0003\u0011%\u0011\u001a\u0005\t\u00057\u0004A\u0011\u0001\"\u0003^\"A!Q\u001f\u0001\u0005\u0002\t\u00139\u0010C\u0004\u0003Z\u0001!\te!\u0004\t\u000f\rE\u0001\u0001\"\u0011\u0004\u0014!91Q\u0003\u0001\u0005B\rM\u0001bBB\f\u0001\u0011%11\u0003\u0005\b\u0005k\u0004A\u0011IB\r\u000f!\u0019Y\u0003\u0010E\u0001\u0005\u000e5baB\u001e=\u0011\u0003\u00115q\u0006\u0005\u0007CV\"\taa\u000e\t\u0015\reRG1A\u0005\u0002\t\u001bY\u0004\u0003\u0005\u0004HU\u0002\u000b\u0011BB\u001f\u0011)\u0019I%\u000eb\u0001\n\u0003\u001151\n\u0005\t\u0007\u001f*\u0004\u0015!\u0003\u0004N\tYa*\u001a;usJ\u00038-\u00128w\u0015\tid(A\u0003oKR$\u0018P\u0003\u0002@\u0001\u0006\u0019!\u000f]2\u000b\u0005\u0005\u0013\u0015AB2p[6|gN\u0003\u0002D\t\u0006A1-\u001a7fE>\u0014hN\u0003\u0002F\r\u00061\u0011\r]1dQ\u0016T\u0011aR\u0001\u0004_J<7\u0001A\n\u0004\u0001)s\u0005CA&M\u001b\u0005q\u0014BA'?\u0005\u0019\u0011\u0006oY#omB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bQ\u0001\tS:$XM\u001d8bY&\u00111\u000b\u0015\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOV\ta\u000b\u0005\u0002L/&\u0011\u0001L\u0010\u0002\r%B\u001cWI\u001c<D_:4\u0017nZ\u0001\bG>tg-[4!\u0003YQ\u0017M^1TKJL\u0017\r\\5{KJLen\u001d;b]\u000e,\u0007C\u0001/`\u001b\u0005i&B\u00010A\u0003)\u0019XM]5bY&TXM]\u0005\u0003Av\u0013aCS1wCN+'/[1mSj,'/\u00138ti\u0006t7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r,g\r\u0005\u0002e\u00015\tA\bC\u0003U\t\u0001\u0007a\u000bC\u0003[\t\u0001\u00071,\u0001\u0007dK2,'m\u001c:o\u0007>tg-F\u0001j!\tQ7.D\u0001A\u0013\ta\u0007I\u0001\u0007DK2,'m\u001c:o\u0007>tg-A\u0007dK2,'m\u001c:o\u0007>tg\rI\u0001\u0010g\u0016\u001cWO]5us\u000e{g\u000e^3yiV\t\u0001\u000fE\u0002riZl\u0011A\u001d\u0006\u0002g\u0006)1oY1mC&\u0011QO\u001d\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005-;\u0018B\u0001=?\u0005I\u0011\u0006oY*fGV\u0014\u0018\u000e^=D_:$X\r\u001f;\u0002!M,7-\u001e:jif\u001cuN\u001c;fqR\u0004\u0013!\u0004;sC:\u001c\bo\u001c:u\u0007>tg-F\u0001}!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0003\u0007\u0001\u0015a\u00028fi^|'o[\u0005\u0004\u0003\u000fq(!\u0004+sC:\u001c\bo\u001c:u\u0007>tg-\u0001\bue\u0006t7\u000f]8si\u000e{gN\u001a\u0011\u0002\u0015\u0011L7\u000f]1uG\",'/\u0006\u0002\u0002\u0010A\u0019A-!\u0005\n\u0007\u0005MAH\u0001\u0006ESN\u0004\u0018\r^2iKJ\f1\u0002Z5ta\u0006$8\r[3sA\u00051qo\u001c:lKJ,\"!a\u0007\u0011\u0007-\u000bi\"C\u0002\u0002 y\u00121B\u00159d\u000b:$\u0007o\\5oi\u0006Qqo\u001c:lKJ|F%Z9\u0015\t\u0005\u0015\u00121\u0006\t\u0004c\u0006\u001d\u0012bAA\u0015e\n!QK\\5u\u0011%\tiCDA\u0001\u0002\u0004\tY\"A\u0002yIE\nqa^8sW\u0016\u0014\b%\u0001\tue\u0006t7\u000f]8si\u000e{g\u000e^3yiV\u0011\u0011Q\u0007\t\u0005\u0003o\tI$\u0004\u0002\u0002\u0002%!\u00111HA\u0001\u0005A!&/\u00198ta>\u0014HoQ8oi\u0016DH/A\tue\u0006t7\u000f]8si\u000e{g\u000e^3yi\u0002\nac\u0019:fCR,7\t\\5f]R\u0014un\u001c;tiJ\f\u0007o\u001d\u000b\u0003\u0003\u0007\u0002b!!\u0012\u0002N\u0005ESBAA$\u0015\ry\u0018\u0011\n\u0006\u0003\u0003\u0017\nAA[1wC&!\u0011qJA$\u0005\u0011a\u0015n\u001d;\u0011\t\u0005M\u0013\u0011L\u0007\u0003\u0003+RA!a\u0016\u0002\u0002\u000511\r\\5f]RLA!a\u0017\u0002V\tABK]1ogB|'\u000f^\"mS\u0016tGOQ8piN$(/\u00199\u0002\u001b\rd\u0017.\u001a8u\r\u0006\u001cGo\u001c:z+\t\t\t\u0007\u0005\u0003\u0002T\u0005\r\u0014\u0002BA3\u0003+\u0012a\u0003\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e$bGR|'/_\u0001\u000fG2LWM\u001c;GC\u000e$xN]=!\u0003A!\u0018.\\3pkR\u001c6\r[3ek2,'/\u0006\u0002\u0002nA!\u0011qNA;\u001b\t\t\tH\u0003\u0003\u0002t\u0005\u001d\u0013AC2p]\u000e,(O]3oi&!\u0011qOA9\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u0012i&lWm\\;u'\u000eDW\rZ;mKJ\u0004\u0013\u0001G2mS\u0016tGoQ8o]\u0016\u001cG/[8o\u000bb,7-\u001e;peV\u0011\u0011q\u0010\t\u0005\u0003_\n\t)\u0003\u0003\u0002\u0004\u0006E$A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\f\u0011d\u00197jK:$8i\u001c8oK\u000e$\u0018n\u001c8Fq\u0016\u001cW\u000f^8sA\u000511/\u001a:wKJ,\"!a#\u0011\t\u00055\u0015\u0011S\u0007\u0003\u0003\u001fSA!a\"\u0002\u0002%!\u00111SAH\u0005=!&/\u00198ta>\u0014HoU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR!\u0011QEAM\u0011%\tiCGA\u0001\u0002\u0004\tY)A\u0004tKJ4XM\u001d\u0011)\u0007m\ty\nE\u0002r\u0003CK1!a)s\u0005!1x\u000e\\1uS2,\u0017aB:u_B\u0004X\rZ\u000b\u0003\u0003S\u0003B!a+\u000226\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t(\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003g\u000biKA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\tgR|\u0007\u000f]3eA\u0005Aq.\u001e;c_b,7/\u0006\u0002\u0002<BA\u0011qNA_\u0003\u0003\f9-\u0003\u0003\u0002@\u0006E$!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u00191*a1\n\u0007\u0005\u0015gH\u0001\u0006Sa\u000e\fE\r\u001a:fgN\u00042\u0001ZAe\u0013\r\tY\r\u0010\u0002\u0007\u001fV$(m\u001c=\u0002\u0013=,HOY8yKN\u0004\u0013\u0001\u0004:f[>4XmT;uE>DH\u0003BA\u0013\u0003'Dq!!6!\u0001\u0004\t\t-A\u0004bI\u0012\u0014Xm]:\u0002-\r\u0014X-\u0019;f'\u0016\u0014h/\u001a:C_>$8\u000f\u001e:baN$\"!a7\u0011\r\u0005\u0015\u0013QJAo!\u0011\ti)a8\n\t\u0005\u0005\u0018q\u0012\u0002\u0019)J\fgn\u001d9peR\u001cVM\u001d<fe\n{w\u000e^:ue\u0006\u0004\u0018aC:uCJ$8+\u001a:wKJ$b!!\n\u0002h\n\u0005\u0001bBAuE\u0001\u0007\u00111^\u0001\fE&tG-\u00113ee\u0016\u001c8\u000f\u0005\u0003\u0002n\u0006mh\u0002BAx\u0003o\u00042!!=s\u001b\t\t\u0019PC\u0002\u0002v\"\u000ba\u0001\u0010:p_Rt\u0014bAA}e\u00061\u0001K]3eK\u001aLA!!@\u0002\u0000\n11\u000b\u001e:j]\u001eT1!!?s\u0011\u001d\u0011\u0019A\ta\u0001\u0005\u000b\tA\u0001]8siB\u0019\u0011Oa\u0002\n\u0007\t%!OA\u0002J]R,\"!!1)\u0007\r\u0012y\u0001\u0005\u0003\u0003\u0012\tmQB\u0001B\n\u0015\u0011\u0011)Ba\u0006\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u0003\u001a\u0005)!.\u0019<bq&!!Q\u0004B\n\u0005!qU\u000f\u001c7bE2,\u0017!D:fiV\u0004XI\u001c3q_&tG\u000f\u0006\u0004\u0003$\t%\"Q\u0006\t\u0004\u0017\n\u0015\u0012b\u0001B\u0014}\tq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007b\u0002B\u0016I\u0001\u0007\u00111^\u0001\u0005]\u0006lW\rC\u0004\u00030\u0011\u0002\r!a\u0007\u0002\u0011\u0015tG\r]8j]R\fqb\u00195fG.\u0014VmZ5ti\u0016\u0014X\r\u001a\u000b\u0003\u0005k\u00012!\u001dB\u001c\u0013\r\u0011ID\u001d\u0002\b\u0005>|G.Z1o\u0003m\t7/\u001f8d'\u0016$X\u000f]#oIB|\u0017N\u001c;SK\u001a\u0014\u00150\u00113eeR!!q\bB%!\u0019\u0011\tE!\u0012\u0003$5\u0011!1\t\u0006\u0004\u0003g\u0012\u0018\u0002\u0002B$\u0005\u0007\u0012aAR;ukJ,\u0007b\u0002B&M\u0001\u0007!QJ\u0001\u0005C\u0012$'\u000fE\u0002L\u0005\u001fJ1A!\u0015?\u0005I\u0011\u0006oY#oIB|\u0017N\u001c;BI\u0012\u0014Xm]:\u0002\tM$x\u000e\u001d\u000b\u0005\u0003K\u00119\u0006C\u0004\u0003Z\u001d\u0002\rAa\t\u0002\u0017\u0015tG\r]8j]R\u0014VMZ\u0001\ra>\u001cH\u000fV8PkR\u0014w\u000e\u001f\u000b\u0007\u0003K\u0011yF!\u001b\t\u000f\t\u0005\u0004\u00061\u0001\u0003d\u0005A!/Z2fSZ,'\u000fE\u0002e\u0005KJ1Aa\u001a=\u0005MqU\r\u001e;z%B\u001cWI\u001c3q_&tGOU3g\u0011\u001d\u0011Y\u0007\u000ba\u0001\u0005[\nq!\\3tg\u0006<W\rE\u0002e\u0005_J1A!\u001d=\u00055yU\u000f\u001e2pq6+7o]1hK\u0006!1/\u001a8e)\u0011\t)Ca\u001e\t\u000f\t-\u0014\u00061\u0001\u0003zA\u0019AMa\u001f\n\u0007\tuDH\u0001\bSKF,Xm\u001d;NKN\u001c\u0018mZ3\u0002\u0019\r\u0014X-\u0019;f\u00072LWM\u001c;\u0015\t\t\r%\u0011\u0012\t\u0005\u0003'\u0012))\u0003\u0003\u0003\b\u0006U#a\u0004+sC:\u001c\bo\u001c:u\u00072LWM\u001c;\t\u000f\u0005U'\u00061\u0001\u0002B\u0006\u0019\u0011m]6\u0016\t\t=%\u0011\u0014\u000b\u0007\u0005#\u0013YL!0\u0015\t\tM%1\u0016\t\u0007\u0005\u0003\u0012)E!&\u0011\t\t]%\u0011\u0014\u0007\u0001\t\u001d\u0011Yj\u000bb\u0001\u0005;\u0013\u0011\u0001V\t\u0005\u0005?\u0013)\u000bE\u0002r\u0005CK1Aa)s\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!\u001dBT\u0013\r\u0011IK\u001d\u0002\u0004\u0003:L\b\"\u0003BWW\u0005\u0005\t9\u0001BX\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0005c\u00139L!&\u000e\u0005\tM&b\u0001B[e\u00069!/\u001a4mK\u000e$\u0018\u0002\u0002B]\u0005g\u0013\u0001b\u00117bgN$\u0016m\u001a\u0005\b\u0005WZ\u0003\u0019\u0001B=\u0011\u001d\u0011yl\u000ba\u0001\u0005\u0003\fq\u0001^5nK>,H\u000fE\u0002L\u0005\u0007L1A!2?\u0005)\u0011\u0006o\u0019+j[\u0016|W\u000f^\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$BAa3\u0003XB!!Q\u001aBj\u001b\t\u0011yM\u0003\u0003\u0003R\u0006%\u0013a\u00018j_&!!Q\u001bBh\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u00053d\u0003\u0019\u0001BS\u0003\u001d\u0019wN\u001c;f]R\fqb]3sS\u0006d\u0017N_3TiJ,\u0017-\u001c\u000b\u0005\u0005?\u0014)\u000fE\u0002]\u0005CL1Aa9^\u0005M\u0019VM]5bY&T\u0018\r^5p]N#(/Z1n\u0011\u001d\u00119/\fa\u0001\u0005S\f1a\\;u!\u0011\u0011YO!=\u000e\u0005\t5(\u0002\u0002Bx\u0003\u0013\n!![8\n\t\tM(Q\u001e\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\fI\u0016\u001cXM]5bY&TX-\u0006\u0003\u0003z\n}HC\u0002B~\u0007\u000f\u0019I\u0001\u0006\u0003\u0003~\u000e\u0005\u0001\u0003\u0002BL\u0005\u007f$qAa'/\u0005\u0004\u0011i\nC\u0005\u0004\u00049\n\t\u0011q\u0001\u0004\u0006\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\r\tE&q\u0017B\u007f\u0011\u001d\t9F\fa\u0001\u0005\u0007Cqaa\u0003/\u0001\u0004\u0011Y-A\u0003csR,7\u000f\u0006\u0003\u0003$\r=\u0001b\u0002B\u0018_\u0001\u0007\u00111D\u0001\tg\",H\u000fZ8x]R\u0011\u0011QE\u0001\u0011C^\f\u0017\u000e\u001e+fe6Lg.\u0019;j_:\fqa\u00197fC:,\b/\u0006\u0003\u0004\u001c\r}A\u0003BB\u000f\u0007C\u0001BAa&\u0004 \u00119!1T\u001aC\u0002\tu\u0005bBB\u0012g\u0001\u00071QE\u0001\u0016I\u0016\u001cXM]5bY&T\u0018\r^5p]\u0006\u001bG/[8o!\u0015\t8qEB\u000f\u0013\r\u0019IC\u001d\u0002\n\rVt7\r^5p]B\n1BT3uif\u0014\u0006oY#omB\u0011A-N\n\u0005k\rEb\nE\u0002r\u0007gI1a!\u000es\u0005\u0019\te.\u001f*fMR\u00111QF\u0001\u000bGV\u0014(/\u001a8u\u000b:4XCAB\u001f!\u0015\u0019yda\u0011d\u001b\t\u0019\tE\u0003\u0002\u0000e&!1QIB!\u0005=!\u0015P\\1nS\u000e4\u0016M]5bE2,\u0017aC2veJ,g\u000e^#om\u0002\nQbY;se\u0016tGo\u00117jK:$XCAB'!\u0019\u0019yda\u0011\u0003\u0004\u0006q1-\u001e:sK:$8\t\\5f]R\u0004\u0003")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    @Nullable
    private RpcAddress address;
    private final RpcEnvConfig config;
    private final JavaSerializerInstance javaSerializerInstance;
    private final CelebornConf celebornConf;
    private final Option<RpcSecurityContext> securityContext;
    private final TransportConf transportConf;
    private final Dispatcher dispatcher;
    private RpcEndpoint worker;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public RpcEnvConfig config() {
        return this.config;
    }

    public CelebornConf celebornConf() {
        return this.celebornConf;
    }

    public Option<RpcSecurityContext> securityContext() {
        return this.securityContext;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private RpcEndpoint worker() {
        return this.worker;
    }

    private void worker_$eq(RpcEndpoint x$1) {
        this.worker = x$1;
    }

    public TransportContext transportContext() {
        return this.transportContext;
    }

    private List<TransportClientBootstrap> createClientBootstraps() {
        Option bootstrapOpt = this.securityContext().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.clientSaslContext().map((Function1 & Serializable & scala.Serializable)clientSaslContext -> {
            if (clientSaslContext.addRegistrationBootstrap()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Add registration client bootstrap");
                return new RegistrationClientBootstrap(this.transportConf(), clientSaslContext.appId(), clientSaslContext.saslCredentials(), clientSaslContext.registrationInfo());
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Add sasl client bootstrap");
            return new SaslClientBootstrap(this.transportConf(), clientSaslContext.appId(), clientSaslContext.saslCredentials());
        }));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstrapOpt.toList()).asJava();
    }

    public TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        Outbox outbox = this.outboxes().remove(address);
        if (outbox != null) {
            outbox.stop();
            return;
        }
    }

    private List<TransportServerBootstrap> createServerBootstraps() {
        Option bootstrapOpt = this.securityContext().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.serverSaslContext().map((Function1 & Serializable & scala.Serializable)serverSaslContext -> {
            if (serverSaslContext.addRegistrationBootstrap()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Add registration server bootstrap");
                return new RegistrationServerBootstrap(this.transportConf(), serverSaslContext.secretRegistry());
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Add sasl server bootstrap");
            return new SaslServerBootstrap(this.transportConf(), serverSaslContext.secretRegistry());
        }));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstrapOpt.toList()).asJava();
    }

    public void startServer(String bindAddress, int port) {
        this.server_$eq(this.transportContext().createServer(bindAddress, port, this.createServerBootstraps()));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() != null ? new RpcAddress(this.config().advertiseAddress(), this.server().getPort()) : null;
                this.bitmap$0 = true;
            }
        }
        return this.address;
    }

    @Override
    public RpcAddress address() {
        if (!this.bitmap$0) {
            return this.address$lzycompute();
        }
        return this.address;
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint) {
        block1: {
            block0: {
                String string = name;
                String string2 = RpcNameConstants.WORKER_EP;
                if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
                String string3 = name;
                String string4 = RpcNameConstants.WORKER_INTERNAL_EP;
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block1;
            }
            this.worker_$eq(endpoint);
        }
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    public boolean checkRegistered() {
        if (this.worker() == null) {
            return true;
        }
        return this.worker().checkRegistered();
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByAddr(RpcEndpointAddress addr) {
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.celebornConf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(addr.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1 & Serializable & scala.Serializable)find -> NettyRpcEnv.$anonfun$asyncSetupEndpointRefByAddr$1(this, addr, BoxesRunTime.unboxToBoolean((Object)find)), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        Outbox targetOutbox;
        Outbox outbox;
        if (receiver.client() != null && receiver.client().isActive()) {
            message.sendWith(receiver.client());
            return;
        }
        Predef$.MODULE$.require(receiver.address() != null, (Function0 & Serializable & scala.Serializable)() -> "Cannot send message to client endpoint with no listen address.");
        Outbox outbox2 = this.outboxes().get(receiver.address());
        if (outbox2 == null) {
            Outbox newOutbox = new Outbox(this, receiver.address());
            Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
            outbox = oldOutbox == null ? newOutbox : oldOutbox;
        } else {
            outbox = targetOutbox = outbox2;
        }
        if (this.stopped().get()) {
            this.outboxes().remove(receiver.address());
            targetOutbox.stop();
            return;
        }
        targetOutbox.send(message);
    }

    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
            }
            catch (RpcEnvStoppedException e) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            }
            return;
        }
        this.postToOutbox(message.receiver(), new OneWayOutboxMessage(message.serialize(this)));
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    NettyRpcEnv.$anonfun$ask$4(this, promise, x0$1);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(message.serialize(this), (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
                    this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
                    return BoxedUnit.UNIT;
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(client, response) -> {
                    this.onSuccess$1(this.deserialize(client, response, ClassTag$.MODULE$.Any()), promise);
                    return BoxedUnit.UNIT;
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().failed().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    NettyRpcEnv.$anonfun$ask$7(rpcMessage, x0$2);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, remoteAddr, timeout, promise){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcAddress remoteAddr$1;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;

                public void run() {
                    this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringBuilder(34).append("Cannot receive any reply from ").append(this.remoteAddr$1).append(" ").append("in ").append(this.timeout$1.duration()).toString()), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.remoteAddr$1 = remoteAddr$1;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)timeoutCancelable.cancel(true)), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e2 = (Throwable)option.get();
                this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e2, promise);
            }
            throw throwable;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public SerializationStream serializeStream(OutputStream out) {
        return this.javaSerializerInstance.serializeStream(out);
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0 & Serializable & scala.Serializable)() -> this.deserialize((Function0 & Serializable & scala.Serializable)() -> $this.javaSerializerInstance.deserialize(bytes, evidence$2)));
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        if (!this.stopped().compareAndSet(false, true)) {
            return;
        }
        for (Outbox outbox : this.outboxes().values()) {
            this.outboxes().remove(outbox.address());
            outbox.stop();
        }
        Object object = this.timeoutScheduler() != null ? this.timeoutScheduler().shutdownNow() : BoxedUnit.UNIT;
        if (this.dispatcher() != null) {
            this.dispatcher().stop();
        }
        if (this.server() != null) {
            this.server().close();
        }
        if (this.clientFactory() != null) {
            this.clientFactory().close();
        }
        if (this.transportContext() != null) {
            this.transportContext().close();
        }
        if (this.clientConnectionExecutor() != null) {
            this.clientConnectionExecutor().shutdownNow();
            return;
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    public static final /* synthetic */ Future $anonfun$asyncSetupEndpointRefByAddr$1(NettyRpcEnv $this, RpcEndpointAddress addr$1, boolean find) {
        if (find) {
            return Future$.MODULE$.successful((Object)new NettyRpcEndpointRef($this.celebornConf(), addr$1, $this));
        }
        return Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(addr$1.toString()));
    }

    public final void org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        if (!promise$1.tryFailure(e)) {
            Throwable throwable = e;
            if (throwable instanceof RpcEnvStoppedException) {
                RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)throwable;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(rpcEnvStoppedException).toString());
                return;
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(e).toString());
            return;
        }
    }

    private final void onSuccess$1(Object reply, Promise promise$1) {
        Object object = reply;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            return;
        }
        if (!promise$1.trySuccess(object)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored message: ").append(reply.getClass().getCanonicalName()).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$ask$4(NettyRpcEnv $this, Promise promise$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object response = success.value();
            $this.onSuccess$1(response, promise$1);
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$ask$7(RpcOutboxMessage rpcMessage$1, Throwable x0$2) {
        Throwable throwable = x0$2;
        if (throwable instanceof TimeoutException) {
            rpcMessage$1.onTimeout();
            return;
        }
    }

    public NettyRpcEnv(RpcEnvConfig config, JavaSerializerInstance javaSerializerInstance) {
        this.config = config;
        this.javaSerializerInstance = javaSerializerInstance;
        super(config);
        Logging.$init$(this);
        this.celebornConf = config.conf();
        this.securityContext = config.securityContext();
        this.transportConf = Utils$.MODULE$.fromCelebornConf(this.celebornConf().clone(), config.transportModule(), BoxesRunTime.unboxToInt((Object)this.celebornConf().rpcIoThreads().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.config().numUsableCores())));
        this.dispatcher = new Dispatcher(this);
        this.worker = null;
        this.transportContext = new TransportContext(this.transportConf(), new NettyRpcHandler(this.dispatcher(), this), false, false, (AbstractSource)config.source().orNull(Predef$.MODULE$.$conforms()));
        this.clientFactory = this.transportContext().createClientFactory(this.createClientBootstraps());
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("celeborn-netty-rpc-env-timeout-checker");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("celeborn-netty-rpc-connection-executor", this.celebornConf().rpcConnectThreads(), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = JavaUtils.newConcurrentHashMap();
    }
}

