/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.util;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.shaded.io.netty.util.concurrent.EventExecutor;
import org.apache.celeborn.shaded.io.netty.util.concurrent.EventExecutorChooserFactory;

public final class ConflictAvoidEventExecutorChooserFactory
implements EventExecutorChooserFactory {
    public static final ConflictAvoidEventExecutorChooserFactory INSTANCE = new ConflictAvoidEventExecutorChooserFactory();

    private ConflictAvoidEventExecutorChooserFactory() {
    }

    @Override
    public EventExecutorChooserFactory.EventExecutorChooser newChooser(EventExecutor[] executors) {
        return new ConflictAvoidEventExecutorChooser(executors);
    }

    private static final class ConflictAvoidEventExecutorChooser
    implements EventExecutorChooserFactory.EventExecutorChooser {
        private final AtomicLong idx = new AtomicLong();
        private final EventExecutor[] executors;

        ConflictAvoidEventExecutorChooser(EventExecutor[] executors) {
            this.executors = executors;
        }

        @Override
        public EventExecutor next() {
            EventExecutor executor = this.executors[(int)Math.abs(this.idx.getAndIncrement() % (long)this.executors.length)];
            if (executor.inEventLoop()) {
                executor = this.executors[(int)Math.abs(this.idx.getAndIncrement() % (long)this.executors.length)];
            }
            return executor;
        }
    }
}

