/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.util.IOMode;
import org.apache.celeborn.common.network.util.NettyMemoryMetrics;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.celeborn.shaded.io.netty.channel.Channel;
import org.apache.celeborn.shaded.io.netty.channel.EventLoopGroup;
import org.apache.celeborn.shaded.io.netty.channel.ServerChannel;
import org.apache.celeborn.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.celeborn.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.celeborn.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.celeborn.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.celeborn.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.celeborn.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.celeborn.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.celeborn.shaded.io.netty.util.internal.PlatformDependent;

public class NettyUtils {
    private static final PooledByteBufAllocator[] _sharedPooledByteBufAllocator = new PooledByteBufAllocator[2];
    private static ConcurrentHashMap<String, Integer> allocatorsIndex = JavaUtils.newConcurrentHashMap();

    public static ThreadFactory createThreadFactory(String threadPoolPrefix) {
        return new DefaultThreadFactory(threadPoolPrefix, true);
    }

    public static EventLoopGroup createEventLoop(IOMode mode, int numThreads, String threadPrefix) {
        ThreadFactory threadFactory = NettyUtils.createThreadFactory(threadPrefix);
        switch (mode) {
            case NIO: {
                return new NioEventLoopGroup(numThreads, threadFactory);
            }
            case EPOLL: {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static Class<? extends Channel> getClientChannelClass(IOMode mode) {
        switch (mode) {
            case NIO: {
                return NioSocketChannel.class;
            }
            case EPOLL: {
                return EpollSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static Class<? extends ServerChannel> getServerChannelClass(IOMode mode) {
        switch (mode) {
            case NIO: {
                return NioServerSocketChannel.class;
            }
            case EPOLL: {
                return EpollServerSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static String getRemoteAddress(Channel channel) {
        if (channel != null && channel.remoteAddress() != null) {
            return channel.remoteAddress().toString();
        }
        return "<unknown remote>";
    }

    private static PooledByteBufAllocator createPooledByteBufAllocator(boolean allowDirectBufs, boolean allowCache, int numCores) {
        if (numCores == 0) {
            numCores = Runtime.getRuntime().availableProcessors();
        }
        return new PooledByteBufAllocator(allowDirectBufs && PlatformDependent.directBufferPreferred(), Math.min(PooledByteBufAllocator.defaultNumHeapArena(), numCores), Math.min(PooledByteBufAllocator.defaultNumDirectArena(), allowDirectBufs ? numCores : 0), PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), allowCache ? PooledByteBufAllocator.defaultSmallCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultNormalCacheSize() : 0, allowCache && PooledByteBufAllocator.defaultUseCacheForAllThreads());
    }

    public static synchronized PooledByteBufAllocator getSharedPooledByteBufAllocator(CelebornConf conf, AbstractSource source, boolean allowCache) {
        int index;
        int n = index = allowCache ? 0 : 1;
        if (_sharedPooledByteBufAllocator[index] == null) {
            NettyUtils._sharedPooledByteBufAllocator[index] = NettyUtils.createPooledByteBufAllocator(true, allowCache, conf.networkAllocatorArenas());
            if (source != null) {
                new NettyMemoryMetrics(_sharedPooledByteBufAllocator[index], "shared-pool-" + index, conf.networkAllocatorVerboseMetric(), source, Collections.emptyMap());
            }
        }
        return _sharedPooledByteBufAllocator[index];
    }

    public static PooledByteBufAllocator getPooledByteBufAllocator(TransportConf conf, AbstractSource source, boolean allowCache) {
        return NettyUtils.getPooledByteBufAllocator(conf, source, allowCache, 0);
    }

    public static PooledByteBufAllocator getPooledByteBufAllocator(TransportConf conf, AbstractSource source, boolean allowCache, int coreNum) {
        if (conf.getCelebornConf().networkShareMemoryAllocator()) {
            return NettyUtils.getSharedPooledByteBufAllocator(conf.getCelebornConf(), source, allowCache && conf.getCelebornConf().networkMemoryAllocatorAllowCache());
        }
        int arenas = coreNum != 0 ? coreNum : conf.getCelebornConf().networkAllocatorArenas();
        PooledByteBufAllocator allocator = NettyUtils.createPooledByteBufAllocator(conf.preferDirectBufs(), allowCache, arenas);
        if (source != null) {
            String poolName = "default-netty-pool";
            HashMap<String, String> labels = new HashMap<String, String>();
            String moduleName = conf.getModuleName();
            if (!moduleName.isEmpty()) {
                poolName = moduleName;
                int index = allocatorsIndex.compute(moduleName, (k, v) -> v == null ? 0 : v + 1);
                labels.put("allocatorIndex", String.valueOf(index));
            }
            new NettyMemoryMetrics(allocator, poolName, conf.getCelebornConf().networkAllocatorVerboseMetric(), source, labels);
        }
        return allocator;
    }
}

