/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.clustermeta;

import java.util.List;
import java.util.Map;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.meta.AppDiskUsageMetric;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.service.deploy.master.clustermeta.AbstractMetaManager;
import org.apache.celeborn.service.deploy.master.network.CelebornRackResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleMasterMetaManager
extends AbstractMetaManager {
    private static final Logger LOG = LoggerFactory.getLogger(SingleMasterMetaManager.class);

    public SingleMasterMetaManager(RpcEnv rpcEnv, CelebornConf conf) {
        this.rpcEnv = rpcEnv;
        this.conf = conf;
        this.estimatedPartitionSize = this.initialEstimatedPartitionSize = conf.initialEstimatedPartitionSize();
        this.appDiskUsageMetric = new AppDiskUsageMetric(conf);
        this.rackResolver = new CelebornRackResolver(conf);
    }

    @Override
    public void handleRequestSlots(String shuffleKey, String hostName, Map<String, Map<String, Integer>> workerToAllocatedSlots, String requestId) {
        this.updateRequestSlotsMeta(shuffleKey, hostName, workerToAllocatedSlots);
    }

    @Override
    public void handleUnRegisterShuffle(String shuffleKey, String requestId) {
        this.updateUnregisterShuffleMeta(shuffleKey);
    }

    @Override
    public void handleAppHeartbeat(String appId, long totalWritten, long fileCount, long time, String requestId) {
        this.updateAppHeartbeatMeta(appId, time, totalWritten, fileCount);
    }

    @Override
    public void handleAppLost(String appId, String requestId) {
        this.updateAppLostMeta(appId);
    }

    @Override
    public void handleWorkerExclude(List<WorkerInfo> workersToAdd, List<WorkerInfo> workersToRemove, String requestId) {
        this.updateWorkerExcludeMeta(workersToAdd, workersToRemove);
    }

    @Override
    public void handleWorkerLost(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, String requestId) {
        this.updateWorkerLostMeta(host, rpcPort, pushPort, fetchPort, replicatePort);
    }

    @Override
    public void handleWorkerRemove(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, String requestId) {
        this.updateWorkerRemoveMeta(host, rpcPort, pushPort, fetchPort, replicatePort);
    }

    @Override
    public void handleRemoveWorkersUnavailableInfo(List<WorkerInfo> unavailableWorkers, String requestId) {
        this.removeWorkersUnavailableInfoMeta(unavailableWorkers);
    }

    @Override
    public void handleWorkerHeartbeat(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Map<String, DiskInfo> disks, Map<UserIdentifier, ResourceConsumption> userResourceConsumption, Map<String, Long> estimatedAppDiskUsage, long time, boolean highWorkload, String requestId) {
        this.updateWorkerHeartbeatMeta(host, rpcPort, pushPort, fetchPort, replicatePort, disks, userResourceConsumption, estimatedAppDiskUsage, time, highWorkload);
    }

    @Override
    public void handleRegisterWorker(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Map<String, DiskInfo> disks, Map<UserIdentifier, ResourceConsumption> userResourceConsumption, String requestId) {
        this.updateRegisterWorkerMeta(host, rpcPort, pushPort, fetchPort, replicatePort, disks, userResourceConsumption);
    }

    @Override
    public void handleReportWorkerUnavailable(List<WorkerInfo> failedNodes, String requestId) {
        this.updateMetaByReportWorkerUnavailable(failedNodes);
    }

    @Override
    public void handleUpdatePartitionSize() {
        this.updatePartitionSize();
    }
}

