/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.metrics.sink.JsonHttpRequestHandler;
import org.apache.celeborn.common.metrics.sink.ServletHttpRequestHandler;
import org.apache.celeborn.server.common.HttpService;
import org.apache.celeborn.server.common.http.HttpUtils$;
import org.apache.celeborn.server.common.http.Invalid$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001%4AAB\u0004\u0001)!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0005IAE\u000f\u001e9SKF,Xm\u001d;IC:$G.\u001a:\u000b\u0005!I\u0011\u0001\u00025uiBT!AC\u0006\u0002\r\r|W.\\8o\u0015\taQ\"\u0001\u0004tKJ4XM\u001d\u0006\u0003\u001d=\t\u0001bY3mK\n|'O\u001c\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)\u0002\u0006E\u0002\u0017;}i\u0011a\u0006\u0006\u00031e\tqa\u00195b]:,GN\u0003\u0002\u001b7\u0005)a.\u001a;us*\tA$\u0001\u0002j_&\u0011ad\u0006\u0002\u001c'&l\u0007\u000f\\3DQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005\u00012S\"A\u0011\u000b\u0005!\u0011#BA\u0012%\u0003\u0015\u0019w\u000eZ3d\u0015\t)\u0013$A\u0004iC:$G.\u001a:\n\u0005\u001d\n#a\u0004$vY2DE\u000f\u001e9SKF,Xm\u001d;\u0011\u0005%jS\"\u0001\u0016\u000b\u0005-b\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005)i\u0011B\u0001\u0018+\u0005\u001daunZ4j]\u001e\fqa]3sm&\u001cW\r\u0005\u00022e5\t\u0011\"\u0003\u00024\u0013\tY\u0001\n\u001e;q'\u0016\u0014h/[2f\u0003i\u0019XM\u001d<mKRDE\u000f\u001e9SKF,Xm\u001d;IC:$G.\u001a:t!\r1\u0014hO\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t)\u0011I\u001d:bsB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005g&t7N\u0003\u0002AY\u00059Q.\u001a;sS\u000e\u001c\u0018B\u0001\">\u0005e\u0019VM\u001d<mKRDE\u000f\u001e9SKF,Xm\u001d;IC:$G.\u001a:\u0002\rqJg.\u001b;?)\r)u\t\u0013\t\u0003\r\u0002i\u0011a\u0002\u0005\u0006_\r\u0001\r\u0001\r\u0005\u0006i\r\u0001\r!N\u0001\u0014G\"\fgN\\3m%\u0016\fGmQ8na2,G/\u001a\u000b\u0003\u0017:\u0003\"A\u000e'\n\u00055;$\u0001B+oSRDQa\u0014\u0003A\u0002A\u000b1a\u0019;y!\t1\u0012+\u0003\u0002S/\t)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\u0018\u0001D2iC:tW\r\u001c*fC\u0012\u0004DcA&V-\")q*\u0002a\u0001!\")q+\u0002a\u0001?\u0005\u0019!/Z9)\u0005\u0001I\u0006C\u0001.g\u001d\tYFM\u0004\u0002]G:\u0011QL\u0019\b\u0003=\u0006l\u0011a\u0018\u0006\u0003AN\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\t)w#\u0001\bDQ\u0006tg.\u001a7IC:$G.\u001a:\n\u0005\u001dD'\u0001C*iCJ\f'\r\\3\u000b\u0005\u0015<\u0002")
public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest>
implements Logging {
    private final HttpService service;
    private final ServletHttpRequestHandler[] servletHttpRequestHandlers;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        HttpRequestHandler httpRequestHandler = this;
        synchronized (httpRequestHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        String uri = req.uri();
        Tuple2<String, Map<String, String>> tuple2 = HttpUtils$.MODULE$.parseUri(uri);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String path = (String)tuple2._1();
        Map parameters = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)path, (Object)parameters);
        Tuple2 tuple23 = tuple22;
        String path2 = (String)tuple23._1();
        Map parameters2 = (Map)tuple23._2();
        String msg = HttpUtils$.MODULE$.handleRequest(this.service, path2, (Map<String, String>)parameters2);
        String textType = "text/plain; charset=UTF-8";
        String jsonType = "application/json";
        String string = msg;
        String string2 = Invalid$.MODULE$.invalid();
        String string3 = string;
        Tuple2 tuple24 = !(string2 != null ? !string2.equals(string3) : string3 != null) ? (this.servletHttpRequestHandlers != null ? (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.servletHttpRequestHandlers)).find((Function1 & Serializable & scala.Serializable)servlet -> BoxesRunTime.boxToBoolean((boolean)HttpRequestHandler.$anonfun$channelRead0$1(uri, servlet))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            ServletHttpRequestHandler servletHttpRequestHandler = x0$1;
            if (servletHttpRequestHandler instanceof JsonHttpRequestHandler) {
                JsonHttpRequestHandler jsonHttpRequestHandler = (JsonHttpRequestHandler)servletHttpRequestHandler;
                tuple2 = new Tuple2((Object)jsonHttpRequestHandler.handleRequest(uri), (Object)jsonType);
            } else if (servletHttpRequestHandler != null) {
                ServletHttpRequestHandler servletHttpRequestHandler2 = servletHttpRequestHandler;
                tuple2 = new Tuple2((Object)servletHttpRequestHandler2.handleRequest(uri), (Object)textType);
            } else {
                throw new MatchError((Object)servletHttpRequestHandler);
            }
            return tuple2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)new StringBuilder(14).append("Unknown path ").append(uri).append("!").toString(), (Object)textType)) : new Tuple2((Object)new StringBuilder(1).append(Invalid$.MODULE$.description(this.service.serviceName())).append(" ").append(HttpUtils$.MODULE$.help(this.service.serviceName())).toString(), (Object)textType)) : new Tuple2((Object)msg, (Object)textType);
        Tuple2 tuple25 = tuple24;
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        String response = (String)tuple25._1();
        String contentType = (String)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)response, (Object)contentType);
        Tuple2 tuple27 = tuple26;
        String response2 = (String)tuple27._1();
        String contentType2 = (String)tuple27._2();
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)response2, (Charset)CharsetUtil.UTF_8));
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType2);
        ctx.writeAndFlush((Object)res).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static final /* synthetic */ boolean $anonfun$channelRead0$1(String uri$1, ServletHttpRequestHandler servlet) {
        String string = uri$1;
        String string2 = servlet.getServletPath();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public HttpRequestHandler(HttpService service, ServletHttpRequestHandler[] servletHttpRequestHandlers) {
        this.service = service;
        this.servletHttpRequestHandlers = servletHttpRequestHandlers;
        Logging.$init$((Logging)this);
    }
}

