/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.model.basic;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.ModelChangeEventSource;
import org.scopemvc.core.ModelChangeListener;
import org.scopemvc.core.Selector;
import org.scopemvc.model.basic.BasicModelChangeEvent;

public class ModelChangeEventSupport {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$model$basic$ModelChangeEventSupport == null ? (class$org$scopemvc$model$basic$ModelChangeEventSupport = ModelChangeEventSupport.class$("org.scopemvc.model.basic.ModelChangeEventSupport")) : class$org$scopemvc$model$basic$ModelChangeEventSupport);
    private ModelChangeEventSource source;
    private ArrayList listeners;
    private int activationCount;
    static /* synthetic */ Class class$org$scopemvc$model$basic$ModelChangeEventSupport;

    public ModelChangeEventSupport(ModelChangeEventSource modelChangeEventSource) {
        if (modelChangeEventSource == null) {
            throw new IllegalArgumentException("Make an MCESupport for a specified model, not null");
        }
        this.source = modelChangeEventSource;
    }

    public boolean isModelDeactivated() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("isModelDeactivated: " + this.source);
        }
        return this.activationCount > 0;
    }

    public final void activateModel() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("activateModel: " + this.source);
        }
        --this.activationCount;
        if (this.activationCount < 0) {
            LOG.warn("unmatched activation? activationCount < 0 for: " + this.source);
        }
    }

    public final void deactivateModel() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("deactivateModel: " + this.source);
        }
        ++this.activationCount;
    }

    public synchronized void addModelChangeListener(ModelChangeListener modelChangeListener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addModelChangeListener: " + this.source + " listener: " + modelChangeListener);
        }
        if (modelChangeListener == null) {
            throw new IllegalArgumentException("Can't add null listener to: " + this.source);
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(modelChangeListener);
    }

    public synchronized void removeModelChangeListener(ModelChangeListener modelChangeListener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removeModelChangeListener: " + this.source + " listener: " + modelChangeListener);
        }
        if (modelChangeListener == null) {
            throw new IllegalArgumentException("Can't remove null listener for: " + this.source);
        }
        if (this.listeners != null) {
            this.listeners.remove(modelChangeListener);
        }
    }

    public synchronized void fireModelChange(int n, Selector selector) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireModelChange: " + n + ", " + selector + ", " + this.source);
        }
        if (this.isModelDeactivated()) {
            return;
        }
        if (this.listeners == null || this.listeners.size() < 1) {
            return;
        }
        BasicModelChangeEvent basicModelChangeEvent = new BasicModelChangeEvent();
        basicModelChangeEvent.setType(n);
        basicModelChangeEvent.setModel(this.source);
        basicModelChangeEvent.setSelector(selector);
        ArrayList arrayList = new ArrayList(this.listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ModelChangeListener modelChangeListener = (ModelChangeListener)e;
            modelChangeListener.modelChanged(basicModelChangeEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

