/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.dbutil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.objectstyle.ashwood.dbutil.Column;
import org.objectstyle.ashwood.dbutil.ForeignKey;
import org.objectstyle.ashwood.dbutil.PrimaryKey;
import org.objectstyle.ashwood.dbutil.Sequence;
import org.objectstyle.ashwood.dbutil.Table;
import org.objectstyle.ashwood.graph.Algorithm;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.GraphUtils;
import org.objectstyle.ashwood.graph.IndegreeTopologicalSort;
import org.objectstyle.ashwood.graph.MapDigraph;
import org.objectstyle.ashwood.random.Roulette;

public class RandomSchema {
    private boolean acyclic = true;
    private Digraph schemaGraph;
    private int tableCount = 10;
    private int maxReferencesPerTable = 3;
    private int maxForeignKeysPerTable = 3;
    private Random randomizer = new Random();
    private List tables = Collections.EMPTY_LIST;
    private String schemaName;
    private String catalog;
    private Map sequencesByTable = Collections.EMPTY_MAP;
    private int maxLoopsPerTable = 0;
    private int loopCount = 0;

    public boolean isAcyclic() {
        return this.acyclic;
    }

    public void setAcyclic(boolean acyclic) {
        this.acyclic = acyclic;
    }

    public void generate() {
        this.schemaGraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        this.generateAcyclicSchema();
    }

    /*
     * WARNING - void declaration
     */
    private void generateAcyclicSchema() {
        MapDigraph graph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        HashMap<Integer, Table> vertexToTable = new HashMap<Integer, Table>();
        GraphUtils.randomizeAcyclic(graph, this.tableCount, this.maxForeignKeysPerTable, this.maxReferencesPerTable, this.randomizer);
        this.tables = new ArrayList(this.tableCount);
        this.sequencesByTable = new HashMap(this.tableCount);
        IndegreeTopologicalSort sorter = new IndegreeTopologicalSort(graph);
        ArrayList<Object> sortedVertices = new ArrayList<Object>(graph.order());
        while (((Algorithm)sorter).hasNext()) {
            sortedVertices.add(((Algorithm)sorter).next());
        }
        if (this.loopCount > 0 && this.maxLoopsPerTable > 0) {
            void var6_7;
            Roulette loopSelector = new Roulette(sortedVertices.size(), 1, this.randomizer);
            int n = Math.min(this.loopCount, sortedVertices.size());
            while (var6_7 > 0) {
                Number vertexIndex = (Number)loopSelector.next();
                Object vertex = sortedVertices.get(vertexIndex.intValue());
                graph.putArc(vertex, vertex, Boolean.TRUE);
                --var6_7;
            }
        }
        for (Integer n : sortedVertices) {
            Table table = this.generateTable(n, graph);
            vertexToTable.put(n, table);
            this.schemaGraph.addVertex(table);
        }
        ArcIterator i = graph.arcIterator();
        while (i.hasNext()) {
            i.next();
            Object v = vertexToTable.get(i.getOrigin());
            Object dst = vertexToTable.get(i.getDestination());
            this.schemaGraph.putArc(v, dst, Boolean.TRUE);
        }
    }

    private Table generateTable(Integer vertex, Digraph graph) {
        Table table = new Table(this.catalog, this.schemaName, "TABLE" + vertex);
        int outSize = graph.outgoingSize(vertex);
        int inSize = graph.incomingSize(vertex);
        if (outSize != 0 || outSize == 0 && inSize == 0) {
            Column pkColumn = new Column();
            pkColumn.setName(table.getName() + "_ID");
            pkColumn.setTypeName("INTEGER");
            pkColumn.setNullable(0);
            table.addColumn(pkColumn);
            PrimaryKey pk = new PrimaryKey(pkColumn);
            table.addPrimaryKey(pk);
            this.sequencesByTable.put(table, new Sequence(table.getName() + "_SEQ"));
        }
        ArcIterator i = graph.incomingIterator(vertex);
        while (i.hasNext()) {
            i.next();
            Integer origin = (Integer)i.getOrigin();
            String referencedTableName = "TABLE" + origin;
            String pkColumnName = referencedTableName + "_ID";
            String pkName = referencedTableName + "_PK";
            int fkCount = !vertex.equals(origin) ? 1 : this.generateFkCountForLoop();
            for (int j = 1; j <= fkCount; ++j) {
                String fkColumnSuffix = String.valueOf(j);
                Column fkColumn = new Column();
                fkColumn.setName(pkColumnName + fkColumnSuffix);
                fkColumn.setTypeName("INTEGER");
                fkColumn.setNullable(0);
                table.addColumn(fkColumn);
                if (outSize == 0) {
                    PrimaryKey pk = new PrimaryKey(fkColumn);
                    table.addPrimaryKey(pk);
                }
                ForeignKey fk = new ForeignKey(fkColumn);
                fk.setPkColumnName(pkColumnName);
                fk.setPkName(pkName);
                fk.setPkTableCatalog(this.catalog);
                fk.setPkTableName(referencedTableName);
                fk.setPkTableSchema(this.schemaName);
                table.addForeignKey(fk);
            }
        }
        this.tables.add(table);
        return table;
    }

    private int generateFkCountForLoop() {
        int count = this.randomizer.nextInt(this.maxLoopsPerTable) + 1;
        return count;
    }

    public Digraph getSchemaGraph() {
        return this.schemaGraph;
    }

    public void setTableCount(int tableCount) {
        this.tableCount = tableCount;
    }

    public int getTableCount() {
        return this.tableCount;
    }

    public void setMaxReferencesPerTable(int maxReferencesPerTable) {
        this.maxReferencesPerTable = maxReferencesPerTable;
    }

    public int getMaxReferencesPerTable() {
        return this.maxReferencesPerTable;
    }

    public void setMaxForeignKeysPerTable(int maxForeignKeysPerTable) {
        this.maxForeignKeysPerTable = maxForeignKeysPerTable;
    }

    public int getMaxForeignKeysPerTable() {
        return this.maxForeignKeysPerTable;
    }

    public void setRandomizer(Random randomizer) {
        this.randomizer = randomizer;
    }

    public Random getRandomizer() {
        return this.randomizer;
    }

    public List getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public Map getSequencesByTable() {
        return Collections.unmodifiableMap(this.sequencesByTable);
    }

    public void setMaxLoopsPerTable(int maxLoopsPerTable) {
        this.maxLoopsPerTable = maxLoopsPerTable;
    }

    public int getMaxLoopsPerTable() {
        return this.maxLoopsPerTable;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public int getLoopCount() {
        return this.loopCount;
    }
}

