/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.pref.DomainPreference;
import org.apache.cayenne.pref.PreferenceDetail;
import org.apache.cayenne.pref.PreferenceException;
import org.apache.cayenne.pref._Domain;
import org.apache.cayenne.query.NamedQuery;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.Util;

public class Domain
extends _Domain {
    public void rename(String newName) {
        if (Util.nullSafeEquals(this.getName(), newName)) {
            return;
        }
        Domain parent = this.getParentDomain();
        if (parent == null) {
            this.setName(newName);
            return;
        }
        Domain other = parent.getSubdomain(newName, false);
        if (other != null && other != this) {
            String otherName = null;
            for (int i = 1; i < 1000; ++i) {
                if (parent.getSubdomain(newName + i, false) != null) continue;
                otherName = newName + i;
                break;
            }
            if (otherName == null) {
                throw new PreferenceException("Can't rename an existing domain '" + newName + "'.");
            }
            other.setName(otherName);
        }
        this.setName(newName);
    }

    public Domain getSubdomain(Class javaClass) {
        return this.getSubdomain(javaClass.getName());
    }

    public Domain getSubdomain(String subdomainName) {
        return this.getSubdomain(subdomainName, true);
    }

    public Domain getSubdomain(String subdomainName, boolean create) {
        List matching;
        List subdomains = this.getSubdomains();
        if (subdomains.size() > 0 && (matching = ExpressionFactory.matchExp("name", subdomainName).filterObjects(subdomains)).size() > 0) {
            return (Domain)matching.get(0);
        }
        if (!create) {
            return null;
        }
        Domain childSubdomain = this.getObjectContext().newObject(Domain.class);
        this.addToSubdomains(childSubdomain);
        childSubdomain.setName(subdomainName);
        if (this.getLevel() == null) {
            throw new CayenneRuntimeException("Null level, can't create child");
        }
        int level = this.getLevel() + 1;
        childSubdomain.setLevel(new Integer(level));
        this.getObjectContext().commitChanges();
        return childSubdomain;
    }

    public List getDetails() {
        List domainPrefs = this.getPreferences();
        if (domainPrefs.isEmpty()) {
            return new ArrayList(1);
        }
        ArrayList<PreferenceDetail> details = new ArrayList<PreferenceDetail>(domainPrefs.size());
        for (DomainPreference preference : domainPrefs) {
            details.add(preference.getPreference());
        }
        return details;
    }

    public PreferenceDetail getDetail(String key, boolean create) {
        return this.getDetail(key, null, create);
    }

    public Collection getDetails(Class javaClass) {
        List preferences = this.getPreferences();
        if (preferences.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> ids = new ArrayList<Object>(preferences.size());
        for (DomainPreference pref : preferences) {
            ids.add(DataObjectUtils.pkForObject(pref));
        }
        ObjectContext context = this.getObjectContext();
        DbEntity entity = context.getEntityResolver().lookupDbEntity(javaClass);
        DbAttribute pk = entity.getPrimaryKeys().iterator().next();
        Expression qualifier = Expression.fromString("db:" + pk.getName() + " in $ids");
        Map params = Collections.singletonMap("ids", ids);
        SelectQuery query = new SelectQuery(javaClass, qualifier.expWithParameters(params));
        return context.performQuery(query);
    }

    public Map getDetailsMap(Class javaClass) {
        Collection details = this.getDetails(javaClass);
        HashMap<String, PreferenceDetail> map = new HashMap<String, PreferenceDetail>();
        if (details.isEmpty()) {
            return map;
        }
        for (PreferenceDetail detail : details) {
            map.put(detail.getKey(), detail);
        }
        return map;
    }

    public PreferenceDetail getDetail(String key, Class javaClass, boolean create) {
        DomainPreference preferenceLink = this.getDomainPreference(key);
        if (preferenceLink == null) {
            if (!create) {
                return null;
            }
            preferenceLink = this.getObjectContext().newObject(DomainPreference.class);
            preferenceLink.setDomain(this);
            preferenceLink.setKey(key);
            this.getObjectContext().commitChanges();
        }
        return javaClass == null ? preferenceLink.getPreference() : preferenceLink.getPreference(javaClass, create);
    }

    DomainPreference getDomainPreference(String key) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", key);
        params.put("domain", this);
        List results = this.getObjectContext().performQuery(new NamedQuery("DomainPreferenceForKey", params));
        return results.size() < 1 ? null : (DomainPreference)results.get(0);
    }
}

