/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.Arrays;
import java.util.Vector;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.pref.Domain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingStrategyPreferences {
    private static final String STRATEGIES_PREFERENCE = "recent.strategies";
    private static final Vector<String> PREDEFINED_STRATEGIES = new Vector();
    static final NamingStrategyPreferences instance;

    public static NamingStrategyPreferences getInstance() {
        return instance;
    }

    Domain getDomain() {
        return Application.getInstance().getPreferenceDomain().getSubdomain(this.getClass());
    }

    public Vector<String> getLastUsedStrategies() {
        String prop = this.getDomain().getDetail(STRATEGIES_PREFERENCE, true).getProperty(STRATEGIES_PREFERENCE);
        if (prop == null) {
            return PREDEFINED_STRATEGIES;
        }
        return new Vector<String>(Arrays.asList(prop.split(",")));
    }

    public void addToLastUsedStrategies(String strategy) {
        Vector<String> strategies = this.getLastUsedStrategies();
        strategies.remove(strategy);
        strategies.add(0, strategy);
        StringBuilder res = new StringBuilder();
        for (String str : strategies) {
            res.append(str).append(",");
        }
        if (strategies.size() > 0) {
            res.deleteCharAt(res.length() - 1);
        }
        this.getDomain().getDetail(STRATEGIES_PREFERENCE, true).setProperty(STRATEGIES_PREFERENCE, res.toString());
    }

    static {
        PREDEFINED_STRATEGIES.add("org.apache.cayenne.map.naming.BasicNamingStrategy");
        PREDEFINED_STRATEGIES.add("org.apache.cayenne.map.naming.SmartNamingStrategy");
        instance = new NamingStrategyPreferences();
    }
}

