/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateNodeUndoableEdit
extends CayenneUndoableEdit {
    private DataNode node;
    private DataDomain domain;

    public String getPresentationName() {
        return "Create DataNode";
    }

    public CreateNodeUndoableEdit(Application application, DataDomain domain, DataNode node) {
        this.domain = domain;
        this.node = node;
    }

    public void undo() throws CannotUndoException {
        RemoveAction action = (RemoveAction)this.actionManager.getAction(RemoveAction.getActionName());
        action.removeDataNode(this.domain, this.node);
    }

    public void redo() throws CannotRedoException {
        this.domain.addNode(this.node);
        CreateNodeAction action = (CreateNodeAction)this.actionManager.getAction(CreateNodeAction.getActionName());
        action.createDataNode(this.domain, this.node);
    }
}

