/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.BaseProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;

public class SimpleAttributeProperty
extends BaseProperty
implements AttributeProperty {
    private ObjAttribute attribute;

    public SimpleAttributeProperty(ClassDescriptor owner, Accessor accessor, ObjAttribute attribute) {
        super(owner, accessor);
        this.attribute = attribute;
    }

    public boolean visit(PropertyVisitor visitor) {
        return visitor.visitAttribute(this);
    }

    public ObjAttribute getAttribute() {
        return this.attribute;
    }

    public Object readProperty(Object object) throws PropertyException {
        this.resolveFault(object);
        return super.readProperty(object);
    }

    public void writeProperty(Object object, Object oldValue, Object newValue) throws PropertyException {
        this.resolveFault(object);
        super.writeProperty(object, oldValue, newValue);
    }

    protected void resolveFault(Object object) throws PropertyException {
        try {
            Persistent persistent = (Persistent)object;
            ObjectContext context = persistent.getObjectContext();
            if (context != null) {
                context.prepareForAccess(persistent, this.getName(), false);
            }
        }
        catch (ClassCastException e) {
            throw new PropertyException("Object is not a Persistent: '" + object.getClass().getName() + "'", this, object, (Throwable)e);
        }
    }
}

