/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.AbstractCallback;
import org.apache.cayenne.reflect.CallbackOnEntity;
import org.apache.cayenne.reflect.CallbackOnListener;

class LifecycleCallbackEventHandler {
    private EntityResolver resolver;
    private Map<String, Collection<AbstractCallback>> listeners;
    private Collection<AbstractCallback> defaultListeners;

    LifecycleCallbackEventHandler(EntityResolver resolver) {
        this.resolver = resolver;
        this.listeners = new HashMap<String, Collection<AbstractCallback>>();
        this.defaultListeners = new ArrayList<AbstractCallback>();
    }

    private boolean excludingDefaultListeners(String entityName) {
        ObjEntity entity = this.resolver.getObjEntity(entityName);
        return entity != null && entity.isExcludingDefaultListeners();
    }

    private boolean excludingSuperclassListeners(String entityName) {
        ObjEntity entity = this.resolver.getObjEntity(entityName);
        return entity != null && entity.isExcludingSuperclassListeners();
    }

    boolean isEmpty() {
        return this.listeners.isEmpty() && this.defaultListeners.isEmpty();
    }

    void clear() {
        this.listeners.clear();
        this.defaultListeners.clear();
    }

    void addDefaultListener(Object listener, String methodName) {
        CallbackOnListener callback = new CallbackOnListener(listener, methodName);
        this.addDefaultCallback(callback);
    }

    private void addDefaultCallback(AbstractCallback callback) {
        this.defaultListeners.add(callback);
    }

    void addListener(Class entityClass, String methodName) {
        this.addCallback(entityClass, new CallbackOnEntity(entityClass, methodName));
    }

    void addListener(Class entityClass, Object listener, String methodName) {
        CallbackOnListener callback = new CallbackOnListener(listener, methodName, entityClass);
        this.addCallback(entityClass, callback);
    }

    private void addCallback(Class entityClass, AbstractCallback callback) {
        Collection<AbstractCallback> entityListeners = this.listeners.get(entityClass.getName());
        if (entityListeners == null) {
            entityListeners = new ArrayList<AbstractCallback>(3);
            this.listeners.put(entityClass.getName(), entityListeners);
        }
        entityListeners.add(callback);
    }

    void performCallbacks(Persistent object) {
        if (!this.defaultListeners.isEmpty() && !this.excludingDefaultListeners(object.getObjectId().getEntityName())) {
            for (AbstractCallback listener : this.defaultListeners) {
                listener.performCallback(object);
            }
        }
        this.performCallbacks(object, object.getClass());
    }

    void performCallbacks(Collection objects) {
        for (Object object : objects) {
            if (!(object instanceof Persistent)) break;
            this.performCallbacks((Persistent)object);
        }
    }

    private void performCallbacks(Persistent object, Class callbackEntityClass) {
        String key;
        Collection<AbstractCallback> entityListeners;
        if (callbackEntityClass == null || Object.class.equals((Object)callbackEntityClass)) {
            return;
        }
        if (!this.excludingSuperclassListeners(object.getObjectId().getEntityName())) {
            this.performCallbacks(object, callbackEntityClass.getSuperclass());
        }
        if ((entityListeners = this.listeners.get(key = callbackEntityClass.getName())) != null) {
            for (AbstractCallback listener : entityListeners) {
                listener.performCallback(object);
            }
        }
    }
}

