/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.EmbeddableObject;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.BaseColumnExtractor;
import org.apache.cayenne.access.translator.select.ColumnExtractor;
import org.apache.cayenne.access.translator.select.DescriptorColumnExtractor;
import org.apache.cayenne.access.translator.select.IdColumnExtractor;
import org.apache.cayenne.access.translator.select.PathTranslationResult;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.EmbeddedResult;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;

class CustomColumnSetExtractor
implements ColumnExtractor {
    private final TranslatorContext context;
    private final Collection<Property<?>> columns;

    CustomColumnSetExtractor(TranslatorContext context, Collection<Property<?>> columns) {
        this.context = context;
        this.columns = columns;
    }

    @Override
    public void extract(CayennePath prefix) {
        for (Property<?> property : this.columns) {
            if (this.isFullObjectProp(property)) {
                this.extractFullObject(prefix, property);
                continue;
            }
            if (this.isEmbeddedProp(property)) {
                this.extractEmbeddedObject(property);
                continue;
            }
            this.extractSimpleProperty(property);
        }
    }

    private void extractSimpleProperty(Property<?> property) {
        Node sqlNode = this.context.getQualifierTranslator().translate(property);
        String alias = property.getAlias();
        this.context.addResultNode(sqlNode, true, property, alias == null ? null : CayennePath.of(alias));
        String name = property.getName() == null ? property.getExpression().expName() : property.getName();
        this.context.getSqlResult().addColumnResult(name);
    }

    private boolean isFullObjectProp(Property<?> property) {
        int expressionType = property.getExpression().getType();
        if (property.getType() != null && (expressionType == 26 || expressionType == 27) && (Collection.class.isAssignableFrom(property.getType()) || Map.class.isAssignableFrom(property.getType()))) {
            throw new CayenneRuntimeException("Can't directly select toMany relationship columns. Either select it with aggregate functions like count() or with flat() function to select full related objects.", new Object[0]);
        }
        return expressionType == 47 || property.getType() != null && expressionType == 26 && Persistent.class.isAssignableFrom(property.getType());
    }

    private boolean isEmbeddedProp(Property<?> property) {
        return EmbeddableObject.class.isAssignableFrom(property.getType());
    }

    private void extractEmbeddedObject(Property<?> property) {
        Object o = property.getExpression().evaluate(this.context.getMetadata().getObjEntity());
        if (!(o instanceof EmbeddedAttribute)) {
            throw new CayenneRuntimeException("EmbeddedAttribute expected, %s found", o);
        }
        EmbeddedAttribute attribute = (EmbeddedAttribute)o;
        EmbeddedResult result = new EmbeddedResult(attribute.getEmbeddable(), attribute.getAttributes().size());
        attribute.getAttributes().forEach(attr -> {
            Node sqlNode = this.context.getQualifierTranslator().translate(ExpressionFactory.dbPathExp(attr.getDbAttributePath()));
            this.context.addResultNode(sqlNode, true, null, null);
            result.addAttribute((ObjAttribute)attr);
        });
        this.context.getSqlResult().addEmbeddedResult(result);
    }

    private void extractFullObject(CayennePath prefix, Property<?> property) {
        BaseColumnExtractor extractor;
        prefix = this.calculatePrefix(prefix, property);
        this.ensureJoin(prefix);
        ObjEntity entity = this.context.getResolver().getObjEntity(property.getType());
        if (this.context.getMetadata().getPageSize() > 0) {
            extractor = new IdColumnExtractor(this.context, entity);
        } else {
            ClassDescriptor descriptor = this.context.getResolver().getClassDescriptor(entity.getName());
            extractor = new DescriptorColumnExtractor(this.context, descriptor);
        }
        int index = this.context.getResultNodeList().size();
        extractor.extract(prefix);
        for (int i = index; i < this.context.getResultNodeList().size(); ++i) {
            this.context.getResultNodeList().get(i).setDataRowKey(null);
        }
    }

    private CayennePath calculatePrefix(CayennePath prefix, Property<?> property) {
        Object op;
        Expression exp = property.getExpression();
        int expressionType = exp.getType();
        if (expressionType == 47 && exp.getOperandCount() > 0 && (op = exp.getOperand(0)) instanceof Expression) {
            exp = (Expression)op;
        }
        return this.dbPathOrDefault(exp, prefix);
    }

    private CayennePath dbPathOrDefault(Expression pathExp, CayennePath defaultPrefix) {
        if (pathExp.getType() == 26) {
            pathExp = this.context.getMetadata().getObjEntity().translateToDbPath(pathExp);
        }
        if (pathExp.getType() != 27) {
            return defaultPrefix;
        }
        return ((ASTDbPath)pathExp).getPath();
    }

    private void ensureJoin(CayennePath prefix) {
        if (!prefix.isEmpty()) {
            PathTranslationResult result = this.context.getPathTranslator().translatePath(this.context.getMetadata().getDbEntity(), prefix);
            result.getDbRelationship().ifPresent(relationship -> this.context.getTableTree().addJoinTable(result.getFinalPath(), (DbRelationship)relationship, JoinType.LEFT_OUTER));
        }
    }
}

