package org.apache.cayenne.testdo.lob.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.testdo.lob.ClobTestEntity;
import org.apache.cayenne.testdo.lob.ClobTestRelation;

/**
 * Class _ClobTestRelation was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _ClobTestRelation extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<ClobTestRelation> SELF = PropertyFactory.createSelf(ClobTestRelation.class);

    public static final String ID_PK_COLUMN = "ID";

    public static final NumericProperty<Integer> ID = PropertyFactory.createNumeric("id", Integer.class);
    public static final NumericProperty<Integer> VALUE = PropertyFactory.createNumeric("value", Integer.class);
    public static final EntityProperty<ClobTestEntity> CLOB_ID = PropertyFactory.createEntity("clobId", ClobTestEntity.class);

    protected Integer id;
    protected Integer value;

    protected Object clobId;

    public void setId(Integer id) {
        beforePropertyWrite("id", this.id, id);
        this.id = id;
    }

    public Integer getId() {
        beforePropertyRead("id");
        return this.id;
    }

    public void setValue(Integer value) {
        beforePropertyWrite("value", this.value, value);
        this.value = value;
    }

    public Integer getValue() {
        beforePropertyRead("value");
        return this.value;
    }

    public void setClobId(ClobTestEntity clobId) {
        setToOneTarget("clobId", clobId, true);
    }

    public ClobTestEntity getClobId() {
        return (ClobTestEntity)readProperty("clobId");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "id":
                return this.id;
            case "value":
                return this.value;
            case "clobId":
                return this.clobId;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "id":
                this.id = (Integer)val;
                break;
            case "value":
                this.value = (Integer)val;
                break;
            case "clobId":
                this.clobId = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.id);
        out.writeObject(this.value);
        out.writeObject(this.clobId);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.id = (Integer)in.readObject();
        this.value = (Integer)in.readObject();
        this.clobId = in.readObject();
    }

}
