/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.commitlog;

import java.util.List;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.commitlog.Confidential;
import org.apache.cayenne.commitlog.meta.CommitLogEntity;
import org.apache.cayenne.commitlog.meta.CommitLogEntityFactory;
import org.apache.cayenne.commitlog.model.MutableChangeMap;
import org.apache.cayenne.commitlog.model.MutableObjectChange;
import org.apache.cayenne.commitlog.model.ObjectChangeType;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeletedDiffProcessor
implements GraphChangeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletedDiffProcessor.class);
    private CommitLogEntityFactory entityFactory;
    private MutableChangeMap changeSet;
    private DataChannel channel;

    DeletedDiffProcessor(MutableChangeMap changeSet, DataChannel channel, CommitLogEntityFactory entityFactory) {
        this.changeSet = changeSet;
        this.channel = channel;
        this.entityFactory = entityFactory;
    }

    public void nodeRemoved(Object nodeId) {
        ObjectId id = (ObjectId)nodeId;
        final MutableObjectChange objectChangeSet = this.changeSet.getOrCreate(id, ObjectChangeType.DELETE);
        ObjectIdQuery query = new ObjectIdQuery(id, true, 1);
        QueryResponse result = this.channel.onQuery(null, (Query)query);
        List rows = result.firstList();
        if (rows.isEmpty()) {
            LOGGER.warn("No DB snapshot for object to be deleted, no changes will be recorded. ID: " + id);
            return;
        }
        final DataRow row = (DataRow)rows.get(0);
        ClassDescriptor descriptor = this.channel.getEntityResolver().getClassDescriptor(id.getEntityName());
        final CommitLogEntity entity = this.entityFactory.getEntity(id);
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                Object value;
                if (!entity.isIncluded(property.getName())) {
                    return true;
                }
                if (entity.isConfidential(property.getName())) {
                    value = Confidential.getInstance();
                } else {
                    String key = property.getAttribute().getDbAttributeName();
                    value = row.get((Object)key);
                }
                if (value != null) {
                    objectChangeSet.attributeChanged(property.getName(), value, null);
                }
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                if (!entity.isIncluded(property.getName())) {
                    return true;
                }
                DbRelationship dbRelationship = (DbRelationship)property.getRelationship().getDbRelationships().get(0);
                ObjectId value = row.createTargetObjectId(property.getTargetDescriptor().getEntity().getName(), dbRelationship);
                if (value != null) {
                    objectChangeSet.toOneRelationshipDisconnected(property.getName(), value);
                }
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                return true;
            }
        });
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
    }

    public void nodeCreated(Object nodeId) {
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
    }
}

