/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen.domain;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferences;
import org.apache.cayenne.modeler.editor.GeneratorsTabController;
import org.apache.cayenne.modeler.editor.cgen.domain.CgenTab;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.util.ModelerUtil;

public class CgenTabController
extends GeneratorsTabController<CgenConfiguration> {
    public CgenTabController(ProjectController projectController) {
        super(projectController, CgenConfiguration.class, true);
        this.view = new CgenTab(projectController, this);
    }

    @Override
    public void runGenerators(Set<DataMap> dataMaps) {
        DataChannelMetaData metaData = Application.getInstance().getMetaData();
        if (dataMaps.isEmpty()) {
            this.view.showEmptyMessage();
            return;
        }
        boolean generationFail = false;
        for (DataMap dataMap : dataMaps) {
            try {
                CgenConfiguration cgenConfiguration = metaData.get(dataMap, CgenConfiguration.class);
                if (cgenConfiguration == null) {
                    cgenConfiguration = this.createConfiguration(dataMap);
                }
                ClassGenerationAction classGenerationAction = cgenConfiguration.isClient() ? new ClientClassGenerationAction() : new ClassGenerationAction();
                classGenerationAction.setCgenConfiguration(cgenConfiguration);
                classGenerationAction.prepareArtifacts();
                classGenerationAction.execute();
            }
            catch (Exception e) {
                LOGGER.error("Error generating classes", e);
                generationFail = true;
                ((CgenTab)this.view).showErrorMessage(e.getMessage());
            }
        }
        if (!generationFail) {
            ((CgenTab)this.view).showSuccessMessage();
        }
    }

    public CgenConfiguration createConfiguration(DataMap dataMap) {
        CgenConfiguration cgenConfiguration = new CgenConfiguration(false);
        cgenConfiguration.setDataMap(dataMap);
        Path basePath = Paths.get(ModelerUtil.initOutputFolder(), new String[0]);
        if (!Files.exists(basePath, new LinkOption[0])) {
            try {
                Files.createDirectories(basePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.getView(), "Can't create directory. Select a different one.");
                return null;
            }
        }
        if (!Files.isDirectory(basePath, new LinkOption[0])) {
            JOptionPane.showMessageDialog(this.getView(), basePath + " is not a valid directory.");
            return null;
        }
        cgenConfiguration.setRootPath(basePath);
        Preferences preferences = Application.getInstance().getPreferencesNode(GeneralPreferences.class, "");
        if (preferences != null) {
            cgenConfiguration.setEncoding(preferences.get("encoding", null));
        }
        cgenConfiguration.resolveExcludeEntities();
        cgenConfiguration.resolveExcludeEmbeddables();
        return cgenConfiguration;
    }

    @Override
    public void showConfig(DataMap dataMap) {
        if (dataMap != null) {
            DataMapDisplayEvent event = new DataMapDisplayEvent((Object)this.getView(), dataMap, dataMap.getDataChannelDescriptor());
            this.getProjectController().fireDataMapDisplayEvent(event);
        }
    }
}

