/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SQLTemplate;

public class SQLTemplateMetadata
extends BaseQueryMetadata {
    private boolean isSingleResultSetMapping;

    @Override
    public boolean isSingleResultSetMapping() {
        return this.isSingleResultSetMapping;
    }

    boolean resolve(Object root, EntityResolver resolver, SQLTemplate query) {
        if (super.resolve(root, resolver)) {
            if (!(query.isUseScalar() || query.isFetchingDataRows() || query.getResultColumnsTypes() == null || query.getResultColumnsTypes().isEmpty())) {
                throw new CayenneRuntimeException("Error caused by using root in query with resultColumnTypes without scalar or dataRow.", new Object[0]);
            }
            if (query.getResult() != null && query.getResultColumnsTypes() != null) {
                throw new CayenneRuntimeException("Caused by trying to override result column types of query.", new Object[0]);
            }
            if (query.isFetchingDataRows() && query.isUseScalar()) {
                throw new CayenneRuntimeException("Can't set both use scalar and fetching data rows.", new Object[0]);
            }
            this.buildResultSetMappingForColumns(query);
            this.resultSetMapping = query.getResult() != null ? query.getResult().getResolvedComponents(resolver) : (query.isUseScalar() ? new ArrayList() : null);
            boolean bl = this.isSingleResultSetMapping = this.resultSetMapping != null && this.resultSetMapping.size() == 1;
            if (QueryCacheStrategy.NO_CACHE != this.getCacheStrategy()) {
                Map<String, ?> parameters;
                StringBuilder key = new StringBuilder();
                ObjEntity entity = this.getObjEntity();
                if (entity != null) {
                    key.append(entity.getName());
                } else if (this.dbEntity != null) {
                    key.append("db:").append(this.dbEntity.getName());
                }
                if (query.getDefaultTemplate() != null) {
                    key.append('/').append(query.getDefaultTemplate());
                }
                if (!(parameters = query.getParams()).isEmpty()) {
                    ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
                    Collections.sort(keys);
                    for (String parameterKey : keys) {
                        key.append('/').append(parameterKey).append('=').append(parameters.get(parameterKey));
                    }
                }
                for (Object parameter : query.getPositionalParams()) {
                    key.append("/p:").append(parameter);
                }
                if (query.getFetchOffset() > 0 || query.getFetchLimit() > 0) {
                    key.append('/');
                    if (query.getFetchOffset() > 0) {
                        key.append('o').append(query.getFetchOffset());
                    }
                    if (query.getFetchLimit() > 0) {
                        key.append('l').append(query.getFetchLimit());
                    }
                }
                this.cacheKey = key.toString();
            }
            return true;
        }
        return false;
    }

    private void buildResultSetMappingForColumns(SQLTemplate query) {
        if (query.getResultColumnsTypes() == null || query.getResultColumnsTypes().isEmpty() || !query.isUseScalar()) {
            return;
        }
        SQLResult result = new SQLResult();
        for (int i = 0; i < query.getResultColumnsTypes().size(); ++i) {
            result.addColumnResult(String.valueOf(i));
        }
        query.setResult(result);
    }
}

