/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ModelerPreferences;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferences;
import org.apache.cayenne.modeler.init.CayenneModelerModule;
import org.apache.cayenne.modeler.init.platform.PlatformInitializer;
import org.apache.cayenne.project.CayenneProjectModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static Log logger = LogFactory.getLog(Main.class);
    protected String[] args;

    public static void main(String[] args) {
        try {
            new Main(args).launch();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected Main(String[] args) {
        this.args = args;
    }

    protected void launch() {
        final Injector injector = DIBootstrap.createInjector(this.appendModules(new ArrayList<Module>()));
        logger.info("Starting CayenneModeler.");
        logger.info("JRE v." + System.getProperty("java.version") + " at " + System.getProperty("java.home"));
        injector.getInstance(PlatformInitializer.class).initLookAndFeel();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Application application = injector.getInstance(Application.class);
                Application.setInstance(application);
                application.startup();
                File project = Main.this.initialProjectFromArgs();
                if (project == null) {
                    project = Main.this.initialProjectFromPreferences();
                }
                if (project != null) {
                    new OpenProjectAction(application).openProject(project);
                }
            }
        });
    }

    protected Collection<Module> appendModules(Collection<Module> modules) {
        modules.add(new ServerModule("CayenneModeler"));
        modules.add(new CayenneProjectModule());
        modules.add(new CayenneModelerModule());
        return modules;
    }

    protected File initialProjectFromPreferences() {
        List<String> lastFiles;
        Preferences autoLoadLastProject = Application.getInstance().getPreferencesNode(GeneralPreferences.class, "");
        if (autoLoadLastProject != null && autoLoadLastProject.getBoolean("autoLoadProject", false) && !(lastFiles = ModelerPreferences.getLastProjFiles()).isEmpty()) {
            return new File(lastFiles.get(0));
        }
        return null;
    }

    protected File initialProjectFromArgs() {
        File f;
        if (this.args != null && this.args.length == 1 && (f = new File(this.args[0])).isFile() && f.getName().startsWith("cayenne") && f.getName().endsWith(".xml")) {
            return f;
        }
        return null;
    }
}

