/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilestatus;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationprofilestatus.Kamelet;
import org.apache.camel.v1.integrationprofilestatus.kamelet.Repositories;
import org.apache.camel.v1.integrationprofilestatus.kamelet.RepositoriesBuilder;
import org.apache.camel.v1.integrationprofilestatus.kamelet.RepositoriesFluent;

public class KameletFluent<A extends KameletFluent<A>>
extends BaseFluent<A> {
    private ArrayList<RepositoriesBuilder> repositories;

    public KameletFluent() {
    }

    public KameletFluent(Kamelet instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Kamelet instance) {
        Kamelet kamelet = instance = instance != null ? instance : new Kamelet();
        if (instance != null) {
            this.withRepositories(instance.getRepositories());
        }
    }

    public A addToRepositories(int index, Repositories item) {
        if (this.repositories == null) {
            this.repositories = new ArrayList();
        }
        RepositoriesBuilder builder = new RepositoriesBuilder(item);
        if (index < 0 || index >= this.repositories.size()) {
            this._visitables.get((Object)"repositories").add(builder);
            this.repositories.add(builder);
        } else {
            this._visitables.get((Object)"repositories").add(index, builder);
            this.repositories.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRepositories(int index, Repositories item) {
        if (this.repositories == null) {
            this.repositories = new ArrayList();
        }
        RepositoriesBuilder builder = new RepositoriesBuilder(item);
        if (index < 0 || index >= this.repositories.size()) {
            this._visitables.get((Object)"repositories").add(builder);
            this.repositories.add(builder);
        } else {
            this._visitables.get((Object)"repositories").set(index, builder);
            this.repositories.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRepositories(Repositories ... items) {
        if (this.repositories == null) {
            this.repositories = new ArrayList();
        }
        for (Repositories item : items) {
            RepositoriesBuilder builder = new RepositoriesBuilder(item);
            this._visitables.get((Object)"repositories").add(builder);
            this.repositories.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToKameletRepositories(Collection<Repositories> items) {
        if (this.repositories == null) {
            this.repositories = new ArrayList();
        }
        for (Repositories item : items) {
            RepositoriesBuilder builder = new RepositoriesBuilder(item);
            this._visitables.get((Object)"repositories").add(builder);
            this.repositories.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRepositories(Repositories ... items) {
        if (this.repositories == null) {
            return (A)((Object)this);
        }
        for (Repositories item : items) {
            RepositoriesBuilder builder = new RepositoriesBuilder(item);
            this._visitables.get((Object)"repositories").remove((Object)builder);
            this.repositories.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromKameletRepositories(Collection<Repositories> items) {
        if (this.repositories == null) {
            return (A)((Object)this);
        }
        for (Repositories item : items) {
            RepositoriesBuilder builder = new RepositoriesBuilder(item);
            this._visitables.get((Object)"repositories").remove((Object)builder);
            this.repositories.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromKameletRepositories(Predicate<RepositoriesBuilder> predicate) {
        if (this.repositories == null) {
            return (A)((Object)this);
        }
        Iterator<RepositoriesBuilder> each = this.repositories.iterator();
        List visitables = this._visitables.get((Object)"repositories");
        while (each.hasNext()) {
            RepositoriesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Repositories> buildRepositories() {
        return this.repositories != null ? KameletFluent.build(this.repositories) : null;
    }

    public Repositories buildRepository(int index) {
        return this.repositories.get(index).build();
    }

    public Repositories buildFirstRepository() {
        return this.repositories.get(0).build();
    }

    public Repositories buildLastRepository() {
        return this.repositories.get(this.repositories.size() - 1).build();
    }

    public Repositories buildMatchingRepository(Predicate<RepositoriesBuilder> predicate) {
        for (RepositoriesBuilder item : this.repositories) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRepository(Predicate<RepositoriesBuilder> predicate) {
        for (RepositoriesBuilder item : this.repositories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRepositories(List<Repositories> repositories) {
        if (this.repositories != null) {
            this._visitables.get((Object)"repositories").clear();
        }
        if (repositories != null) {
            this.repositories = new ArrayList();
            for (Repositories item : repositories) {
                this.addToRepositories(item);
            }
        } else {
            this.repositories = null;
        }
        return (A)((Object)this);
    }

    public A withRepositories(Repositories ... repositories) {
        if (this.repositories != null) {
            this.repositories.clear();
            this._visitables.remove((Object)"repositories");
        }
        if (repositories != null) {
            for (Repositories item : repositories) {
                this.addToRepositories(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRepositories() {
        return this.repositories != null && !this.repositories.isEmpty();
    }

    public RepositoriesNested<A> addNewRepository() {
        return new RepositoriesNested(-1, null);
    }

    public RepositoriesNested<A> addNewRepositoryLike(Repositories item) {
        return new RepositoriesNested(-1, item);
    }

    public RepositoriesNested<A> setNewRepositoryLike(int index, Repositories item) {
        return new RepositoriesNested(index, item);
    }

    public RepositoriesNested<A> editRepository(int index) {
        if (this.repositories.size() <= index) {
            throw new RuntimeException("Can't edit repositories. Index exceeds size.");
        }
        return this.setNewRepositoryLike(index, this.buildRepository(index));
    }

    public RepositoriesNested<A> editFirstRepository() {
        if (this.repositories.size() == 0) {
            throw new RuntimeException("Can't edit first repositories. The list is empty.");
        }
        return this.setNewRepositoryLike(0, this.buildRepository(0));
    }

    public RepositoriesNested<A> editLastRepository() {
        int index = this.repositories.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last repositories. The list is empty.");
        }
        return this.setNewRepositoryLike(index, this.buildRepository(index));
    }

    public RepositoriesNested<A> editMatchingRepository(Predicate<RepositoriesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.repositories.size(); ++i) {
            if (!predicate.test(this.repositories.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching repositories. No match found.");
        }
        return this.setNewRepositoryLike(index, this.buildRepository(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KameletFluent that = (KameletFluent)((Object)o);
        return Objects.equals(this.repositories, that.repositories);
    }

    public int hashCode() {
        return Objects.hash(this.repositories, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.repositories != null && !this.repositories.isEmpty()) {
            sb.append("repositories:");
            sb.append(this.repositories);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RepositoriesNested<N>
    extends RepositoriesFluent<RepositoriesNested<N>>
    implements Nested<N> {
        RepositoriesBuilder builder;
        int index;

        RepositoriesNested(int index, Repositories item) {
            this.index = index;
            this.builder = new RepositoriesBuilder(this, item);
        }

        public N and() {
            return (N)KameletFluent.this.setToRepositories(this.index, this.builder.build());
        }

        public N endKameletRepository() {
            return this.and();
        }
    }
}

