/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.options;

import com.google.common.base.Preconditions;
import org.jclouds.gogrid.domain.LoadBalancerPersistenceType;
import org.jclouds.gogrid.domain.LoadBalancerType;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class AddLoadBalancerOptions
extends BaseHttpRequestOptions {
    public AddLoadBalancerOptions setDescription(String description) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"description") ? 1 : 0) != 0, (Object)"Can't have duplicate load balancer description");
        this.queryParameters.put((Object)"description", (Object)description);
        return this;
    }

    public AddLoadBalancerOptions setType(LoadBalancerType loadBalancerType) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"loadbalancer.type") ? 1 : 0) != 0, (Object)"Can't have duplicate load balancer type limitation");
        this.queryParameters.put((Object)"loadbalancer.type", (Object)loadBalancerType.toString());
        return this;
    }

    public AddLoadBalancerOptions setPersistenceType(LoadBalancerPersistenceType loadBalancerPersistenceType) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"loadbalancer.persistence") ? 1 : 0) != 0, (Object)"Can't have duplicate load balancer type limitation");
        this.queryParameters.put((Object)"loadbalancer.persistence", (Object)loadBalancerPersistenceType.toString());
        return this;
    }

    public static class Builder {
        public AddLoadBalancerOptions create(LoadBalancerType type, LoadBalancerPersistenceType persistenceType) {
            return new AddLoadBalancerOptions().setType(type).setPersistenceType(persistenceType);
        }
    }
}

