/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.nova.v2_0.binders.BindMetadataToJsonPayload;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.functions.internal.OnlyMetadataValueOrNull;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseImageDetails;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseImages;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/images")
public interface ImageApi {
    @Named(value="image:list")
    @GET
    @ResponseParser(value=ParseImages.class)
    @Transform(value=ParseImages.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Resource> list();

    @Named(value="image:list")
    @GET
    @ResponseParser(value=ParseImages.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PaginatedCollection<Resource> list(PaginationOptions var1);

    @Named(value="image:list")
    @GET
    @Path(value="/detail")
    @ResponseParser(value=ParseImageDetails.class)
    @Transform(value=ParseImageDetails.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Image> listInDetail();

    @Named(value="image:list")
    @GET
    @Path(value="/detail")
    @ResponseParser(value=ParseImageDetails.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PaginatedCollection<Image> listInDetail(PaginationOptions var1);

    @Named(value="image:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"image"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Image get(@PathParam(value="id") String var1);

    @Named(value="image:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PathParam(value="id") String var1);

    @Named(value="image:getMetadata")
    @GET
    @Path(value="/{id}/metadata")
    @SelectJson(value={"metadata"})
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    public Map<String, String> getMetadata(@PathParam(value="id") String var1);

    @Named(value="image:setMetadata")
    @PUT
    @Path(value="/{id}/metadata")
    @SelectJson(value={"metadata"})
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public Map<String, String> setMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);

    @Named(value="image:updateMetadata")
    @POST
    @Path(value="/{id}/metadata")
    @SelectJson(value={"metadata"})
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public Map<String, String> updateMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);

    @Named(value="image:getMetadata")
    @GET
    @Path(value="/{id}/metadata/{key}")
    @ResponseParser(value=OnlyMetadataValueOrNull.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public String getMetadata(@PathParam(value="id") String var1, @PathParam(value="key") String var2);

    @Named(value="image:updateMetadata")
    @PUT
    @Path(value="/{id}/metadata/{key}")
    @ResponseParser(value=OnlyMetadataValueOrNull.class)
    @MapBinder(value=BindMetadataToJsonPayload.class)
    @Nullable
    public String updateMetadata(@PathParam(value="id") String var1, @PathParam(value="key") @PayloadParam(value="key") String var2, @PathParam(value="value") @PayloadParam(value="value") String var3);

    @Named(value="image:deleteMetadata")
    @DELETE
    @Path(value="/{id}/metadata/{key}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteMetadata(@PathParam(value="id") String var1, @PathParam(value="key") String var2);
}

