/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor.windows;

import com.google.common.annotations.Beta;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.feed.windows.WindowsPerformanceCounterFeed;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class WindowsPerformanceCounterSensors
extends EntityInitializers.InitializerPatternWithFieldsFromConfigKeys {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsPerformanceCounterSensors.class);
    public static final ConfigKey<Set<Map<String, String>>> PERFORMANCE_COUNTERS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Set<Map<String, String>>>(){}, (String)"performance.counters");
    public static final ConfigKey<Duration> PERIOD = ConfigKeys.newConfigKey(Duration.class, (String)"period", (String)"poll period", (Object)Duration.seconds((Number)30));
    protected Set<Map<String, String>> sensors;
    protected Duration period;

    private WindowsPerformanceCounterSensors() {
        this.addInitConfigMapping(PERFORMANCE_COUNTERS, v -> {
            this.sensors = v;
            return this.sensors;
        });
        this.addInitConfigMapping(PERIOD, v -> {
            this.period = v;
            return this.period;
        });
    }

    public WindowsPerformanceCounterSensors(ConfigBag params) {
        super(params);
        this.addInitConfigMapping(PERFORMANCE_COUNTERS, v -> {
            this.sensors = v;
            return this.sensors;
        });
        this.addInitConfigMapping(PERIOD, v -> {
            this.period = v;
            return this.period;
        });
    }

    public WindowsPerformanceCounterSensors(Map<String, String> params) {
        this(ConfigBag.newInstance(params));
    }

    public void apply(EntityLocal entity) {
        WindowsPerformanceCounterFeed.Builder builder = WindowsPerformanceCounterFeed.builder().period(this.period).entity((Entity)entity);
        for (Map<String, String> sensorConfig : this.sensors) {
            Class<String> clazz;
            String name = sensorConfig.get("name");
            String sensorType = sensorConfig.get("sensorType");
            try {
                clazz = Strings.isNonEmpty((CharSequence)sensorType) ? ((EntityInternal)entity).getManagementContext().getCatalog().getRootClassLoader().loadClass(sensorType) : String.class;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not load type " + sensorType + " for sensor " + name, e);
            }
            builder.addSensor(sensorConfig.get("counter"), Sensors.newSensor(clazz, (String)name, (String)sensorConfig.get("description")));
        }
        entity.addFeed((Feed)builder.build());
    }
}

