/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.workflow.DanglingWorkflowException;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowReplayUtils;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepResolution;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowErrorHandling
implements Callable<WorkflowErrorHandlingResult> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowErrorHandling.class);
    final List<WorkflowStepDefinition> errorOptions;
    final WorkflowExecutionContext context;
    final Integer stepIndexIfStepErrorHandler;
    final Task<?> failedTask;
    final Throwable error;

    public static Task<WorkflowErrorHandlingResult> createStepErrorHandlerTask(WorkflowStepDefinition step, WorkflowStepInstanceExecutionContext context, Task<?> stepTask, Throwable error, Integer errorStepIfNested) {
        log.debug("Encountered error in step " + context.getWorkflowStepReference() + " '" + stepTask.getDisplayName() + "' (handler present): " + Exceptions.collapseText((Throwable)error));
        String taskName = context.getWorkflowStepReference();
        if (errorStepIfNested != null) {
            taskName = context.getWorkflowStepReference() + "-" + (errorStepIfNested + 1);
        } else if (!taskName.contains("error-handler")) {
            taskName = taskName + "-error-handler";
        }
        Task<WorkflowErrorHandlingResult> task = Tasks.builder().dynamic(true).displayName(taskName).tag(BrooklynTaskTags.tagForWorkflowStepErrorHandler(context, null, context.getTaskId())).tag("WORKFLOW").body(new WorkflowErrorHandling(step.getOnError(), context.getWorkflowExectionContext(), context.getWorkflowExectionContext().currentStepIndex, stepTask, error)).build();
        TaskTags.addTagDynamically(stepTask, BrooklynTaskTags.tagForErrorHandledBy(task));
        log.trace("Creating error handler for step  " + context.getWorkflowStepReference() + " - " + task.getDisplayName() + " in task " + task.getId());
        return task;
    }

    public static Task<WorkflowErrorHandlingResult> createWorkflowErrorHandlerTask(WorkflowExecutionContext context, Task<?> workflowTask, Throwable error) {
        log.debug("Encountered error in workflow " + context.getWorkflowId() + "/" + context.getTaskId() + " '" + workflowTask.getDisplayName() + "' (handler present): " + Exceptions.collapseText((Throwable)error));
        Task<WorkflowErrorHandlingResult> task = Tasks.builder().dynamic(true).displayName(context.getWorkflowId() + "-" + "error-handler").tag(BrooklynTaskTags.tagForWorkflowStepErrorHandler(context)).tag("WORKFLOW").body(new WorkflowErrorHandling(context.onError, context, null, workflowTask, error)).build();
        TaskTags.addTagDynamically(workflowTask, BrooklynTaskTags.tagForErrorHandledBy(task));
        log.trace("Creating error handler for workflow " + context.getWorkflowId() + "/" + context.getTaskId() + " - " + task.getDisplayName() + " in task " + task.getId());
        return task;
    }

    public static List<Object> wrappedInListIfNecessaryOrNullIfEmpty(Object onError) {
        MutableList errorList;
        if (onError == null) {
            return null;
        }
        MutableList mutableList = errorList = onError instanceof Collection ? MutableList.copyOf((Iterable)((Collection)onError)) : MutableList.of((Object)onError);
        if (errorList.isEmpty()) {
            return null;
        }
        return errorList;
    }

    public WorkflowErrorHandling(Object errorOptionsO, WorkflowExecutionContext context, Integer stepIndexIfStepErrorHandler, Task<?> failedTask, Throwable error) {
        List<Object> errorOptions = WorkflowErrorHandling.wrappedInListIfNecessaryOrNullIfEmpty(errorOptionsO);
        this.errorOptions = WorkflowStepResolution.resolveSubSteps(context.getManagementContext(), "error handling", errorOptions);
        this.context = context;
        this.stepIndexIfStepErrorHandler = stepIndexIfStepErrorHandler;
        this.failedTask = failedTask;
        this.error = error;
    }

    @Override
    public WorkflowErrorHandlingResult call() throws Exception {
        WorkflowErrorHandlingResult result = new WorkflowErrorHandlingResult();
        Task handlerParent = Tasks.current();
        log.debug("Starting " + (handlerParent.getDisplayName().endsWith("error-handler") ? "" : "nested error handler for ") + handlerParent.getDisplayName() + " with " + this.errorOptions.size() + " step" + (this.errorOptions.size() != 1 ? "s" : "") + " in task " + handlerParent.getId());
        int errorStepsMatching = 0;
        WorkflowStepDefinition errorStep = null;
        boolean lastStepConditionMatched = false;
        for (int i = 0; i < this.errorOptions.size(); ++i) {
            WorkflowStepInstanceExecutionContext handlerContext;
            errorStep = this.errorOptions.get(i);
            this.context.errorHandlerContext = handlerContext = new WorkflowStepInstanceExecutionContext(this.stepIndexIfStepErrorHandler != null ? this.stepIndexIfStepErrorHandler : -3, errorStep, this.context);
            handlerContext.setError(this.error);
            lastStepConditionMatched = false;
            String potentialTaskName = Tasks.current().getDisplayName() + "-" + (i + 1);
            DslPredicates.DslPredicate condition = errorStep.getConditionResolved(handlerContext);
            if (condition != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Considering condition " + condition + " for " + potentialTaskName);
                }
                boolean conditionMet = DslPredicates.evaluateDslPredicateWithBrooklynObjectContext(condition, this.error, (BrooklynObject)handlerContext.getEntity());
                if (log.isTraceEnabled()) {
                    log.trace("Considered condition " + condition + " for " + potentialTaskName + ": " + conditionMet);
                }
                if (!conditionMet) continue;
            }
            ++errorStepsMatching;
            lastStepConditionMatched = true;
            Task<?> handlerI = errorStep.newTaskAsSubTask(handlerContext, potentialTaskName, BrooklynTaskTags.tagForWorkflowStepErrorHandler(handlerContext, i, handlerParent.getId()));
            TaskTags.addTagDynamically(handlerParent, BrooklynTaskTags.tagForErrorHandledBy(handlerI));
            log.trace("Creating error handler step " + potentialTaskName + " '" + errorStep.computeName(handlerContext, false) + "' in task " + handlerI.getId());
            if (!potentialTaskName.equals(this.context.getWorkflowStepReference(handlerI))) {
                log.warn("Mismatch in step name: " + potentialTaskName + " / " + this.context.getWorkflowStepReference(handlerI));
            }
            try {
                result.output = DynamicTasks.queue(handlerI).getUnchecked();
                if (errorStep.output != null) {
                    result.output = handlerContext.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_FINISHING_POST_OUTPUT, errorStep.output, Object.class);
                }
                this.context.lastErrorHandlerOutput = result.output;
                result.next = WorkflowReplayUtils.getNext(handlerContext, errorStep);
            }
            catch (Exception errorInErrorHandlerStep) {
                BiConsumer<Object, Object> onFinish = (output, next) -> {
                    result.output = output;
                    result.next = next;
                };
                WorkflowErrorHandling.handleErrorAtStep(this.context.getEntity(), errorStep, handlerContext, handlerI, onFinish, errorInErrorHandlerStep, i);
            }
            if (result.next == null) continue;
            log.debug("Completed handler " + Tasks.current().getDisplayName() + (errorStepsMatching > 1 ? " with " + errorStepsMatching + " steps matching" : "") + "; proceeding to explicit next step '" + result.next + "'");
            break;
        }
        if (result.next == null) {
            if (errorStepsMatching == 0 || errorStep == null) {
                log.debug("Error handler options were present but did not apply at " + handlerParent.getId());
                return null;
            }
            if (!lastStepConditionMatched) {
                log.warn("Error handler ran but did not return a next execution point and final step had a condition which did not match; this may be an error. For clarity, error handlers should either indicate a next step or have a non-conditional final step. Continuing with next step of outer workflow assuming that the error was handled.The target `next: exit` can be used to exit a handler.");
            }
            log.debug("Completed handler " + Tasks.current().getDisplayName() + (errorStepsMatching > 1 ? " with " + errorStepsMatching + " steps matching" : "") + "; no next step indicated so proceeding to default next step");
        }
        return result;
    }

    public static void handleErrorAtStep(Entity entity, WorkflowStepDefinition step, WorkflowStepInstanceExecutionContext currentStepInstance, Task<?> stepTaskThrowingError, BiConsumer<Object, Object> onFinish, Exception error, Integer errorStepIfNested) {
        String problemHere = null;
        if (WorkflowErrorHandling.wrappedInListIfNecessaryOrNullIfEmpty(step.onError) != null) {
            if (errorStepIfNested != null) {
                log.debug("Nested error handler running on " + stepTaskThrowingError + " to handle " + error);
            }
            try {
                Task<WorkflowErrorHandlingResult> stepErrorHandlerTask = WorkflowErrorHandling.createStepErrorHandlerTask(step, currentStepInstance, stepTaskThrowingError, error, errorStepIfNested);
                currentStepInstance.errorHandlerTaskId = stepErrorHandlerTask.getId();
                WorkflowErrorHandlingResult result = (WorkflowErrorHandlingResult)DynamicTasks.queue(stepErrorHandlerTask).getUnchecked();
                if (result != null) {
                    if ("exit".equals(result.next)) {
                        result.next = null;
                    }
                    onFinish.accept(result.output, result.next);
                    return;
                }
                problemHere = "error handler present but no steps applicable, ";
            }
            catch (Exception e2) {
                if (!Exceptions.getCausalChain((Throwable)e2).stream().anyMatch(e3 -> e3 == error)) {
                    WorkflowErrorHandling.logWarnOnExceptionOrDebugIfKnown(entity, e2, "Error in step '" + stepTaskThrowingError.getDisplayName() + "' error handler for -- " + Exceptions.collapseText((Throwable)error) + " -- threw another error (rethrowing): " + Exceptions.collapseText((Throwable)e2));
                    log.debug("Full trace of original error was: " + error, (Throwable)error);
                }
                throw Exceptions.propagate((Throwable)e2);
            }
            finally {
                if (errorStepIfNested == null) {
                    currentStepInstance.getWorkflowExectionContext().lastErrorHandlerOutput = null;
                }
            }
        } else {
            problemHere = "";
        }
        WorkflowErrorHandling.logWarnOnExceptionOrDebugIfKnown(entity, error, currentStepInstance.getWorkflowExectionContext().getName() + ": Error in step '" + stepTaskThrowingError.getDisplayName() + "'; " + problemHere + "rethrowing: " + Exceptions.collapseText((Throwable)error));
        throw Exceptions.propagate((Throwable)error);
    }

    public static void logWarnOnExceptionOrDebugIfKnown(Entity entity, Exception e, String msg) {
        if (Exceptions.getFirstThrowableOfType((Throwable)e, DanglingWorkflowException.class) != null) {
            log.debug(msg);
            return;
        }
        if (Entities.isUnmanagingOrNoLongerManaged(entity)) {
            log.debug(msg);
            return;
        }
        log.warn(msg);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class WorkflowErrorHandlingResult {
        Object next;
        Object output;
    }
}

