/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.javalang.Threads;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynShutdownHooks {
    private static final Logger log = LoggerFactory.getLogger(BrooklynShutdownHooks.class);
    private static final Duration DEFAULT_SHUTDOWN_TIMEOUT = Duration.TWO_MINUTES;
    private static final AtomicBoolean isShutdownHookRegistered = new AtomicBoolean();
    private static final List<Entity> entitiesToStopOnShutdown = Lists.newArrayList();
    private static final List<ManagementContext> managementContextsToStopAppsOnShutdown = Lists.newArrayList();
    private static final List<ManagementContext> managementContextsToTerminateOnShutdown = Lists.newArrayList();
    private static final AtomicBoolean isShutDown = new AtomicBoolean(false);
    private static final Semaphore semaphore = new Semaphore(1);
    private static volatile Duration shutdownTimeout = DEFAULT_SHUTDOWN_TIMEOUT;

    public static void setShutdownTimeout(Duration val) {
        shutdownTimeout = val;
    }

    public static void invokeStopOnShutdown(Entity entity) {
        if (!(entity instanceof Startable)) {
            log.warn("Not adding entity {} for stop-on-shutdown as not an instance of {}", (Object)entity, (Object)Startable.class.getSimpleName());
            return;
        }
        try {
            semaphore.acquire();
            if (isShutDown.get()) {
                semaphore.release();
                try {
                    log.warn("Call to invokeStopOnShutdown for " + entity + " while system already shutting down; invoking stop now and throwing exception");
                    Entities.destroy(entity, false);
                    throw new IllegalStateException("Call to invokeStopOnShutdown for " + entity + " while system already shutting down");
                }
                catch (Exception e) {
                    throw new IllegalStateException("Call to invokeStopOnShutdown for " + entity + " while system already shutting down, had error: " + e, e);
                }
            }
            try {
                entitiesToStopOnShutdown.add(entity);
            }
            finally {
                semaphore.release();
            }
            BrooklynShutdownHooks.addShutdownHookIfNotAlready();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static void resetShutdownFlag() {
        try {
            semaphore.acquire();
            isShutDown.compareAndSet(true, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Could not reset shutdown flag", e);
        }
        finally {
            semaphore.release();
        }
    }

    public static void invokeStopAppsOnShutdown(ManagementContext managementContext) {
        try {
            semaphore.acquire();
            if (isShutDown.get()) {
                semaphore.release();
                try {
                    log.warn("Call to invokeStopAppsOnShutdown for " + managementContext + " while system already shutting down; invoking stop now and throwing exception");
                    BrooklynShutdownHooks.destroyAndWait(managementContext.getApplications(), shutdownTimeout);
                    throw new IllegalStateException("Call to invokeStopAppsOnShutdown for " + managementContext + " while system already shutting down");
                }
                catch (Exception e) {
                    throw new IllegalStateException("Call to invokeStopAppsOnShutdown for " + managementContext + " while system already shutting down, had error: " + e, e);
                }
            }
            managementContextsToStopAppsOnShutdown.add(managementContext);
            semaphore.release();
            BrooklynShutdownHooks.addShutdownHookIfNotAlready();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static void invokeTerminateOnShutdown(ManagementContext managementContext) {
        try {
            semaphore.acquire();
            if (isShutDown.get()) {
                semaphore.release();
                try {
                    log.warn("Call to invokeStopOnShutdown for " + managementContext + " while system already shutting down; invoking stop now and throwing exception");
                    ((ManagementContextInternal)managementContext).terminate();
                    throw new IllegalStateException("Call to invokeTerminateOnShutdown for " + managementContext + " while system already shutting down");
                }
                catch (Exception e) {
                    throw new IllegalStateException("Call to invokeTerminateOnShutdown for " + managementContext + " while system already shutting down, had error: " + e, e);
                }
            }
            managementContextsToTerminateOnShutdown.add(managementContext);
            semaphore.release();
            BrooklynShutdownHooks.addShutdownHookIfNotAlready();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static void addShutdownHookIfNotAlready() {
        if (isShutdownHookRegistered.compareAndSet(false, true)) {
            Threads.addShutdownHook((Runnable)BrooklynShutdownHookJob.newInstanceForReal());
        }
    }

    protected static void destroyAndWait(Iterable<? extends Entity> entitiesToStop, Duration timeout) {
        MutableList stops = MutableList.of();
        for (Entity entity : entitiesToStop) {
            final Entity entity2 = entity;
            if (!Entities.isManaged(entity2)) continue;
            Task t = Tasks.builder().dynamic(false).displayName("destroying " + entity2).body(new Runnable(){

                @Override
                public void run() {
                    Entities.destroy(entity2, false);
                }
            }).build();
            stops.add((Object)((EntityInternal)entity2).getExecutionContext().submit(t));
        }
        CountdownTimer timer = CountdownTimer.newInstanceStarted((Duration)timeout);
        for (Task t : stops) {
            try {
                Duration durationRemaining = timer.getDurationRemaining();
                Object result = t.getUnchecked(durationRemaining.isPositive() ? durationRemaining : Duration.ONE_MILLISECOND);
                if (!log.isDebugEnabled()) continue;
                log.debug("stopOnShutdown of {} completed: {}", (Object)t, result);
            }
            catch (RuntimeInterruptedException e) {
                Thread.currentThread().interrupt();
                if (!log.isDebugEnabled()) break;
                log.debug("stopOnShutdown of " + t + " interrupted: " + (Object)((Object)e));
                break;
            }
            catch (RuntimeException e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Shutdown hook " + t + " returned error (continuing): " + e);
                if (!log.isDebugEnabled()) continue;
                log.debug("stopOnShutdown of " + t + " returned error (continuing to stop others): " + e, (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public static class BrooklynShutdownHookJob
    implements Runnable {
        final boolean setStaticShutDownFlag;

        private BrooklynShutdownHookJob(boolean setStaticShutDownFlag) {
            this.setStaticShutDownFlag = setStaticShutDownFlag;
        }

        public static BrooklynShutdownHookJob newInstanceForReal() {
            return new BrooklynShutdownHookJob(true);
        }

        public static BrooklynShutdownHookJob newInstanceForTesting() {
            return new BrooklynShutdownHookJob(false);
        }

        @Override
        public void run() {
            MutableSet entitiesToStop = MutableSet.of();
            try {
                semaphore.acquire();
                if (this.setStaticShutDownFlag) {
                    isShutDown.set(true);
                }
                semaphore.release();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
            entitiesToStop.addAll(entitiesToStopOnShutdown);
            for (ManagementContext mgmt : managementContextsToStopAppsOnShutdown) {
                if (!mgmt.isRunning()) continue;
                entitiesToStop.addAll(mgmt.getApplications());
            }
            if (entitiesToStop.isEmpty()) {
                log.debug("Brooklyn shutdown: no entities to stop");
            } else {
                log.info("Brooklyn shutdown: stopping entities " + entitiesToStop);
                BrooklynShutdownHooks.destroyAndWait((Iterable<? extends Entity>)entitiesToStop, shutdownTimeout);
            }
            log.debug("Brooklyn terminateOnShutdown shutdown-hook invoked: terminating management contexts: " + managementContextsToTerminateOnShutdown);
            for (ManagementContext managementContext : managementContextsToTerminateOnShutdown) {
                try {
                    if (!managementContext.isRunning()) continue;
                    ((ManagementContextInternal)managementContext).terminate();
                }
                catch (RuntimeException e) {
                    log.info("terminateOnShutdown of " + managementContext + " returned error (continuing): " + e, (Throwable)e);
                }
            }
        }
    }
}

