/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf;

public class Property {
    private final String key;
    private final String value;
    private final String label;
    private final String description;

    public static Builder builder() {
        return new Builder();
    }

    public Property(String key, String value, String label, String description) {
        this.key = key;
        this.value = value;
        this.label = label;
        this.description = description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return String.format("[key=%s, value=%s, label=%s, description=%s]", this.key, this.value, this.label, this.description);
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    public static class Builder {
        protected String key;
        protected String value;
        protected String label;
        protected String description;

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Property build() {
            return new Property(this.key, this.value, this.label, this.description);
        }

        public Builder fromProperty(Property in) {
            return this.key(in.getKey()).value(in.getValue()).description(in.getDescription()).label(in.getLabel());
        }
    }
}

