/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.stock;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.entity.stock.SequenceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceEntityImpl
extends AbstractEntity
implements SequenceEntity {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceEntity.class);
    private Object mutex = new Object();

    @Override
    public void start(Collection<? extends Location> locations) {
        this.addLocations(locations);
        this.reset();
        this.sensors().set(SERVICE_UP, Boolean.TRUE);
    }

    @Override
    public void stop() {
        this.sensors().set(SERVICE_UP, Boolean.FALSE);
    }

    @Override
    public void restart() {
        this.stop();
        this.start(this.getLocations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer get() {
        Object object = this.mutex;
        synchronized (object) {
            return (Integer)this.sensors().get(SEQUENCE_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer incrementAndGet() {
        Object object = this.mutex;
        synchronized (object) {
            this.sequence();
            return this.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void increment() {
        Object object = this.mutex;
        synchronized (object) {
            this.sequence();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void reset() {
        Object object = this.mutex;
        synchronized (object) {
            Integer start = (Integer)this.config().get(SEQUENCE_START);
            AtomicInteger state = new AtomicInteger(start);
            this.sensors().set(SEQUENCE_STATE, state);
            this.sensors().set(SEQUENCE_VALUE, state.get());
            return null;
        }
    }

    private void sequence() {
        Integer increment = (Integer)this.config().get(SEQUENCE_INCREMENT);
        AtomicInteger state = (AtomicInteger)this.sensors().get(SEQUENCE_STATE);
        Integer current = state.addAndGet(increment);
        this.sensors().set(SEQUENCE_VALUE, current);
        LOG.debug("Sequence for {} set to {}", (Object)this, (Object)current);
    }
}

