/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.functions.CleanupResources;
import org.jclouds.openstack.nova.v2_0.compute.functions.RemoveFloatingIpFromNodeAndDeallocate;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.RebootType;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerCreated;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.FlavorInRegion;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ImageInRegion;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ServerInRegion;
import org.jclouds.openstack.nova.v2_0.extensions.ServerAdminApi;
import org.jclouds.openstack.nova.v2_0.options.CreateServerOptions;
import org.jclouds.openstack.nova.v2_0.predicates.ImagePredicates;

public class NovaComputeServiceAdapter
implements ComputeServiceAdapter<ServerInRegion, FlavorInRegion, ImageInRegion, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaApi novaApi;
    protected final Supplier<Set<String>> regionIds;
    protected final RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate;
    private final Predicate<RegionAndId> serverRunningPredicate;
    private final Predicate<RegionAndId> serverTerminatedPredicate;
    private final CleanupResources cleanupResources;

    @Inject
    public NovaComputeServiceAdapter(NovaApi novaApi, @Region Supplier<Set<String>> regionIds, RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate, @Named(value="jclouds.compute.timeout.node-running") Predicate<RegionAndId> serverRunningPredicate, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<RegionAndId> serverTerminatedPredicate, CleanupResources cleanupResources) {
        this.novaApi = (NovaApi)Preconditions.checkNotNull((Object)novaApi, (Object)"novaApi");
        this.regionIds = (Supplier)Preconditions.checkNotNull(regionIds, (Object)"regionIds");
        this.removeFloatingIpFromNodeAndDeallocate = (RemoveFloatingIpFromNodeAndDeallocate)Preconditions.checkNotNull((Object)removeFloatingIpFromNodeAndDeallocate, (Object)"removeFloatingIpFromNodeAndDeallocate");
        this.serverRunningPredicate = serverRunningPredicate;
        this.serverTerminatedPredicate = serverTerminatedPredicate;
        this.cleanupResources = cleanupResources;
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<ServerInRegion> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        String regionId = template.getLocation().getId();
        String imageId = template.getImage().getProviderId();
        String flavorId = template.getHardware().getProviderId();
        NovaTemplateOptions templateOptions = (NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class);
        CreateServerOptions options = new CreateServerOptions();
        Map metadataAndTagsAsCommaDelimitedValue = ComputeServiceUtils.metadataAndTagsAsCommaDelimitedValue((TemplateOptions)template.getOptions());
        options.metadata(metadataAndTagsAsCommaDelimitedValue);
        if (!templateOptions.getGroups().isEmpty()) {
            options.securityGroupNames(templateOptions.getGroups());
        }
        options.userData(templateOptions.getUserData());
        options.diskConfig(templateOptions.getDiskConfig());
        options.configDrive(templateOptions.getConfigDrive());
        options.availabilityZone(templateOptions.getAvailabilityZone());
        if (templateOptions.getNovaNetworks() != null) {
            options.novaNetworks(templateOptions.getNovaNetworks());
        }
        if (templateOptions.getNetworks() != null) {
            options.networks(templateOptions.getNetworks());
        }
        if (templateOptions.getKeyPairName() != null) {
            options.keyPairName(templateOptions.getKeyPairName());
        }
        if (!templateOptions.getBlockDeviceMappings().isEmpty()) {
            options.blockDeviceMappings(templateOptions.getBlockDeviceMappings());
        }
        this.logger.debug(">> creating new server region(%s) name(%s) image(%s) flavor(%s) options(%s)", new Object[]{regionId, name, imageId, flavorId, options});
        ServerCreated lightweightServer = this.novaApi.getServerApi(regionId).create(name, imageId, flavorId, options);
        if (!this.serverRunningPredicate.apply((Object)RegionAndId.fromRegionAndId(regionId, lightweightServer.getId()))) {
            String message = String.format("Server %s was not created within %sms. The resources created for it will be destroyed", name, "30 * 60");
            this.logger.warn(message, new Object[0]);
            String tagString = (String)metadataAndTagsAsCommaDelimitedValue.get("jclouds_tags");
            HashSet tags = Sets.newHashSet((Iterable)Splitter.on((char)',').split((CharSequence)tagString));
            this.cleanupResources.removeSecurityGroupCreatedByJcloudsAndInvalidateCache(tags);
            throw new IllegalStateException(message);
        }
        this.logger.trace("<< server(%s)", new Object[]{lightweightServer.getId()});
        Server server = this.novaApi.getServerApi(regionId).get(lightweightServer.getId());
        ServerInRegion serverInRegion = new ServerInRegion(server, regionId);
        LoginCredentials.Builder credentialsBuilder = LoginCredentials.builder();
        if (templateOptions.getLoginPrivateKey() != null) {
            credentialsBuilder.privateKey(templateOptions.getLoginPrivateKey());
        }
        if (lightweightServer.getAdminPass().isPresent()) {
            credentialsBuilder.password((String)lightweightServer.getAdminPass().get());
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)serverInRegion, serverInRegion.slashEncode(), credentialsBuilder.build());
    }

    public Iterable<FlavorInRegion> listHardwareProfiles() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String regionId : (Set)this.regionIds.get()) {
            builder.addAll(Iterables.transform((Iterable)this.novaApi.getFlavorApi(regionId).listInDetail().concat(), (Function)new Function<Flavor, FlavorInRegion>(){

                public FlavorInRegion apply(Flavor arg0) {
                    return new FlavorInRegion(arg0, regionId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<ImageInRegion> listImages() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set regions = (Set)this.regionIds.get();
        Preconditions.checkState((!regions.isEmpty() ? 1 : 0) != 0, (String)"no regions found in supplier %s", (Object[])new Object[]{this.regionIds});
        for (final String regionId : regions) {
            ImmutableSet images = this.novaApi.getImageApi(regionId).listInDetail().concat().toSet();
            if (images.isEmpty()) {
                this.logger.debug("no images found in region %s", new Object[]{regionId});
                continue;
            }
            Iterable active = Iterables.filter((Iterable)images, ImagePredicates.statusEquals(Image.Status.ACTIVE));
            if (images.isEmpty()) {
                this.logger.debug("no images with status active in region %s; non-active: %s", new Object[]{regionId, Iterables.transform((Iterable)active, (Function)new Function<Image, String>(){

                    public String apply(Image input) {
                        return MoreObjects.toStringHelper((String)"").add("id", (Object)input.getId()).add("status", (Object)input.getStatus()).toString();
                    }
                })});
                continue;
            }
            builder.addAll(Iterables.transform((Iterable)active, (Function)new Function<Image, ImageInRegion>(){

                public ImageInRegion apply(Image arg0) {
                    return new ImageInRegion(arg0, regionId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<ServerInRegion> listNodes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String regionId : (Set)this.regionIds.get()) {
            builder.addAll((Iterable)this.novaApi.getServerApi(regionId).listInDetail().concat().transform((Function)new Function<Server, ServerInRegion>(){

                public ServerInRegion apply(Server arg0) {
                    return new ServerInRegion(arg0, regionId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<ServerInRegion> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<ServerInRegion>(){

            public boolean apply(ServerInRegion server) {
                return Iterables.contains((Iterable)ids, (Object)server.slashEncode());
            }
        });
    }

    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    public ServerInRegion getNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        Server server = this.novaApi.getServerApi(regionAndId.getRegion()).get(regionAndId.getId());
        return server == null ? null : new ServerInRegion(server, regionAndId.getRegion());
    }

    public ImageInRegion getImage(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        Image image = this.novaApi.getImageApi(regionAndId.getRegion()).get(regionAndId.getId());
        return image == null ? null : new ImageInRegion(image, regionAndId.getRegion());
    }

    public void destroyNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        this.novaApi.getServerApi(regionAndId.getRegion()).delete(regionAndId.getId());
        Preconditions.checkState((boolean)this.serverTerminatedPredicate.apply((Object)regionAndId), (Object)"server was not destroyed in the configured timeout");
    }

    public void rebootNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        this.novaApi.getServerApi(regionAndId.getRegion()).reboot(regionAndId.getId(), RebootType.HARD);
    }

    public void resumeNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        if (!this.novaApi.getServerAdminApi(regionAndId.getRegion()).isPresent()) {
            throw new UnsupportedOperationException("resume requires installation of the Admin Actions extension");
        }
        ((ServerAdminApi)this.novaApi.getServerAdminApi(regionAndId.getRegion()).get()).resume(regionAndId.getId());
    }

    public void suspendNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        if (!this.novaApi.getServerAdminApi(regionAndId.getRegion()).isPresent()) {
            throw new UnsupportedOperationException("suspend requires installation of the Admin Actions extension");
        }
        ((ServerAdminApi)this.novaApi.getServerAdminApi(regionAndId.getRegion()).get()).suspend(regionAndId.getId());
    }
}

