/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.googlecloud.internal.NullSafeCopies;
import org.jclouds.googlecomputeengine.domain.AutoValue_Project;
import org.jclouds.googlecomputeengine.domain.AutoValue_Project_UsageExportLocation;
import org.jclouds.googlecomputeengine.domain.Metadata;
import org.jclouds.googlecomputeengine.domain.Quota;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Project {
    public abstract String id();

    public abstract URI selfLink();

    public abstract String name();

    @Nullable
    public abstract String description();

    public abstract Metadata commonInstanceMetadata();

    public abstract List<Quota> quotas();

    public abstract List<String> externalIpAddresses();

    public abstract Date creationTimestamp();

    @Nullable
    public abstract UsageExportLocation usageExportLocation();

    @SerializedNames(value={"id", "selfLink", "name", "description", "commonInstanceMetadata", "quotas", "externalIpAddresses", "creationTimestamp", "usageExportLocation"})
    public static Project create(String id, URI selfLink, String name, String description, Metadata commonInstanceMetadata, List<Quota> quotas, List<String> externalIpAddresses, Date creationTimestamp, UsageExportLocation usageExportLocation) {
        return new AutoValue_Project(id, selfLink, name, description, commonInstanceMetadata, NullSafeCopies.copyOf(quotas), NullSafeCopies.copyOf(externalIpAddresses), creationTimestamp, usageExportLocation);
    }

    Project() {
    }

    public static abstract class UsageExportLocation {
        public abstract String bucketName();

        public abstract String reportNamePrefix();

        @SerializedNames(value={"bucketName", "reportNamePrefix"})
        public static UsageExportLocation create(String bucketName, String reporNamePrefix) {
            return new AutoValue_Project_UsageExportLocation(bucketName, reporNamePrefix);
        }

        UsageExportLocation() {
        }
    }
}

