/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.util.Clock;
import java.lang.reflect.Array;

public abstract class Windowed<T> {
    private Class<T> clazz;
    protected final T[] buffers;
    private final long sliceDuration;
    private final Clock clock;
    private long index = -1L;
    private Function<T, T> clearer;

    public Windowed(Class<T> clazz, Amount<Long, Time> amount, int n, Supplier<T> supplier, Function<T, T> function, Clock clock) {
        Preconditions.checkNotNull(amount);
        Preconditions.checkArgument(((Long)amount.as((Unit)Time.MILLISECONDS) > (long)(n + 1) ? 1 : 0) != 0);
        Preconditions.checkArgument(((Long)amount.as((Unit)Time.MILLISECONDS) > (long)(n + 1) ? 1 : 0) != 0);
        Preconditions.checkArgument((0 < n ? 1 : 0) != 0);
        Preconditions.checkNotNull(supplier);
        Preconditions.checkNotNull((Object)clock);
        this.clazz = clazz;
        this.sliceDuration = (Long)amount.as((Unit)Time.MILLISECONDS) / (long)n;
        Object[] objectArray = (Object[])Array.newInstance(clazz, n + 1);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = supplier.get();
        }
        this.buffers = objectArray;
        this.clearer = function;
        this.clock = clock;
    }

    protected int getCurrentIndex() {
        long l = this.clock.nowMillis();
        return (int)(l / this.sliceDuration);
    }

    protected T getCurrent() {
        this.sync(this.getCurrentIndex());
        return this.buffers[(int)(this.index % (long)this.buffers.length)];
    }

    protected T[] getTenured() {
        long l = this.getCurrentIndex();
        this.sync(l);
        Object[] objectArray = (Object[])Array.newInstance(this.clazz, this.buffers.length - 1);
        for (int i = 0; i < objectArray.length; ++i) {
            int n = (int)((l + 1L + (long)i) % (long)this.buffers.length);
            objectArray[i] = this.buffers[n];
        }
        return objectArray;
    }

    public void clear() {
        for (int i = 0; i <= this.buffers.length; ++i) {
            this.buffers[i] = this.clearer.apply(this.buffers[i]);
        }
    }

    protected void sync(long l) {
        if (this.index < l) {
            long l2;
            for (long i = l2 = Math.max(this.index + 1L, l - (long)this.buffers.length + 1L); i <= l; ++i) {
                int n = (int)(i % (long)this.buffers.length);
                this.buffers[n] = this.clearer.apply(this.buffers[n]);
            }
            this.index = l;
        }
    }
}

