/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.config;

import com.google.common.base.Optional;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.apache.distributedlog.config.DynamicConfigurationFactory;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.service.config.StreamConfigProvider;
import org.apache.distributedlog.service.streamset.StreamPartitionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceStreamConfigProvider
implements StreamConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceStreamConfigProvider.class);
    private static final String CONFIG_EXTENSION = "conf";
    private final File configBaseDir;
    private final File defaultConfigFile;
    private final StreamPartitionConverter partitionConverter;
    private final DynamicConfigurationFactory configFactory;
    private final DynamicDistributedLogConfiguration defaultDynConf;

    public ServiceStreamConfigProvider(String configPath, String defaultConfigPath, StreamPartitionConverter partitionConverter, ScheduledExecutorService executorService, int reloadPeriod, TimeUnit reloadUnit) throws ConfigurationException {
        this.configBaseDir = new File(configPath);
        if (!this.configBaseDir.exists()) {
            throw new ConfigurationException("Stream configuration base directory " + configPath + " does not exist");
        }
        this.defaultConfigFile = new File(configPath);
        if (!this.defaultConfigFile.exists()) {
            throw new ConfigurationException("Stream configuration default config " + defaultConfigPath + " does not exist");
        }
        this.partitionConverter = partitionConverter;
        this.configFactory = new DynamicConfigurationFactory(executorService, reloadPeriod, reloadUnit);
        this.defaultDynConf = (DynamicDistributedLogConfiguration)this.configFactory.getDynamicConfiguration(defaultConfigPath).get();
    }

    @Override
    public Optional<DynamicDistributedLogConfiguration> getDynamicStreamConfig(String streamName) {
        String configName = this.partitionConverter.convert(streamName).getStream();
        String configPath = this.getConfigPath(configName);
        Optional dynConf = Optional.absent();
        try {
            dynConf = this.configFactory.getDynamicConfiguration(configPath, (ConcurrentBaseConfiguration)this.defaultDynConf);
        }
        catch (ConfigurationException ex) {
            LOG.warn("Configuration exception for stream {} ({}) at {}", new Object[]{streamName, configName, configPath, ex});
        }
        return dynConf;
    }

    private String getConfigPath(String configName) {
        return new File(this.configBaseDir, String.format("%s.%s", configName, CONFIG_EXTENSION)).getPath();
    }
}

