/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.thrift;

import com.twitter.finagle.Filter;
import com.twitter.finagle.Service;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.SourcedException;
import com.twitter.finagle.stats.ClientStatsReceiver$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.thrift.ThriftClientRequest;
import com.twitter.finagle.thrift.ThriftMethodStats;
import com.twitter.finagle.thrift.ThriftMethodStats$;
import com.twitter.finagle.thrift.ThriftServiceIface$;
import com.twitter.finagle.thrift.ThriftServiceIface$$anon$1$;
import com.twitter.finagle.thrift.maxReusableBufferSize$;
import com.twitter.scrooge.TReusableMemoryTransport;
import com.twitter.scrooge.TReusableMemoryTransport$;
import com.twitter.scrooge.ThriftException;
import com.twitter.scrooge.ThriftMethod;
import com.twitter.scrooge.ThriftResponse;
import com.twitter.scrooge.ThriftStruct;
import com.twitter.scrooge.ThriftStructCodec;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.StorageUnit;
import com.twitter.util.Throwables$;
import java.util.Arrays;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;

public final class ThriftServiceIface$ {
    public static final ThriftServiceIface$ MODULE$;
    private final Counter resetCounter;
    private final ThreadLocal<TReusableMemoryTransport> tlReusableBuffer;

    static {
        new ThriftServiceIface$();
    }

    private Counter resetCounter() {
        return this.resetCounter;
    }

    public Service<ThriftStruct, ThriftResponse> apply(ThriftMethod method, Service<ThriftClientRequest, byte[]> thriftService, TProtocolFactory pf, StatsReceiver stats) {
        return this.statsFilter(method, stats).andThen(this.thriftCodecFilter(method, pf)).andThen(thriftService);
    }

    private SimpleFilter<ThriftStruct, ThriftResponse> statsFilter(ThriftMethod method, StatsReceiver stats) {
        ThriftMethodStats methodStats = ThriftMethodStats$.MODULE$.apply(stats.scope(method.serviceName()).scope(method.name()));
        return new SimpleFilter<ThriftStruct, ThriftResponse>(methodStats){
            public final ThriftMethodStats methodStats$1;

            public Future<ThriftResponse> apply(ThriftStruct args, Service<ThriftStruct, ThriftResponse> service) {
                this.methodStats$1.requestsCounter().incr();
                return service.apply((Object)args).onSuccess((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final void apply(ThriftResponse result) {
                        if (result.successField().isDefined()) {
                            this.$outer.methodStats$1.successCounter().incr();
                        } else {
                            result.firstException().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anon$1$$anonfun$apply$1 $outer;

                                public final void apply(ThriftException ex) {
                                    this.$outer.com$twitter$finagle$thrift$ThriftServiceIface$$anon$$anonfun$$$outer().methodStats$1.failuresCounter().incr();
                                    this.$outer.com$twitter$finagle$thrift$ThriftServiceIface$$anon$$anonfun$$$outer().methodStats$1.failuresScope().counter(Throwables$.MODULE$.mkString((Throwable)ex)).incr();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                    }

                    public /* synthetic */ anon.1 com$twitter$finagle$thrift$ThriftServiceIface$$anon$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.methodStats$1 = methodStats$1;
            }
        };
    }

    private Filter<ThriftStruct, ThriftResponse, ThriftClientRequest, byte[]> thriftCodecFilter(ThriftMethod method, TProtocolFactory pf) {
        return new Filter<ThriftStruct, ThriftResponse, ThriftClientRequest, byte[]>(method, pf){
            public final ThriftMethod method$1;
            public final TProtocolFactory pf$1;

            public Future<ThriftResponse> apply(ThriftStruct args, Service<ThriftClientRequest, byte[]> service) {
                ThriftClientRequest request = ThriftServiceIface$.MODULE$.com$twitter$finagle$thrift$ThriftServiceIface$$encodeRequest(this.method$1.name(), args, this.pf$1, this.method$1.oneway());
                return service.apply((Object)request).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.2 $outer;

                    public final ThriftResponse apply(byte[] bytes) {
                        return (ThriftResponse)ThriftServiceIface$.MODULE$.com$twitter$finagle$thrift$ThriftServiceIface$$decodeResponse(bytes, this.$outer.method$1.responseCodec(), this.$outer.pf$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.method$1 = method$1;
                this.pf$1 = pf$1;
            }
        };
    }

    public Filter<ThriftStruct, Object, ThriftStruct, ThriftResponse> resultFilter(ThriftMethod method) {
        return new Filter<ThriftStruct, Object, ThriftStruct, ThriftResponse>(method){
            public final ThriftMethod method$2;

            public Future<Object> apply(ThriftStruct args, Service<ThriftStruct, ThriftResponse> service) {
                return service.apply((Object)args).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.3 $outer;

                    public final Future<Object> apply(ThriftResponse response) {
                        Option option;
                        block4: {
                            Option option2;
                            block7: {
                                Future future;
                                block3: {
                                    Future future2;
                                    block6: {
                                        block5: {
                                            block2: {
                                                option = response.firstException();
                                                if (!(option instanceof Some)) break block2;
                                                Some some = (Some)option;
                                                ThriftException exception = (ThriftException)some.x();
                                                ThriftServiceIface$.MODULE$.com$twitter$finagle$thrift$ThriftServiceIface$$setServiceName((Throwable)exception, this.$outer.method$2.serviceName());
                                                future = Future$.MODULE$.exception((Throwable)exception);
                                                break block3;
                                            }
                                            if (!None$.MODULE$.equals(option)) break block4;
                                            option2 = response.successField();
                                            if (!(option2 instanceof Some)) break block5;
                                            Some some = (Some)option2;
                                            Object result = some.x();
                                            future2 = Future$.MODULE$.value(result);
                                            break block6;
                                        }
                                        if (!None$.MODULE$.equals(option2)) break block7;
                                        future2 = Future$.MODULE$.exception((Throwable)new TApplicationException(5, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Thrift method '", "' failed: missing result"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.method$2.name()}))));
                                    }
                                    future = future2;
                                }
                                return future;
                            }
                            throw new MatchError((Object)option2);
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.method$2 = method$2;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private TReusableMemoryTransport getReusableBuffer() {
        void var1_1;
        TReusableMemoryTransport buf = this.tlReusableBuffer.get();
        buf.reset();
        return var1_1;
    }

    private void resetBuffer(TReusableMemoryTransport trans) {
        if ((long)trans.currentCapacity() > ((StorageUnit)maxReusableBufferSize$.MODULE$.apply()).inBytes()) {
            this.resetCounter().incr();
            this.tlReusableBuffer.remove();
        }
    }

    public ThriftClientRequest com$twitter$finagle$thrift$ThriftServiceIface$$encodeRequest(String methodName, ThriftStruct args, TProtocolFactory pf, boolean oneway) {
        TReusableMemoryTransport buf = this.getReusableBuffer();
        TProtocol oprot = pf.getProtocol((TTransport)buf);
        oprot.writeMessageBegin(new TMessage(methodName, 1, 0));
        args.write(oprot);
        oprot.writeMessageEnd();
        byte[] bytes = Arrays.copyOfRange(buf.getArray(), 0, buf.length());
        this.resetBuffer(buf);
        return new ThriftClientRequest(bytes, oneway);
    }

    public <T extends ThriftStruct> T com$twitter$finagle$thrift$ThriftServiceIface$$decodeResponse(byte[] resBytes, ThriftStructCodec<T> codec, TProtocolFactory pf) {
        TProtocol iprot = pf.getProtocol((TTransport)new TMemoryInputTransport(resBytes));
        TMessage msg = iprot.readMessageBegin();
        if (msg.type == 3) {
            TApplicationException exception = TApplicationException.read((TProtocol)iprot);
            iprot.readMessageEnd();
            throw exception;
        }
        ThriftStruct result = codec.decode(iprot);
        iprot.readMessageEnd();
        return (T)result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Throwable com$twitter$finagle$thrift$ThriftServiceIface$$setServiceName(Throwable ex, String serviceName) {
        Throwable throwable = ex;
        if (!(throwable instanceof SourcedException)) return ex;
        SourcedException sourcedException = (SourcedException)throwable;
        if (serviceName.isEmpty()) return ex;
        sourcedException.serviceName_$eq(serviceName);
        return (Throwable)sourcedException;
    }

    private ThriftServiceIface$() {
        MODULE$ = this;
        this.resetCounter = ClientStatsReceiver$.MODULE$.scope("thrift_service_iface").counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reusable_buffer_resets"}));
        this.tlReusableBuffer = new ThreadLocal<TReusableMemoryTransport>(){

            public TReusableMemoryTransport initialValue() {
                return TReusableMemoryTransport$.MODULE$.apply(512);
            }
        };
    }
}

