/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.twitter.common.base.CallableExceptionalSupplier;
import com.twitter.common.base.ExceptionalFunction;

public final class ExceptionalFunctions {
    private ExceptionalFunctions() {
    }

    public static <S, T, E extends Exception> CallableExceptionalSupplier<T, E> curry(final ExceptionalFunction<S, T, E> function, final S argument) {
        return new CallableExceptionalSupplier<T, E>(){

            @Override
            public T get() throws Exception {
                return function.apply(argument);
            }
        };
    }

    public static <T, E extends Exception> ExceptionalFunction<T, T, E> compose(final Iterable<ExceptionalFunction<T, T, E>> functions) {
        return new ExceptionalFunction<T, T, E>(){

            @Override
            public T apply(T input) throws Exception {
                Object result = input;
                for (ExceptionalFunction f : functions) {
                    result = f.apply(result);
                }
                return result;
            }
        };
    }

    public static <T, E extends Exception> ExceptionalFunction<T, T, E> compose(ExceptionalFunction<T, T, E> function, ExceptionalFunction<T, T, E> ... functions) {
        return ExceptionalFunctions.compose(ImmutableList.builder().add(function).add((Object[])functions).build());
    }

    public static <A, B, C, E extends Exception> ExceptionalFunction<A, C, E> compose(final ExceptionalFunction<B, C, ? extends E> second, final ExceptionalFunction<A, ? extends B, ? extends E> first) {
        return new ExceptionalFunction<A, C, E>(){

            @Override
            public C apply(A item) throws Exception {
                return second.apply(first.apply(item));
            }
        };
    }

    public static <S, T, E extends Exception> ExceptionalFunction<S, T, E> forFunction(final Function<S, T> function) {
        return new ExceptionalFunction<S, T, E>(){

            @Override
            public T apply(S item) {
                return function.apply(item);
            }
        };
    }

    public static <S, T, E extends Exception> ExceptionalFunction<S, T, E> constant(final T value) {
        return new ExceptionalFunction<S, T, E>(){

            @Override
            public T apply(S item) throws Exception {
                return value;
            }
        };
    }

    public static <S, T, E extends Exception> ExceptionalFunction<S, T, E> forException(final E exception) {
        return new ExceptionalFunction<S, T, E>(){

            @Override
            public T apply(S item) throws Exception {
                throw exception;
            }
        };
    }
}

