/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.internal.jshell.tool;

import java.util.Arrays;
import java.util.stream.Stream;

class ArgTokenizer {
    private final String str;
    private final int length;
    private int next = 0;
    private char[] buf = new char[20];
    private int mark;
    private final byte[] ctype = new byte[256];
    private static final byte CT_ALPHA = 0;
    private static final byte CT_WHITESPACE = 1;
    private static final byte CT_QUOTE = 8;
    private String sval;
    private boolean isQuoted = false;

    ArgTokenizer(String arg) {
        this.str = arg;
        this.length = arg.length();
        this.quoteChar(34);
        this.quoteChar(39);
        this.whitespaceChars(9, 13);
        this.whitespaceChars(28, 32);
        this.whitespaceChars(133, 133);
        this.whitespaceChars(160, 160);
    }

    String next() {
        this.nextToken();
        return this.sval;
    }

    String[] next(String ... strings) {
        return this.next(Arrays.stream(strings));
    }

    String[] next(Stream<String> stream) {
        this.nextToken();
        if (this.sval == null) {
            return null;
        }
        String[] matches = (String[])stream.filter(s -> s.startsWith(this.sval)).toArray(String[]::new);
        return matches;
    }

    String val() {
        return this.sval;
    }

    boolean isQuoted() {
        return this.isQuoted;
    }

    String whole() {
        return this.str;
    }

    void mark() {
        this.mark = this.next;
    }

    void rewind() {
        this.next = this.mark;
    }

    private int read() {
        if (this.next >= this.length) {
            return -1;
        }
        return this.str.charAt(this.next++);
    }

    private void whitespaceChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 1;
        }
    }

    private void quoteChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 8;
        }
    }

    private int unicode2ctype(int c) {
        switch (c) {
            case 5760: 
            case 6158: 
            case 8202: 
            case 8239: 
            case 8287: 
            case 12288: {
                return 1;
            }
        }
        return 0;
    }

    public void nextToken() {
        int c;
        int lctype;
        byte[] ct2 = this.ctype;
        this.sval = null;
        this.isQuoted = false;
        do {
            if ((c = this.read()) >= 0) continue;
            return;
        } while ((lctype = c < 256 ? ct2[c] : this.unicode2ctype(c)) == 1);
        if (lctype == 0) {
            int i = 0;
            do {
                if (i >= this.buf.length) {
                    this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
                }
                this.buf[i++] = (char)c;
            } while ((lctype = (c = this.read()) < 0 ? 1 : (c < 256 ? ct2[c] : this.unicode2ctype(c))) == 0);
            if (c >= 0) {
                --this.next;
            }
            this.sval = String.copyValueOf(this.buf, 0, i);
            return;
        }
        if (lctype == 8) {
            int quote = c;
            int i = 0;
            int d = this.read();
            while (d >= 0 && d != quote) {
                if (d == 92) {
                    int first = c = this.read();
                    if (c >= 48 && c <= 55) {
                        c -= 48;
                        int c2 = this.read();
                        if (48 <= c2 && c2 <= 55) {
                            c = (c << 3) + (c2 - 48);
                            c2 = this.read();
                            if (48 <= c2 && c2 <= 55 && first <= 51) {
                                c = (c << 3) + (c2 - 48);
                                d = this.read();
                            } else {
                                d = c2;
                            }
                        } else {
                            d = c2;
                        }
                    } else {
                        switch (c) {
                            case 97: {
                                c = 7;
                                break;
                            }
                            case 98: {
                                c = 8;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 116: {
                                c = 9;
                                break;
                            }
                            case 118: {
                                c = 11;
                            }
                        }
                        d = this.read();
                    }
                } else {
                    c = d;
                    d = this.read();
                }
                if (i >= this.buf.length) {
                    this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
                }
                this.buf[i++] = (char)c;
            }
            if (d == quote) {
                this.isQuoted = true;
            }
            this.sval = String.copyValueOf(this.buf, 0, i);
        }
    }
}

