/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.announcer;

import com.twitter.common.zookeeper.Group;
import com.twitter.common.zookeeper.ServerSet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.distributedlog.client.serverset.DLZkServerSet;
import org.apache.distributedlog.service.announcer.Announcer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSetAnnouncer
implements Announcer {
    private static final Logger logger = LoggerFactory.getLogger(ServerSetAnnouncer.class);
    final String localAddr;
    final InetSocketAddress serviceEndpoint;
    final Map<String, InetSocketAddress> additionalEndpoints;
    final int shardId;
    DLZkServerSet zkServerSet;
    ServerSet.EndpointStatus serviceStatus = null;

    public ServerSetAnnouncer(URI uri, int servicePort, int statsPort, int shardId) throws UnknownHostException {
        this.shardId = shardId;
        this.localAddr = InetAddress.getLocalHost().getHostAddress();
        this.serviceEndpoint = new InetSocketAddress(this.localAddr, servicePort);
        InetSocketAddress statsEndpoint = new InetSocketAddress(this.localAddr, statsPort);
        this.additionalEndpoints = new HashMap<String, InetSocketAddress>();
        this.additionalEndpoints.put("aurora", statsEndpoint);
        this.additionalEndpoints.put("stats", statsEndpoint);
        this.additionalEndpoints.put("service", this.serviceEndpoint);
        this.additionalEndpoints.put("thrift", this.serviceEndpoint);
        this.zkServerSet = DLZkServerSet.of((URI)uri, (int)60000);
    }

    @Override
    public synchronized void announce() throws IOException {
        try {
            this.serviceStatus = this.zkServerSet.getServerSet().join(this.serviceEndpoint, this.additionalEndpoints, this.shardId);
        }
        catch (Group.JoinException e) {
            throw new IOException("Failed to announce service : ", e);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted on announcing service : ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void unannounce() throws IOException {
        if (null == this.serviceStatus) {
            logger.warn("No service to unannounce.");
            return;
        }
        try {
            this.serviceStatus.leave();
        }
        catch (ServerSet.UpdateException e) {
            throw new IOException("Failed to unannounce service : ", e);
        }
    }

    @Override
    public void close() {
        this.zkServerSet.close();
    }
}

