/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark.stream;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.BookKeeperClientBuilder;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientBuilder;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.benchmark.stream.AbstractReaderBenchmark;
import org.apache.distributedlog.benchmark.stream.AsyncReaderBenchmark;
import org.apache.distributedlog.benchmark.stream.LedgerStreamReader;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerReadBenchmark
extends AbstractReaderBenchmark {
    private static final Logger logger = LoggerFactory.getLogger(AsyncReaderBenchmark.class);

    @Override
    protected void benchmark(Namespace namespace, String logName, StatsLogger statsLogger) {
        BookKeeper bk;
        BKDLConfig bkdlConfig;
        DistributedLogManager dlm = null;
        while (null == dlm) {
            try {
                dlm = namespace.openLog(this.streamName);
            }
            catch (IOException ioe) {
                logger.warn("Failed to create dlm for stream {} : ", (Object)this.streamName, (Object)ioe);
            }
            if (null != dlm) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(this.conf.getZKSessionTimeoutMilliseconds());
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted from sleep while creating dlm for stream {} : ", (Object)this.streamName, (Object)e);
            }
        }
        logger.info("Created dlm for stream {}.", (Object)this.streamName);
        List segments = null;
        while (null == segments) {
            try {
                segments = dlm.getLogSegments();
            }
            catch (IOException ioe) {
                logger.warn("Failed to get log segments for stream {} : ", (Object)this.streamName, (Object)ioe);
            }
            if (null != segments) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(this.conf.getZKSessionTimeoutMilliseconds());
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted from sleep while geting log segments for stream {} : ", (Object)this.streamName, (Object)e);
            }
        }
        final Counter readCounter = statsLogger.getCounter("reads");
        logger.info("Reading from log segments : {}", (Object)segments);
        ZooKeeperClient zkc = ZooKeeperClientBuilder.newBuilder().uri(this.uri).name("benchmark-zkc").sessionTimeoutMs(this.conf.getZKSessionTimeoutMilliseconds()).zkAclId(null).build();
        try {
            bkdlConfig = BKDLConfig.resolveDLConfig((ZooKeeperClient)zkc, (URI)this.uri);
        }
        catch (IOException e) {
            return;
        }
        try {
            bk = BookKeeperClientBuilder.newBuilder().name("benchmark-bkc").dlConfig(this.conf).zkServers(bkdlConfig.getBkZkServersForReader()).ledgersPath(bkdlConfig.getBkLedgersPath()).build().get();
        }
        catch (IOException e) {
            return;
        }
        int readConcurrency = this.conf.getInt("ledger_read_concurrency", 1000);
        boolean streamRead = this.conf.getBoolean("ledger_stream_read", true);
        try {
            for (LogSegmentMetadata segment : segments) {
                Stopwatch stopwatch = Stopwatch.createStarted();
                long lid = segment.getLogSegmentId();
                LedgerHandle lh = bk.openLedgerNoRecovery(lid, BookKeeper.DigestType.CRC32, this.conf.getBKDigestPW().getBytes(Charsets.UTF_8));
                logger.info("It took {} ms to open log segment {}", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS), lh.getLastAddConfirmed() + 1L, segment});
                stopwatch.reset().start();
                LedgerStreamReader reader = streamRead ? new LedgerStreamReader(lh, new BookkeeperInternalCallbacks.ReadEntryListener(){

                    public void onEntryComplete(int rc, LedgerHandle lh, LedgerEntry entry, Object ctx) {
                        readCounter.inc();
                    }
                }, readConcurrency) : new LedgerStreamReader(lh, new BookkeeperInternalCallbacks.ReadEntryListener(){

                    public void onEntryComplete(int rc, LedgerHandle lh, LedgerEntry entry, Object ctx) {
                        readCounter.inc();
                    }
                }, readConcurrency);
                reader.run();
                logger.info("It took {} ms to complete reading {} entries from log segment {}", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS), lh.getLastAddConfirmed() + 1L, segment});
            }
        }
        catch (Exception e) {
            logger.error("Error on reading bk ", (Throwable)e);
        }
    }
}

