/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.distributedlog.benchmark.thrift.Message;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;

public class Utils {
    static final Random RAND = new Random(System.currentTimeMillis());
    static final ThreadLocal<TSerializer> MSG_SERIALIZER = new ThreadLocal<TSerializer>(){

        @Override
        public TSerializer initialValue() {
            return new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        }
    };

    public static byte[] generateMessage(long requestMillis, int payLoadSize) throws TException {
        byte[] payload = new byte[payLoadSize];
        RAND.nextBytes(payload);
        Message msg = new Message(requestMillis, ByteBuffer.wrap(payload));
        return MSG_SERIALIZER.get().serialize((TBase)msg);
    }

    public static Message parseMessage(byte[] data) throws TException {
        Message msg = new Message();
        TMemoryInputTransport transport = new TMemoryInputTransport(data);
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        msg.read((TProtocol)protocol);
        return msg;
    }
}

