/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import bk-shade.com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.shims.zk.ZooKeeperServerShim;
import org.apache.bookkeeper.shims.zk.ZooKeeperServerShimFactory;
import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBookKeeper {
    protected static final Logger LOG = LoggerFactory.getLogger(LocalBookKeeper.class);
    public static final int CONNECTION_TIMEOUT = 30000;
    int numberOfBookies;
    static String ZooKeeperDefaultHost = "127.0.0.1";
    static int ZooKeeperDefaultPort = 2181;
    static int zkSessionTimeOut = 5000;
    static Integer BookieDefaultInitialPort = 5000;
    File[] journalDirs;
    BookieServer[] bs;
    ServerConfiguration[] bsConfs;
    Integer initialPort = 5000;

    public LocalBookKeeper() {
        this(3);
    }

    public LocalBookKeeper(int numberOfBookies) {
        this(numberOfBookies, 5000);
    }

    public LocalBookKeeper(int numberOfBookies, int initialPort) {
        this.numberOfBookies = numberOfBookies;
        this.initialPort = initialPort;
        LOG.info("Running {} bookie(s) on zkServer {}.", (Object)this.numberOfBookies);
    }

    public static ZooKeeperServerShim runZookeeper(int maxCC, int zookeeperPort) throws IOException {
        File zkTmpDir = IOUtils.createTempDir("zookeeper", "localbookkeeper");
        return LocalBookKeeper.runZookeeper(maxCC, zookeeperPort, zkTmpDir);
    }

    public static ZooKeeperServerShim runZookeeper(int maxCC, int zookeeperPort, File zkDir) throws IOException {
        LOG.info("Starting ZK server");
        ZooKeeperServerShim server = ZooKeeperServerShimFactory.createServer(zkDir, zkDir, zookeeperPort, maxCC);
        server.start();
        boolean b = LocalBookKeeper.waitForServerUp(InetAddress.getLoopbackAddress().getHostAddress() + ":" + zookeeperPort, 30000L);
        if (LOG.isDebugEnabled()) {
            LOG.debug("ZooKeeper server up: {}", (Object)b);
        }
        return server;
    }

    private void initializeZookeeper(String zkHost, int zkPort) throws IOException {
        LOG.info("Instantiate ZK Client");
        ZooKeeperClient zkc = null;
        try {
            zkc = ZooKeeperClient.newBuilder().connectString(zkHost + ":" + zkPort).sessionTimeoutMs(zkSessionTimeOut).build();
            zkc.create("/ledgers", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zkc.create("/ledgers/available", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException e) {
            LOG.error("Exception while creating znodes", (Throwable)e);
            throw new IOException("Error creating znodes : ", e);
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while creating znodes", (Throwable)e);
            throw new IOException("Error creating znodes : ", e);
        }
    }

    private static void cleanupDirectories(List<File> dirs) throws IOException {
        for (File dir : dirs) {
            FileUtils.deleteDirectory((File)dir);
        }
    }

    private List<File> runBookies(ServerConfiguration baseConf, String dirSuffix) throws IOException, KeeperException, InterruptedException, BookieException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException, SecurityException {
        ArrayList<File> tempDirs = new ArrayList<File>();
        try {
            this.runBookies(baseConf, tempDirs, dirSuffix);
            return tempDirs;
        }
        catch (IOException ioe) {
            LocalBookKeeper.cleanupDirectories(tempDirs);
            throw ioe;
        }
        catch (KeeperException ke) {
            LocalBookKeeper.cleanupDirectories(tempDirs);
            throw ke;
        }
        catch (InterruptedException ie) {
            LocalBookKeeper.cleanupDirectories(tempDirs);
            throw ie;
        }
        catch (BookieException be) {
            LocalBookKeeper.cleanupDirectories(tempDirs);
            throw be;
        }
        catch (ReplicationException.UnavailableException ue) {
            LocalBookKeeper.cleanupDirectories(tempDirs);
            throw ue;
        }
        catch (ReplicationException.CompatibilityException ce) {
            LocalBookKeeper.cleanupDirectories(tempDirs);
            throw ce;
        }
    }

    private void runBookies(ServerConfiguration baseConf, List<File> tempDirs, String dirSuffix) throws IOException, KeeperException, InterruptedException, BookieException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException, SecurityException {
        LOG.info("Starting Bookie(s)");
        this.journalDirs = new File[this.numberOfBookies];
        this.bs = new BookieServer[this.numberOfBookies];
        this.bsConfs = new ServerConfiguration[this.numberOfBookies];
        for (int i = 0; i < this.numberOfBookies; ++i) {
            if (null == baseConf.getJournalDirNameWithoutDefault()) {
                this.journalDirs[i] = IOUtils.createTempDir("localbookkeeper" + Integer.toString(i), dirSuffix);
                tempDirs.add(this.journalDirs[i]);
            } else {
                this.journalDirs[i] = new File(baseConf.getJournalDirName(), "bookie" + Integer.toString(i));
            }
            if (this.journalDirs[i].exists()) {
                if (this.journalDirs[i].isDirectory()) {
                    FileUtils.deleteDirectory((File)this.journalDirs[i]);
                } else if (!this.journalDirs[i].delete()) {
                    throw new IOException("Couldn't cleanup bookie journal dir " + this.journalDirs[i]);
                }
            }
            if (!this.journalDirs[i].mkdirs()) {
                throw new IOException("Couldn't create bookie journal dir " + this.journalDirs[i]);
            }
            String[] ledgerDirs = baseConf.getLedgerDirWithoutDefault();
            if (null == ledgerDirs || 0 == ledgerDirs.length) {
                ledgerDirs = new String[]{this.journalDirs[i].getPath()};
            } else {
                for (int l = 0; l < ledgerDirs.length; ++l) {
                    File dir = new File(ledgerDirs[l], "bookie" + Integer.toString(i));
                    if (dir.exists()) {
                        if (dir.isDirectory()) {
                            FileUtils.deleteDirectory((File)dir);
                        } else if (!dir.delete()) {
                            throw new IOException("Couldn't cleanup bookie ledger dir " + dir);
                        }
                    }
                    if (!dir.mkdirs()) {
                        throw new IOException("Couldn't create bookie ledger dir " + dir);
                    }
                    ledgerDirs[l] = dir.getPath();
                }
            }
            this.bsConfs[i] = new ServerConfiguration(baseConf);
            if (0 == this.initialPort) {
                this.bsConfs[i].setBookiePort(0);
            } else {
                this.bsConfs[i].setBookiePort(this.initialPort + i);
            }
            if (null == baseConf.getZkServers()) {
                this.bsConfs[i].setZkServers(InetAddress.getLocalHost().getHostAddress() + ":" + ZooKeeperDefaultPort);
            }
            this.bsConfs[i].setJournalDirName(this.journalDirs[i].getPath());
            this.bsConfs[i].setLedgerDirNames(ledgerDirs);
            this.bs[i] = new BookieServer(this.bsConfs[i]);
            this.bs[i].start();
        }
    }

    public static void startLocalBookies(String zkHost, int zkPort, int numBookies, boolean shouldStartZK, int initialBookiePort) throws Exception {
        ServerConfiguration conf = new ServerConfiguration();
        LocalBookKeeper.startLocalBookiesInternal(conf, zkHost, zkPort, numBookies, shouldStartZK, initialBookiePort, true, "test");
    }

    public static void startLocalBookies(String zkHost, int zkPort, int numBookies, boolean shouldStartZK, int initialBookiePort, ServerConfiguration conf) throws Exception {
        LocalBookKeeper.startLocalBookiesInternal(conf, zkHost, zkPort, numBookies, shouldStartZK, initialBookiePort, true, "test");
    }

    public static void startLocalBookies(String zkHost, int zkPort, int numBookies, boolean shouldStartZK, int initialBookiePort, String dirSuffix) throws Exception {
        ServerConfiguration conf = new ServerConfiguration();
        LocalBookKeeper.startLocalBookiesInternal(conf, zkHost, zkPort, numBookies, shouldStartZK, initialBookiePort, true, dirSuffix);
    }

    static void startLocalBookiesInternal(ServerConfiguration conf, String zkHost, int zkPort, int numBookies, boolean shouldStartZK, int initialBookiePort, boolean stopOnExit, String dirSuffix) throws Exception {
        LocalBookKeeper lb = new LocalBookKeeper(numBookies, initialBookiePort);
        ZooKeeperServerShim zks = null;
        File zkTmpDir = null;
        List<File> bkTmpDirs = null;
        try {
            try {
                if (shouldStartZK) {
                    zkTmpDir = IOUtils.createTempDir("zookeeper", dirSuffix);
                    zks = LocalBookKeeper.runZookeeper(1000, zkPort, zkTmpDir);
                }
                lb.initializeZookeeper(zkHost, zkPort);
                conf.setZkServers(zkHost + ":" + zkPort);
                bkTmpDirs = lb.runBookies(conf, dirSuffix);
                try {
                    while (true) {
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException ie) {
                    if (stopOnExit) {
                        lb.shutdownBookies();
                        if (null != zks) {
                            zks.stop();
                        }
                    }
                    throw ie;
                }
            }
            catch (Exception e) {
                LOG.error("Failed to run {} bookies : zk ensemble = '{}:{}'", new Object[]{numBookies, zkHost, zkPort, e});
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (stopOnExit) {
                LocalBookKeeper.cleanupDirectories(bkTmpDirs);
                if (null != zkTmpDir) {
                    FileUtils.deleteDirectory((File)zkTmpDir);
                }
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception, SecurityException {
        if (args.length < 1) {
            LocalBookKeeper.usage();
            System.exit(-1);
        }
        int numBookies = Integer.parseInt(args[0]);
        ServerConfiguration conf = new ServerConfiguration();
        if (args.length >= 2) {
            String confFile = args[1];
            try {
                conf.loadConf(new File(confFile).toURI().toURL());
                LOG.info("Using configuration file " + confFile);
            }
            catch (Exception e) {
                LOG.warn("Error loading configuration file " + confFile, (Throwable)e);
            }
        }
        LocalBookKeeper.startLocalBookiesInternal(conf, ZooKeeperDefaultHost, ZooKeeperDefaultPort, numBookies, true, BookieDefaultInitialPort, false, "test");
    }

    private static void usage() {
        System.err.println("Usage: LocalBookKeeper number-of-bookies");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitForServerUp(String hp, long timeout) {
        long start = MathUtils.now();
        String[] split = hp.split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        while (true) {
            try {
                Socket sock = new Socket(host, port);
                BufferedReader reader = null;
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes(Charsets.UTF_8));
                    outstream.flush();
                    reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), Charsets.UTF_8));
                    String line = reader.readLine();
                    if (line != null && line.startsWith("Zookeeper version:")) {
                        LOG.info("Server UP");
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    sock.close();
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                LOG.info("server " + hp + " not up " + e);
            }
            if (MathUtils.now() > start + timeout) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void shutdownBookies() {
        for (BookieServer bookieServer : this.bs) {
            bookieServer.shutdown();
        }
    }
}

